/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidirmanyxone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxone.BiDirMX1Person;
import ee.jakarta.tck.persistence.core.relationship.bidirmanyxone.BiDirMX1Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDirMX1Test1() throws Exception {
        this.logTrace("Begin biDirMX1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDirMX1Project project1 = new BiDirMX1Project(1L, "JavaEE", Float.valueOf(500.0f));
            BiDirMX1Person person1 = new BiDirMX1Person(1L, "Duke");
            BiDirMX1Person person2 = new BiDirMX1Person(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            this.logTrace("persisted Persons and Project");
            person1.setProject(project1);
            person2.setProject(project1);
            ArrayList<BiDirMX1Person> list = new ArrayList<BiDirMX1Person>();
            list.add(person1);
            list.add(person2);
            project1.setBiDirMX1Persons(list);
            this.getEntityManager().merge((Object)person1);
            this.logTrace("merged contents of Person1");
            this.getEntityManager().merge((Object)person2);
            this.logTrace("merged contents of Person2");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            boolean pass1 = false;
            boolean pass2 = false;
            this.getEntityTransaction().begin();
            BiDirMX1Project newProject = (BiDirMX1Project)this.getEntityManager().find(BiDirMX1Project.class, (Object)1L);
            if (newProject != null) {
                List<BiDirMX1Person> persons = newProject.getBiDirMX1Persons();
                for (BiDirMX1Person person : persons) {
                    if (person.getName().equals("Duke")) {
                        this.logTrace("Found Searched Person");
                        pass1 = true;
                        continue;
                    }
                    if (person.getName().equals("Foo")) {
                        this.logTrace("Found Searched Person");
                        pass2 = true;
                        continue;
                    }
                    this.logTrace("searched Person not Found");
                }
            } else {
                this.logTrace("searched Project not Found");
            }
            if (pass1 && pass2) {
                this.logTrace("biDirMX1Test1: Expected results received");
                pass = true;
            } else {
                this.logErr("Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("biDirMX1Test1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMX1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMX1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

