/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.field;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import ee.jakarta.tck.persistence.core.types.field.DataTypes;
import ee.jakarta.tck.persistence.core.types.field.DataTypes2;
import ee.jakarta.tck.persistence.core.types.field.UUIDType;
import jakarta.persistence.Query;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class Client
extends PMClientBase {
    private DataTypes d1;
    private DataTypes2 d2;
    private final Date dateId = this.getPKDate(2006, 4, 15);
    private final java.sql.Date dateValue = this.getSQLDate(2006, 4, 15);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void fieldTypeTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (!this.d1.getBooleanData()) {
                    this.d1.setBooleanData(true);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getBooleanData()) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest2() throws Exception {
        boolean pass = false;
        int newByte = 111;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getByteData() == 100) {
                    this.d1.setByteData((byte)111);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getByteData() == 111) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest3() throws Exception {
        boolean pass = false;
        int newChar = 98;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getCharacterData() == 'a') {
                    this.d1.setCharacterData('b');
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData() == 'b') {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest4() throws Exception {
        boolean pass = false;
        int newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getShortData() == 100) {
                    this.d1.setShortData((short)101);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData() == 101) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest5() throws Exception {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getIntData() == 300) {
                    this.d1.setIntData(500);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntData() == 500) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest6() throws Exception {
        boolean pass = false;
        long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getLongData() == 600L) {
                    this.d1.setLongData(600L);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData() == 600L) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest7() throws Exception {
        boolean pass = false;
        double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getDoubleData() == 50.0) {
                    this.d1.setDoubleData(80.0);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData() == 80.0) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest8() throws Exception {
        boolean pass = false;
        float expFloat = 1.0f;
        float floatRange = 2.0f;
        float newFloat = 6.0f;
        float newfloatRange = 7.0f;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("float value is: " + this.d1.getFloatData());
                if (this.d1.getFloatData() >= 1.0f && this.d1.getFloatData() < 2.0f) {
                    this.d1.setFloatData(6.0f);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData() >= 6.0f && this.d1.getFloatData() < 7.0f) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest8 failed");
        }
    }

    public void fieldTypeTest9() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataTypes is not null, setting enumData");
                this.d1.setEnumData(Grade.B);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("Update performed, check results");
                if (this.d1.getEnumData().equals((Object)Grade.B)) {
                    this.logTrace("Expected results received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results received");
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest9 failed");
        }
    }

    public void fieldTypeTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                if (this.d2.getId().equals(this.dateId)) {
                    this.logTrace("Got expected PK of:" + String.valueOf(this.d2.getId()) + "received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results. Expected " + String.valueOf(this.dateId) + ", got: " + String.valueOf(this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest11() throws Exception {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                byte[] a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + 5);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getByteArrayData(), a)) {
                    this.logTrace("Expected results received");
                    pass = true;
                } else {
                    this.logErr("Unexpected result in array comparison.");
                    for (byte aa : a) {
                        this.logTrace("Array a in propertyTest9 equals: " + aa);
                    }
                    for (byte bb : b) {
                        this.logTrace("Array b in propertyTest9 equals: " + bb);
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest12() throws Exception {
        boolean pass = false;
        char[] charData = new char[]{'c', 't', 's'};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting charData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    this.logTrace("Expected Results Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString(this.d1.getCharArrayData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest12 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest13() throws Exception {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTimeData().equals(timeValue)) {
                    this.logTrace("Expected Time Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.  Expected " + String.valueOf(timeValue) + " , got: " + String.valueOf(this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest13 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest14() throws Exception {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                if (this.d2.getTsData().equals(tsValue)) {
                    this.logTrace("Expected Timestamp Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.  Expected " + String.valueOf(tsValue) + " , got: " + String.valueOf(this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest14 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest15() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = ee.jakarta.tck.persistence.core.types.common.Grade.A");
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    this.logTrace("Expected results received");
                } else {
                    this.logErr("Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest15 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest16() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.A);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE dt.enumData = :grade").setParameter("grade", (Object)Grade.A);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    this.logTrace("Expected results received");
                } else {
                    this.logErr("Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldTypeTest17() throws Exception {
        boolean pass = false;
        Grade failingGrade = Grade.F;
        Grade incompleteGrade = Grade.INCOMPLETE;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                Query q = this.getEntityManager().createQuery("SELECT dt FROM DataTypes dt WHERE (dt.enumData <> ?1) OR (dt.enumData <> ?2) ").setParameter(1, (Object)failingGrade).setParameter(2, (Object)incompleteGrade);
                DataTypes result = (DataTypes)q.getSingleResult();
                if (this.d1 == result) {
                    pass = true;
                    this.logTrace("Expected results received");
                } else {
                    this.logErr("Did not get expected results.");
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("fieldTypeTest17 failed");
        }
    }

    public void testCreateUUIDType() throws Exception {
        UUID id = UUID.randomUUID();
        UUIDType uuidType = new UUIDType(id, "Create UUID Type");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)uuidType);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.getEntityManager().clear();
            UUIDType fromDb = (UUIDType)this.getEntityManager().find(UUIDType.class, (Object)id);
            System.out.println("UUID: " + fromDb.getId().toString());
            if (fromDb == null) {
                throw new Exception("testCreateUUIDType: no UUID was found in database");
            }
            if (!id.equals(fromDb.getId())) {
                throw new Exception("testCreateUUIDType: UUID returned from database " + String.valueOf(fromDb.getId()) + " does not match expected value " + String.valueOf(id));
            }
        }
        catch (Exception ex) {
            this.logErr("Caught exception: ", ex);
            throw new Exception("Caught exception: ", ex);
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
    }

    public void scalarExpressionsTest() throws Exception {
        DataTypes d;
        List p;
        char expected;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            expected = this.d1.getIntData() + 1;
            this.logTrace("Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where ((d.intData + 1) = ?1)").setParameter(1, (Object)expected).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                int actual = d.getIntData() + 1;
                if (actual == expected) {
                    this.logTrace("Received expected Integer data:" + actual);
                    pass1 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            expected = 'a';
            this.logTrace("Testing string expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.characterData = ?1)").setParameter(1, (Object)Character.valueOf(expected)).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Character actual = Character.valueOf(d.getCharacterData());
                if (actual.equals(Character.valueOf(expected))) {
                    this.logTrace("Received expected Character data:" + actual);
                    pass2 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            Grade expected2 = Grade.C;
            this.logTrace("Testing enum expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.enumData = ?1)").setParameter(1, (Object)expected2).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Grade actual = d.getEnumData();
                if (actual.equals((Object)expected2)) {
                    this.logTrace("Received expected Enum data:" + String.valueOf((Object)actual));
                    pass3 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + String.valueOf((Object)expected2) + ", actual:" + String.valueOf((Object)actual));
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            Date dateValue = this.getPKDate(2006, 1, 1);
            Date expected3 = this.dateId;
            this.getEntityTransaction().begin();
            this.logTrace("Testing datetime expression:");
            List pp = this.getEntityManager().createQuery("Select d From DataTypes2 d where (d.dateData > ?1)").setParameter(1, (Object)dateValue).getResultList();
            if (pp.size() == 1) {
                DataTypes2 d2 = (DataTypes2)pp.get(0);
                this.logTrace("DataType2:" + d2.toString());
                Date actual = d2.getDateData();
                if (actual.equals(expected3)) {
                    this.logTrace("Received expected Date data:" + String.valueOf(actual));
                    pass4 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + String.valueOf(expected3) + ", actual:" + String.valueOf(actual));
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + pp.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            boolean expected4 = false;
            this.logTrace("Testing boolean expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.booleanData = ?1)").setParameter(1, (Object)expected4).getResultList();
            if (p.size() > 0) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Boolean actual = d.getBooleanData();
                if (actual.equals(expected4)) {
                    this.logTrace("Received expected Boolean data:" + actual);
                    pass5 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected4 + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("scalarExpressionsTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, false, 100, 'a', 100, 300, 600L, 50.0, 1.0f, cArray, bArray);
            this.d1.setEnumData(Grade.C);
            this.logTrace("dateId is: " + String.valueOf(this.dateId));
            this.d2 = new DataTypes2(this.dateId);
            this.d2.setDateData(this.dateValue);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UUIDTYPE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

