/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.ee.entityManagerFactory.Order;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties props = null;

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.removeTestData();
        this.logTrace("done cleanup, calling super.cleanup");
        super.cleanup();
    }

    public void createEntityManagerFactoryStringTest() throws Exception {
        boolean pass = false;
        try {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
            if (emf != null) {
                this.logTrace("Received non-null EntityManagerFactory");
                pass = true;
            } else {
                this.logErr("Received null EntityManagerFactory");
            }
        }
        catch (Exception e) {
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("createEntityManagerFactoryStringTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderTestData() {
        try {
            this.getEntityTransaction().begin();
            Order[] orders = new Order[]{new Order(1, 111), new Order(2, 222), new Order(3, 333), new Order(4, 444), new Order(5, 555)};
            for (Order o : orders) {
                this.logTrace("Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

