/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.connection;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class connectionClient1
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_tx_param = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private String uname = null;
    private String password = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        connectionClient1 theTests = new connectionClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_tx_param = p.getProperty("whitebox-tx-param");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_tx_param);
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"###", (Throwable)e);
            throw new Exception("Exception constructing DBSupport object: " + e.getMessage());
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_tx_param);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"####", (Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testGetConnection1() throws Exception {
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logMsg((String)"Got connection from the DataSource.");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logErr((String)"Exception caught on creating connection.", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"###", (Throwable)e);
            throw new Exception(e.getMessage());
        }
        TestUtil.logMsg((String)"Checking for Connection Validity.");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            TestUtil.logErr((String)"Exception inserting into table.", (Throwable)sqle);
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            TestUtil.logErr((String)"Exception dropping table.", (Throwable)sqle);
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
    }

    public void testgetConnectionWithParameter1() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.ds2.clearLog();
            TestUtil.logMsg((String)"Got RA log.");
            this.ds2.setLogFlag(true);
            this.con = this.ds2.getConnection(this.uname, this.password);
            this.ds2.setLogFlag(false);
            log = this.ds2.getLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "LocalTxManagedConnectionFactory";
        String toCheck2 = "TSManagedConnection";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new Exception("Failed: couldn't find...");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            TestUtil.logMsg((String)"Exception inserting into table.");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            TestUtil.logMsg((String)"Exception dropping table.");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
    }

    public void testAPIResourceException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        boolean b6 = false;
        boolean b7 = false;
        boolean b8 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ResourceException(null) passed";
        String toCheck2 = "ResourceException(str) passed";
        String toCheck3 = "ResourceException.setErrorCode(str) passed";
        String toCheck4 = "ResourceException(str, str) passed";
        String toCheck5 = "ResourceException(throwable) passed";
        String toCheck6 = "ResourceException(str, someThrowable) passed";
        String toCheck7 = "ResourceException.getMessage() passed";
        String toCheck8 = "ResourceException.getErrorCode() passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (str.startsWith(toCheck5)) {
                b5 = true;
            }
            if (str.startsWith(toCheck6)) {
                b6 = true;
            }
            if (str.startsWith(toCheck7)) {
                b7 = true;
            }
            if (!str.startsWith(toCheck8)) continue;
            b8 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5 && b6 && b7 && b8)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            if (!b6) {
                err = (String)err + "b6 failed, ";
            }
            if (!b7) {
                err = (String)err + "b7 failed, ";
            }
            if (!b8) {
                err = (String)err + "b8 failed, ";
            }
            throw new Exception("ResourceException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ResourceException API assertions passed");
    }

    public void testAPINotSupportedException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "NotSupportedException(null) passed";
        String toCheck2 = "NotSupportedException(str) passed";
        String toCheck3 = "NotSupportedException(str, str) passed";
        String toCheck4 = "NotSupportedException(throwable) passed";
        String toCheck5 = "NotSupportedException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("NotSupportedException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"NotSupportedException API assertions passed");
    }

    public void testAPILocalTransactionException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "LocalTransactionException(null) passed";
        String toCheck2 = "LocalTransactionException(str) passed";
        String toCheck3 = "LocalTransactionException(str, str) passed";
        String toCheck4 = "LocalTransactionException(throwable) passed";
        String toCheck5 = "LocalTransactionException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("LocalTransactionException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"LocalTransactionException API assertions passed");
    }

    public void testAPIResourceAllocationException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ResourceAllocationException(null) passed";
        String toCheck2 = "ResourceAllocationException(str) passed";
        String toCheck3 = "ResourceAllocationException(str, str) passed";
        String toCheck4 = "ResourceAllocationException(throwable) passed";
        String toCheck5 = "ResourceAllocationException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("ResourceAllocationException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ResourceAllocationException API assertions passed");
    }

    public void testAPIResourceAdapterInternalException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ResourceAdapterInternalException(null) passed";
        String toCheck2 = "ResourceAdapterInternalException(str) passed";
        String toCheck3 = "ResourceAdapterInternalException(str, str) passed";
        String toCheck4 = "ResourceAdapterInternalException(throwable) passed";
        String toCheck5 = "ResourceAdapterInternalException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("ResourceAdapterInternalException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ResourceAdapterInternalException API assertions passed");
    }

    public void testAPISecurityException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "SecurityException(null) passed";
        String toCheck2 = "SecurityException(str) passed";
        String toCheck3 = "SecurityException(str, str) passed";
        String toCheck4 = "SecurityException(throwable) passed";
        String toCheck5 = "SecurityException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("SecurityException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"SecurityException API assertions passed");
    }

    public void testAPISharingViolationException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "SharingViolationException(null) passed";
        String toCheck2 = "SharingViolationException(str) passed";
        String toCheck3 = "SharingViolationException(str, str) passed";
        String toCheck4 = "SharingViolationException(throwable) passed";
        String toCheck5 = "SharingViolationException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("SharingViolationException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"SharingViolationException API assertions passed");
    }

    public void testAPIUnavailableException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "UnavailableException(null) passed";
        String toCheck2 = "UnavailableException(str) passed";
        String toCheck3 = "UnavailableException(str, str) passed";
        String toCheck4 = "UnavailableException(throwable) passed";
        String toCheck5 = "UnavailableException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("UnavailableException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"UnavailableException API assertions passed");
    }

    public void testAPIWorkException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "WorkException(null) passed";
        String toCheck2 = "WorkException(str) passed";
        String toCheck3 = "WorkException(str, str) passed";
        String toCheck4 = "WorkException(throwable) passed";
        String toCheck5 = "WorkException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("WorkException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"WorkException API assertions passed");
    }

    public void testAPIWorkCompletedException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "WorkCompletedException(null) passed";
        String toCheck2 = "WorkCompletedException(str) passed";
        String toCheck3 = "WorkCompletedException(str, str) passed";
        String toCheck4 = "WorkCompletedException(throwable) passed";
        String toCheck5 = "WorkCompletedException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("WorkCompletedException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"WorkCompletedException API assertions passed");
    }

    public void testAPIWorkRejectedException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "WorkRejectedException(null) passed";
        String toCheck2 = "WorkRejectedException(str) passed";
        String toCheck3 = "WorkRejectedException(str, str) passed";
        String toCheck4 = "WorkRejectedException(throwable) passed";
        String toCheck5 = "WorkRejectedException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("WorkRejectedException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"WorkRejectedException API assertions passed");
    }

    public void testAPIEISSystemException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "EISSystemException(null) passed";
        String toCheck2 = "EISSystemException(str) passed";
        String toCheck3 = "EISSystemException(str, str) passed";
        String toCheck4 = "EISSystemException(throwable) passed";
        String toCheck5 = "EISSystemException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("EISSystemException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"EISSystemException API assertions passed");
    }

    public void testAPIApplicationServerInternalException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ApplicationServerInternalException(null) passed";
        String toCheck2 = "ApplicationServerInternalException(str) passed";
        String toCheck3 = "ApplicationServerInternalException(str, str) passed";
        String toCheck4 = "ApplicationServerInternalException(throwable) passed";
        String toCheck5 = "ApplicationServerInternalException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("ApplicationServerInternalException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ApplicationServerInternalException API assertions passed");
    }

    public void testAPICommException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "CommException(null) passed";
        String toCheck2 = "CommException(str) passed";
        String toCheck3 = "CommException(str, str) passed";
        String toCheck4 = "CommException(throwable) passed";
        String toCheck5 = "CommException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("CommException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"CommException API assertions passed");
    }

    public void testAPIRetryableWorkRejectedException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "RetryableWorkRejectedException(null) passed";
        String toCheck2 = "RetryableWorkRejectedException(str) passed";
        String toCheck3 = "RetryableWorkRejectedException(str, str) passed";
        String toCheck4 = "RetryableWorkRejectedException(throwable) passed";
        String toCheck5 = "RetryableWorkRejectedException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("RetryableWorkRejectedException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"RetryableWorkRejectedException API assertions passed");
    }

    public void testAPIIllegalStateException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "IllegalStateException(null) passed";
        String toCheck2 = "IllegalStateException(str) passed";
        String toCheck3 = "IllegalStateException(str, str) passed";
        String toCheck4 = "IllegalStateException(throwable) passed";
        String toCheck5 = "IllegalStateException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("IllegalStateException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"IllegalStateException API assertions passed");
    }

    public void testAPIRetryableUnavailableException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "RetryableUnavailableException(null) passed";
        String toCheck2 = "RetryableUnavailableException(str) passed";
        String toCheck3 = "RetryableUnavailableException(str, str) passed";
        String toCheck4 = "RetryableUnavailableException(throwable) passed";
        String toCheck5 = "RetryableUnavailableException(str, throwable) passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("RetryableUnavailableException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"RetryableUnavailableException API assertions passed");
    }

    public void testAPIManagedConnectionMetaData() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ManagedConnectionMetaData.getEISProductName() passed";
        String toCheck2 = "ManagedConnectionMetaData.getEISProductVersion() passed";
        String toCheck3 = "ManagedConnectionMetaData.getMaxConnections() passed";
        String toCheck4 = "ManagedConnectionMetaData.getUserName() passed";
        String toCheck5 = "Connection.getMetaData() passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (!str.startsWith(toCheck5)) continue;
            b5 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            throw new Exception("EISSystemException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ManagedConnectionMetaData API assertions passed");
    }

    public void testAPIManagedConnection() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "ManagedConnection.getLogWriter() passed";
        String toCheck2 = "ManagedConnection.getMetaData() passed";
        String toCheck3 = "ManagedConnection.getLocalTransaction() passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (!(b1 && b2 && b3)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            throw new Exception("EISSystemException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"ManagedConnectionMetaData API assertions passed");
    }

    public void testAPIInvalidPropertyException() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        boolean b5 = false;
        boolean b6 = false;
        boolean b7 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "InvalidPropertyException(null) passed";
        String toCheck2 = "InvalidPropertyException(str) passed";
        String toCheck3 = "InvalidPropertyException(str, str) passed";
        String toCheck4 = "InvalidPropertyException(throwable) passed";
        String toCheck5 = "InvalidPropertyException(str, throwable) passed";
        String toCheck6 = "InvalidPropertyException.setInvalidPropertyDescriptors() passed";
        String toCheck7 = "InvalidPropertyException.getInvalidPropertyDescriptors() passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (str.startsWith(toCheck4)) {
                b4 = true;
            }
            if (str.startsWith(toCheck5)) {
                b5 = true;
            }
            if (str.startsWith(toCheck6)) {
                b6 = true;
            }
            if (!str.startsWith(toCheck7)) continue;
            b7 = true;
        }
        if (!(b1 && b2 && b3 && b4 && b5 && b6 && b7)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            if (!b5) {
                err = (String)err + "b5 failed, ";
            }
            if (!b6) {
                err = (String)err + "b6 failed, ";
            }
            if (!b7) {
                err = (String)err + "b7 failed, ";
            }
            throw new Exception("InvalidPropertyException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"InvalidPropertyException API assertions passed");
    }

    public void testAPIHintsContext() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        boolean b4 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            this.con = this.ds1.getConnection();
            TestUtil.logTrace((String)"Got connection.");
            log = this.ds1.getStateLog();
            TestUtil.logMsg((String)"Got RA log.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            TestUtil.printStackTrace((Throwable)sqle);
            throw new Exception(sqle.getMessage());
        }
        String toCheck1 = "HintsContext() passed";
        String toCheck2 = "HintsContext.setName() and HintsContext.getName() passed";
        String toCheck3 = "HintsContext.setDescription() and HintsContext.getDescription() passed";
        String toCheck4 = "HintsContext.setHints() and HintsContext.getHints() passed";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (str.startsWith(toCheck2)) {
                b2 = true;
            }
            if (str.startsWith(toCheck3)) {
                b3 = true;
            }
            if (!str.startsWith(toCheck4)) continue;
            b4 = true;
        }
        if (!(b1 && b2 && b3 && b4)) {
            Object err = "";
            if (!b1) {
                err = "b1 failed, ";
            }
            if (!b2) {
                err = (String)err + "b2 failed, ";
            }
            if (!b3) {
                err = (String)err + "b3 failed, ";
            }
            if (!b4) {
                err = (String)err + "b4 failed, ";
            }
            throw new Exception("InvalidPropertyException API assertions failed: " + (String)err);
        }
        TestUtil.logMsg((String)"InvalidPropertyException API assertions passed");
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"Cleanup");
        try {
            this.con.close();
        }
        catch (Exception sqle) {
            TestUtil.printStackTrace((Throwable)sqle);
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()));
        }
    }
}

