/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.connectionfactorytests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.connectionfactorytests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient QueueConnectionFactory qcf = null;
    private transient TopicConnectionFactory tcf = null;
    private transient JMSContext context = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;
    String vehicle = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.connections = new ArrayList(5);
            this.vehicle = p.getProperty("vehicle");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
    }

    public void qcfCreateJMSContextTest1() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createContext()");
            this.context = this.qcf.createContext();
            TestUtil.logMsg((String)"Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode)));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateJMSContextTest1");
        }
        if (!pass) {
            throw new Exception("qcfCreateJMSContextTest1 failed");
        }
    }

    public void qcfCreateJMSContextTest3() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createContext(String, String)");
            this.context = this.qcf.createContext(this.user, this.password);
            TestUtil.logMsg((String)"Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode)));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateJMSContextTest3");
        }
        if (!pass) {
            throw new Exception("qcfCreateJMSContextTest3 failed");
        }
    }

    public void qcfCreateConnectionTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createQueueConnection()");
            QueueConnection qc = this.qcf.createQueueConnection();
            qc.close();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createQueueConnection(String, String) with valid credentials");
            qc = this.qcf.createQueueConnection(this.user, this.password);
            qc.close();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createConnection()");
            Connection c = this.qcf.createConnection();
            c.close();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createConnection(String, String) with valid credentials");
            c = this.qcf.createConnection(this.user, this.password);
            c.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("qcfCreateConnectionTest");
        }
        if (!pass) {
            throw new Exception("qcfCreateConnectionTest failed");
        }
    }

    public void tcfCreateJMSContextTest1() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createContext()");
            this.context = this.tcf.createContext();
            TestUtil.logMsg((String)"Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode)));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("tcfCreateJMSContextTest1");
        }
        if (!pass) {
            throw new Exception("tcfCreateJMSContextTest1 failed");
        }
    }

    public void tcfCreateJMSContextTest3() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createContext(String, String)");
            this.context = this.tcf.createContext(this.user, this.password);
            TestUtil.logMsg((String)"Verify that JMSContext.getSessionMode() returns JMSContext.AUTO_ACKNOWLEDGE");
            int expSessionMode = 1;
            int actSessionMode = this.context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                TestUtil.logErr((String)("getSessionMode() returned " + this.printSessionMode(actSessionMode) + ", expected " + this.printSessionMode(expSessionMode)));
                pass = false;
            }
            this.context.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("tcfCreateJMSContextTest3");
        }
        if (!pass) {
            throw new Exception("tcfCreateJMSContextTest3 failed");
        }
    }

    public void tcfCreateConnectionTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createTopicConnection()");
            TopicConnection tc = this.tcf.createTopicConnection();
            tc.close();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createTopicConnection(String, String) with valid credentials");
            tc = this.tcf.createTopicConnection(this.user, this.password);
            tc.close();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createConnection()");
            Connection c = this.tcf.createConnection();
            c.close();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createConnection(String, String) with valid credentials");
            c = this.tcf.createConnection(this.user, this.password);
            c.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            throw new Exception("tcfCreateConnectionTest");
        }
        if (!pass) {
            throw new Exception("tcfCreateConnectionTest failed");
        }
    }

    public void createConnectionExceptionTests() throws Exception {
        QueueConnection c;
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createQueueConnection(String, String) with invalid credentials");
            TestUtil.logMsg((String)"Verify JMSSecurityException is thrown");
            c = this.qcf.createQueueConnection("invalid", "invalid");
            TestUtil.logErr((String)"Didn't throw expected JMSSecurityException");
            pass = false;
            c.close();
        }
        catch (JMSSecurityException e) {
            TestUtil.logMsg((String)"Caught expected JMSSecurityException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Expected JMSSecurityException, received " + String.valueOf(e)));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createTopicConnection(String, String) with invalid credentials");
            TestUtil.logMsg((String)"Verify JMSSecurityException is thrown");
            c = this.tcf.createTopicConnection("invalid", "invalid");
            TestUtil.logErr((String)"Didn't throw expected JMSSecurityException");
            pass = false;
            c.close();
        }
        catch (JMSSecurityException e) {
            TestUtil.logMsg((String)"Caught expected JMSSecurityException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            pass = false;
        }
        if (!pass) {
            throw new Exception("createConnectionExceptionTests failed");
        }
    }

    public void createJMSContextExceptionTests() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for QUEUE_FACTORY");
            this.tool = new JmsTool(7, this.user, this.password, this.mode);
            this.qcf = this.tool.getQueueConnectionFactory();
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createContext(String, String) with bad credentials");
            TestUtil.logMsg((String)"Verify JMSRuntimeSecurityException is thrown");
            try {
                this.context = this.qcf.createContext("invalid", "invalid");
                TestUtil.logErr((String)"Didn't throw expected JMSSecurityRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSSecurityRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected JMSRuntimeSecurityException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSSecurityRuntimeException, received " + String.valueOf(e)));
                pass = false;
            }
            TestUtil.logMsg((String)"Test QueueConnectionFactory.createContext(int) with bad session mode");
            TestUtil.logMsg((String)"Verify JMSRuntimeException is thrown");
            try {
                this.context = this.qcf.createContext(-1);
                TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSRuntimeException, received " + String.valueOf(e)));
                pass = false;
            }
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC_FACTORY");
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            this.tcf = this.tool.getTopicConnectionFactory();
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createContext(String, String) with bad credentials");
            TestUtil.logMsg((String)"Verify JMSSecurityRuntimeException is thrown");
            try {
                this.context = this.tcf.createContext("invalid", "invalid");
                TestUtil.logErr((String)"Didn't throw expected JMSSecurityRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSSecurityRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected JMSRuntimeSecurityException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + String.valueOf(e)));
                pass = false;
            }
            TestUtil.logMsg((String)"Test TopicConnectionFactory.createContext(int) with bad session mode");
            TestUtil.logMsg((String)"Verify JMSRuntimeException is thrown");
            try {
                this.context = this.tcf.createContext(-1);
                TestUtil.logErr((String)"Didn't throw expected JMSRuntimeException");
                pass = false;
                this.context.close();
            }
            catch (JMSRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + String.valueOf(e)));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + String.valueOf(e)));
            throw new Exception("createJMSContextExceptionTests");
        }
        if (!pass) {
            throw new Exception("createJMSContextExceptionTests failed");
        }
    }
}

