/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00ExtendedEntry
extends DraftChuLDAPLogSchema00Entry {
    public static final String ATTR_REQUEST_VALUE = "reqData";
    private static final long serialVersionUID = 3767074068423424660L;
    private final ASN1OctetString requestValue;
    private final String requestOID;

    public DraftChuLDAPLogSchema00ExtendedEntry(Entry entry) throws LDAPException {
        super(entry, OperationType.EXTENDED);
        String requestType = entry.getAttributeValue("reqType");
        String lowerRequestType = StaticUtils.toLowerCase(requestType);
        if (!lowerRequestType.startsWith("extended") || lowerRequestType.length() <= 8) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_EXTENDED_MALFORMED_REQ_TYPE.get(entry.getDN(), "reqType", requestType));
        }
        this.requestOID = requestType.substring(8);
        byte[] requestValueBytes = entry.getAttributeValueBytes(ATTR_REQUEST_VALUE);
        this.requestValue = requestValueBytes == null ? null : new ASN1OctetString(-117, requestValueBytes);
    }

    public String getRequestOID() {
        return this.requestOID;
    }

    public ASN1OctetString getRequestValue() {
        return this.requestValue;
    }

    public ExtendedRequest toExtendedRequest() {
        return new ExtendedRequest(this.requestOID, this.requestValue, this.getRequestControlArray());
    }
}

