/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HtmlUnitBrowserCompatCookieSpec;
import com.gargoylesoftware.htmlunit.HtmlUnitCookieStore;
import com.gargoylesoftware.htmlunit.HtmlUnitSSLConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.SocksConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.IgnoreSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.impl.cookie.RFC2965SpecFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class HttpWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(HttpWebConnection.class);
    private static final String HACKED_COOKIE_POLICY = "mine";
    private HttpClientBuilder httpClientBuilder_;
    private final WebClient webClient_;
    private final HttpContext httpContext_;
    private String virtualHost_;
    private final CookieSpecProvider htmlUnitCookieSpecProvider_;
    private final WebClientOptions usedOptions_;
    private PoolingHttpClientConnectionManager connectionManager_;
    private static final long MAX_IN_MEMORY = 512000L;

    public HttpWebConnection(final WebClient webClient) {
        this.webClient_ = webClient;
        this.htmlUnitCookieSpecProvider_ = new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new HtmlUnitBrowserCompatCookieSpec(webClient.getBrowserVersion());
            }
        };
        this.httpContext_ = new HttpClientContext();
        this.usedOptions_ = new WebClientOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        HttpClientBuilder builder = this.reconfigureHttpClientIfNeeded(this.getHttpClientBuilder());
        if (this.connectionManager_ == null) {
            this.connectionManager_ = this.createConnectionManager(builder);
        }
        builder.setConnectionManager((HttpClientConnectionManager)this.connectionManager_);
        HttpUriRequest httpMethod = null;
        try {
            try {
                httpMethod = this.makeHttpMethod(request);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create URI from URL: " + url.toExternalForm() + " (reason: " + e.getMessage() + ")", e);
            }
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            long startTime = System.currentTimeMillis();
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = builder.build().execute(hostConfiguration, (HttpRequest)httpMethod, this.httpContext_);
            }
            catch (SSLPeerUnverifiedException s) {
                if (this.webClient_.getOptions().isUseInsecureSSL()) {
                    HtmlUnitSSLConnectionSocketFactory.setUseSSL3Only(this.httpContext_, true);
                    httpResponse = builder.build().execute(hostConfiguration, (HttpRequest)httpMethod, this.httpContext_);
                }
                throw s;
            }
            catch (Error e) {
                HttpWebConnection httpWebConnection = this;
                synchronized (httpWebConnection) {
                    this.httpClientBuilder_ = null;
                }
                throw e;
            }
            DownloadedContent downloadedBody = this.downloadResponseBody((HttpResponse)httpResponse);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse((HttpResponse)httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) {
        URL url = webRequest.getUrl();
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    private void setProxy(HttpRequestBase httpRequest, WebRequest webRequest) {
        RequestConfig.Builder requestBuilder = this.createRequestConfigBuilder(this.getTimeout());
        if (webRequest.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(webRequest.getProxyHost(), webRequest.getProxyPort());
            if (webRequest.isSocksProxy()) {
                SocksConnectionSocketFactory.setSocksProxy(this.httpContext_, proxy);
            } else {
                requestBuilder.setProxy(proxy);
                httpRequest.setConfig(requestBuilder.build());
            }
        } else {
            requestBuilder.setProxy(null);
            httpRequest.setConfig(requestBuilder.build());
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest) throws IOException, URISyntaxException {
        Credentials requestCredentials;
        String charset = webRequest.getCharset();
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false, charset);
        URI uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)this.escapeQuery(url.getQuery()), null);
        if (this.getVirtualHost() != null) {
            uri = URI.create(this.getVirtualHost());
        }
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        this.setProxy(httpMethod, webRequest);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)query, null);
                httpMethod.setURI(uri);
            }
        } else {
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)httpMethod;
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                HttpPost postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                    StringEntity urlEncodedEntity = new StringEntity(query, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                } else {
                    String body = StringUtils.defaultString((String)webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity(body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                Charset c = this.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setLaxMode();
                builder.setCharset(c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        this.buildFilePart((KeyDataPair)pair, builder);
                        continue;
                    }
                    builder.addTextBody(pair.getName(), pair.getValue(), ContentType.create((String)"text/plain", (String)charset));
                }
                method.setEntity(builder.build());
            } else {
                String body = webRequest.getRequestBody();
                if (body != null) {
                    method.setEntity((HttpEntity)new StringEntity(body, charset));
                }
            }
        }
        if (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_HOST_FIRST)) {
            int port = webRequest.getUrl().getPort();
            StringBuilder host = new StringBuilder(webRequest.getUrl().getHost());
            if (port != 80 && port > 0) {
                host.append(':');
                host.append(Integer.toString(port));
            }
            httpMethod.setHeader((Header)new BasicHeader("Host", host.toString()));
        }
        httpMethod.setHeader((Header)new BasicHeader("User-Agent", this.webClient_.getBrowserVersion().getUserAgent()));
        if (this.webClient_.getOptions().isDoNotTrackEnabled()) {
            httpMethod.setHeader((Header)new BasicHeader("DNT", "1"));
        }
        HttpWebConnection.writeRequestHeadersToHttpMethod((HttpUriRequest)httpMethod, webRequest.getAdditionalHeaders());
        HttpClientBuilder httpClient = this.getHttpClientBuilder();
        CredentialsProvider credentialsProvider = this.webClient_.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
            this.httpContext_.removeAttribute("http.auth.target-scope");
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
            this.httpContext_.removeAttribute("http.auth.target-scope");
        }
        httpClient.setDefaultCredentialsProvider(credentialsProvider);
        this.httpContext_.removeAttribute("http.auth.credentials-provider");
        return httpMethod;
    }

    private String escapeQuery(String query) {
        if (query == null) {
            return null;
        }
        return query.replace("%%", "%25%25");
    }

    private Charset getCharset(String charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return Charset.forName(charset);
            }
        }
        return null;
    }

    void buildFilePart(KeyDataPair pairWithFile, MultipartEntityBuilder builder) throws IOException {
        String mimeType = pairWithFile.getMimeType();
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ContentType contentType = ContentType.create((String)mimeType);
        File file = pairWithFile.getFile();
        if (pairWithFile.getData() != null) {
            String filename = file == null ? pairWithFile.getValue() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? file.getAbsolutePath() : file.getName());
            builder.addBinaryBody(pairWithFile.getName(), (InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, filename);
            return;
        }
        if (file == null) {
            builder.addPart(pairWithFile.getName(), (ContentBody)new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, pairWithFile.getValue()){

                public long getContentLength() {
                    return 0L;
                }
            });
            return;
        }
        String filename = pairWithFile.getFile() == null ? pairWithFile.getValue() : (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH) ? pairWithFile.getFile().getAbsolutePath() : pairWithFile.getFile().getName());
        builder.addBinaryBody(pairWithFile.getName(), pairWithFile.getFile(), contentType, filename);
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpGet method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected synchronized HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder_ == null) {
            this.httpClientBuilder_ = this.createHttpClient();
            RegistryBuilder registeryBuilder = RegistryBuilder.create().register("best-match", (Object)new BestMatchSpecFactory()).register("standard", (Object)new RFC2965SpecFactory()).register("compatibility", (Object)new BrowserCompatSpecFactory()).register("netscape", (Object)new NetscapeDraftSpecFactory()).register("ignoreCookies", (Object)new IgnoreSpecFactory()).register("rfc2109", (Object)new RFC2109SpecFactory()).register("rfc2965", (Object)new RFC2965SpecFactory());
            registeryBuilder.register(HACKED_COOKIE_POLICY, (Object)this.htmlUnitCookieSpecProvider_);
            this.httpClientBuilder_.setDefaultCookieSpecRegistry((Lookup)registeryBuilder.build());
            this.httpClientBuilder_.setDefaultCookieStore((CookieStore)new HtmlUnitCookieStore(this.webClient_.getCookieManager()));
        }
        return this.httpClientBuilder_;
    }

    protected int getTimeout() {
        return this.webClient_.getOptions().getTimeout();
    }

    protected HttpClientBuilder createHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return super.isRedirected(request, response, context) && response.getFirstHeader("location") != null;
            }
        });
        this.configureTimeout(builder, this.getTimeout());
        builder.setMaxConnPerRoute(6);
        return builder;
    }

    private void configureTimeout(HttpClientBuilder builder, int timeout) {
        RequestConfig.Builder requestBuilder = this.createRequestConfigBuilder(timeout);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setDefaultSocketConfig(this.createSocketConfigBuilder(timeout).build());
        this.httpContext_.removeAttribute("http.request-config");
        this.usedOptions_.setTimeout(timeout);
    }

    private RequestConfig.Builder createRequestConfigBuilder(int timeout) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCookieSpec(HACKED_COOKIE_POLICY).setRedirectsEnabled(false).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        return requestBuilder;
    }

    private SocketConfig.Builder createSocketConfigBuilder(int timeout) {
        SocketConfig.Builder socketBuilder = SocketConfig.custom().setSoTimeout(timeout);
        return socketBuilder;
    }

    private HttpClientBuilder reconfigureHttpClientIfNeeded(HttpClientBuilder httpClientBuilder) {
        int timeout;
        WebClientOptions options = this.webClient_.getOptions();
        if (options.isUseInsecureSSL() != this.usedOptions_.isUseInsecureSSL() || options.getSSLClientCertificateUrl() != this.usedOptions_.getSSLClientCertificateUrl() || options.getProxyConfig() != this.usedOptions_.getProxyConfig()) {
            this.configureHttpsScheme(httpClientBuilder);
        }
        if ((timeout = this.getTimeout()) != this.usedOptions_.getTimeout()) {
            this.configureTimeout(httpClientBuilder, timeout);
        }
        return httpClientBuilder;
    }

    private void configureHttpsScheme(HttpClientBuilder builder) {
        WebClientOptions options = this.webClient_.getOptions();
        SSLConnectionSocketFactory socketFactory = HtmlUnitSSLConnectionSocketFactory.buildSSLSocketFactory(options);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        this.usedOptions_.setUseInsecureSSL(options.isUseInsecureSSL());
        this.usedOptions_.setSSLClientCertificate(options.getSSLClientCertificateUrl(), options.getSSLClientCertificatePassword(), options.getSSLClientCertificateType());
        this.usedOptions_.setProxyConfig(options.getProxyConfig());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        return HttpWebConnection.downloadContent(httpEntity.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadedContent downloadContent(InputStream is) throws IOException {
        if (is == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int nbRead;
            while ((nbRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, nbRead);
                if ((long)bos.size() <= 512000L) continue;
                File file = File.createTempFile("htmlunit", ".tmp");
                file.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(file);
                bos.writeTo(fos);
                IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                fos.close();
                DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file, true);
                return onFile;
            }
        }
        catch (ConnectionClosedException e) {
            LOG.warn((Object)"Connection was closed while reading from stream.", (Throwable)e);
            DownloadedContent.InMemory inMemory = new DownloadedContent.InMemory(bos.toByteArray());
            return inMemory;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return new DownloadedContent.InMemory(bos.toByteArray());
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestHeadersToHttpMethod(HttpUriRequest httpMethod, Map<String, String> requestHeaders) {
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void shutdown() {
        if (this.httpClientBuilder_ != null) {
            this.httpClientBuilder_ = null;
        }
        if (this.connectionManager_ != null) {
            this.connectionManager_.shutdown();
            this.connectionManager_ = null;
        }
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpClientBuilder builder) {
        SocksConnectionSocketFactory socketFactory = new SocksConnectionSocketFactory();
        try {
            String s;
            LayeredConnectionSocketFactory sslSocketFactory = (LayeredConnectionSocketFactory)FieldUtils.readDeclaredField((Object)builder, (String)"sslSocketFactory", (boolean)true);
            SocketConfig defaultSocketConfig = (SocketConfig)FieldUtils.readDeclaredField((Object)builder, (String)"defaultSocketConfig", (boolean)true);
            ConnectionConfig defaultConnectionConfig = (ConnectionConfig)FieldUtils.readDeclaredField((Object)builder, (String)"defaultConnectionConfig", (boolean)true);
            boolean systemProperties = (Boolean)FieldUtils.readDeclaredField((Object)builder, (String)"systemProperties", (boolean)true);
            int maxConnTotal = (Integer)FieldUtils.readDeclaredField((Object)builder, (String)"maxConnTotal", (boolean)true);
            int maxConnPerRoute = (Integer)FieldUtils.readDeclaredField((Object)builder, (String)"maxConnPerRoute", (boolean)true);
            X509HostnameVerifier hostnameVerifier = (X509HostnameVerifier)FieldUtils.readDeclaredField((Object)builder, (String)"hostnameVerifier", (boolean)true);
            SSLContext sslcontext = (SSLContext)FieldUtils.readDeclaredField((Object)builder, (String)"sslcontext", (boolean)true);
            if (sslSocketFactory == null) {
                String[] supportedCipherSuites;
                String[] supportedProtocols = systemProperties ? StringUtils.split((String)System.getProperty("https.protocols"), (char)',') : null;
                String[] stringArray = supportedCipherSuites = systemProperties ? StringUtils.split((String)System.getProperty("https.cipherSuites"), (char)',') : null;
                if (hostnameVerifier == null) {
                    hostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                }
                sslSocketFactory = sslcontext != null ? new SSLConnectionSocketFactory(sslcontext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
            }
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)socketFactory).register("https", (Object)sslSocketFactory).build());
            if (defaultSocketConfig != null) {
                connectionManager.setDefaultSocketConfig(defaultSocketConfig);
            }
            if (defaultConnectionConfig != null) {
                connectionManager.setDefaultConnectionConfig(defaultConnectionConfig);
            }
            if (systemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
                s = System.getProperty("http.maxConnections", "5");
                int max = Integer.parseInt(s);
                connectionManager.setDefaultMaxPerRoute(max);
                connectionManager.setMaxTotal(2 * max);
            }
            if (maxConnTotal > 0) {
                connectionManager.setMaxTotal(maxConnTotal);
            }
            if (maxConnPerRoute > 0) {
                connectionManager.setDefaultMaxPerRoute(maxConnPerRoute);
            }
            return connectionManager;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

