/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.propertyorder;

import ee.jakarta.tck.json.bind.customizedmapping.propertyorder.model.CustomOrderContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertyorder.model.PartialOrderContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertyorder.model.RenamedPropertiesContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertyorder.model.SimpleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.propertyorder.model.SimpleOrderContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class PropertyOrderCustomizationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testAnyPropertyOrderStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"ANY");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        SimpleContainer unmarshalledObject = (SimpleContainer)jsonb.fromJson(jsonString, SimpleContainer.class);
        String validationMessage = "Failed to correctly marshal and unmarshal object using PropertyOrderStrategy.ANY.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getStringInstance(), (Matcher)Matchers.is((Object)"Test String"));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getLongInstance(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testLexicographicalPropertyOrderStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"LEXICOGRAPHICAL");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in lexicographical order using PropertyOrderStrategy.LEXICOGRAPHICAL.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        SimpleOrderContainer unmarshalledObject = (SimpleOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 1 }", SimpleOrderContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal properties in order of appearance using PropertyOrderStrategy.LEXICOGRAPHICAL.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testReversePropertyOrderStrategy() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new SimpleOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in reverse lexicographical order using PropertyOrderStrategy.REVERSE.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*,\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*\\}"));
        SimpleOrderContainer unmarshalledObject = (SimpleOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 1 }", SimpleOrderContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal properties in order of appearance using PropertyOrderStrategy.REVERSE.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testCustomPropertyOrder() {
        String jsonString = this.jsonb.toJson((Object)new CustomOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        CustomOrderContainer unmarshalledObject = (CustomOrderContainer)this.jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", CustomOrderContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testCustomPropertyOrderStrategyOverride() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new CustomOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        CustomOrderContainer unmarshalledObject = (CustomOrderContainer)jsonb.fromJson("{ \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }", CustomOrderContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation and PropertyOrderStrategy.REVERSE.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testCustomPartialPropertyOrder() {
        String jsonString = this.jsonb.toJson((Object)new PartialOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\".*\\}"));
        String validationMessage = "Did not marshall all expected properties";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"anotherIntInstance"));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"anIntInstance"));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"yetAnotherIntInstance"));
        String toDeserialize = "{ \"anIntInstance\" : 100, \"yetAnotherIntInstance\":100, \"anotherIntInstance\": 100, \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }";
        PartialOrderContainer unmarshalledObject = (PartialOrderContainer)this.jsonb.fromJson(toDeserialize, PartialOrderContainer.class);
        validationMessage = "Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getAnotherIntInstance(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getYetAnotherIntInstance(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getAnIntInstance(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testCustomPartialPropertyOrderStrategyOverride() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"REVERSE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new PartialOrderContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal properties in custom order using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"longInstance\"\\s*\\:\\s*0\\s*,\\s*\"intInstance\"\\s*\\:\\s*0\\s*,\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\".*\\}"));
        String validationMessage = "Did not marshall all expected properties";
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"anotherIntInstance"));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"anIntInstance"));
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.containsString((String)"yetAnotherIntInstance"));
        String toDeserialize = "{ \"anIntInstance\" : 100, \"yetAnotherIntInstance\":100, \"anotherIntInstance\": 100, \"intInstance\" : 1, \"stringInstance\" : \"Test String\", \"longInstance\" : 0 }";
        PartialOrderContainer unmarshalledObject = (PartialOrderContainer)jsonb.fromJson(toDeserialize, PartialOrderContainer.class);
        validationMessage = "Failed to correctly unmarshal properties in order of appearance using JsonbPropertyOrder annotation.";
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getAnotherIntInstance(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getYetAnotherIntInstance(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((String)validationMessage, (Object)unmarshalledObject.getAnIntInstance(), (Matcher)Matchers.is((Object)100));
    }

    @Test
    public void testLexicographicalPropertyOrderRenamedProperties() {
        JsonbConfig config = new JsonbConfig().setProperty("jsonb.property-order-strategy", (Object)"LEXICOGRAPHICAL");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new RenamedPropertiesContainer(){
            {
                this.setStringInstance("Test String");
                this.setLongInstance(1L);
            }
        });
        MatcherAssert.assertThat((String)"Failed to correctly marshal renamed properties in lexicographical order using PropertyOrderStrategy.LEXICOGRAPHICAL.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"first\"\\s*\\:\\s*0\\s*,\\s*\"second\"\\s*\\:\\s*\"Test String\"\\s*,\\s*\"third\"\\s*\\:\\s*1\\s*\\}"));
        RenamedPropertiesContainer unmarshalledObject = (RenamedPropertiesContainer)jsonb.fromJson("{ \"first\" : 1, \"second\" : \"Test String\", \"third\" : 1 }", RenamedPropertiesContainer.class);
        MatcherAssert.assertThat((String)"Failed to correctly unmarshal renamed properties in order of appearance using PropertyOrderStrategy.LEXICOGRAPHICAL.", (Object)unmarshalledObject.getIntInstance(), (Matcher)Matchers.is((Object)3));
    }
}

