/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.polymorphictypes;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbDateFormat;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AnnotationTypeInfoTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testBasicSerialization() {
        Dog dog = new Dog();
        String jsonString = this.jsonb.toJson((Object)dog);
        MatcherAssert.assertThat((String)"Failed to serialize Dog class correctly.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"@type\"\\s*:\\s*\"dog\"\\s*,\\s*\"isDog\"\\s*:\\s*true\\s*\\}"));
        Cat cat = new Cat();
        jsonString = this.jsonb.toJson((Object)cat);
        MatcherAssert.assertThat((String)"Failed to serialize Cat class correctly", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"@type\"\\s*:\\s*\"cat\"\\s*,\\s*\"isCat\"\\s*:\\s*true\\s*\\}"));
    }

    @Test
    public void testBasicDeserialization() {
        Animal dog = (Animal)this.jsonb.fromJson("{\"@type\":\"dog\",\"isDog\":false}", Animal.class);
        MatcherAssert.assertThat((String)("Incorrectly deserialized to the type. Expected was Dog instance. Got instance of class " + dog.getClass()), (Object)dog, (Matcher)Matchers.instanceOf(Dog.class));
        MatcherAssert.assertThat((String)"Incorrectly deserialized field of the Dog instance. Field \"isDog\" should have been false.", (Object)((Dog)dog).isDog, (Matcher)Matchers.is((Object)false));
        Animal cat = (Animal)this.jsonb.fromJson("{\"@type\":\"cat\",\"isCat\":false}", Animal.class);
        MatcherAssert.assertThat((String)("Incorrectly deserialized to the type. Expected was Cat instance. Got instance of class " + cat.getClass()), (Object)cat, (Matcher)Matchers.instanceOf(Cat.class));
        MatcherAssert.assertThat((String)"Incorrectly deserialized field of the Cat instance. Field \"isCat\" should have been false.", (Object)((Cat)cat).isCat, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testUnknownAliasDeserialization() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{\"@type\":\"rat\",\"isRat\":false}", Animal.class), (String)"Deserialization should fail. Alias \"rat\" is not valid alias of the class Animal.");
    }

    @Test
    public void testCreatorDeserialization() {
        SomeDateType deserialized = (SomeDateType)this.jsonb.fromJson("{\"@dateType\":\"constructor\",\"localDate\":\"26-02-2021\"}", SomeDateType.class);
        MatcherAssert.assertThat((String)("Incorrectly deserialized according to the type information. Expected was DateConstructor instance. Got instance of class " + deserialized.getClass()), (Object)deserialized, (Matcher)Matchers.instanceOf(DateConstructor.class));
    }

    @Test
    public void testArraySerialization() {
        String expected = "\\[\\s*\\{\\s*\"@type\"\\s*:\\s*\"dog\"\\s*,\\s*\"isDog\"\\s*:\\s*true\\s*\\}\\s*,\\s*\\{\\s*\"@type\"\\s*:\\s*\"cat\"\\s*,\\s*\"isCat\"\\s*:\\s*true\\s*\\}\\s*,\\s*\\{\\s*\"@type\"\\s*:\\s*\"dog\"\\s*,\\s*\"isDog\"\\s*:\\s*true\\s*\\}\\s*\\]";
        Animal[] animals = new Animal[]{new Dog(), new Cat(), new Dog()};
        String jsonString = this.jsonb.toJson((Object)animals);
        MatcherAssert.assertThat((String)"Array values were not properly serialized with type information.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)expected));
    }

    @Test
    public void testArrayDeserialization() {
        String array = "[{\"@type\":\"dog\",\"isDog\":true},{\"@type\":\"cat\",\"isCat\":true},{\"@type\":\"dog\",\"isDog\":true}]";
        Animal[] deserialized = (Animal[])this.jsonb.fromJson(array, Animal[].class);
        MatcherAssert.assertThat((String)"Array should have exactly 3 values.", (Object)deserialized, (Matcher)Matchers.arrayWithSize((int)3));
        MatcherAssert.assertThat((String)("Array value at index 0 was incorrectly deserialized according to the type information. Expected was Dog instance. Got instance of class " + deserialized[0].getClass()), (Object)deserialized[0], (Matcher)Matchers.instanceOf(Dog.class));
        MatcherAssert.assertThat((String)("Array value at index 1 was incorrectly deserialized  according to the type information. Expected was Cat instance. Got instance of class " + deserialized[1].getClass()), (Object)deserialized[1], (Matcher)Matchers.instanceOf(Cat.class));
        MatcherAssert.assertThat((String)("Array value at index 2 was incorrectly deserialized according to the type information. Expected was Dog instance. Got instance of class " + deserialized[2].getClass()), (Object)deserialized[2], (Matcher)Matchers.instanceOf(Dog.class));
    }

    public static final class DateConstructor
    implements SomeDateType {
        public LocalDate localDate;

        @JsonbCreator
        public DateConstructor(@JsonbProperty(value="localDate") @JsonbDateFormat(value="dd-MM-yyyy", locale="nl-NL") LocalDate localDate) {
            this.localDate = localDate;
        }
    }

    @JsonbTypeInfo(key="@dateType", value={@JsonbSubtype(alias="constructor", type=DateConstructor.class)})
    public static interface SomeDateType {
    }

    public static class Elephant
    implements Animal {
        public boolean isElephant = true;
        public String testProperty = "value";
    }

    public static class Cat
    implements Animal {
        public boolean isCat = true;
    }

    public static class Dog
    implements Animal {
        public boolean isDog = true;
    }

    @JsonbTypeInfo(value={@JsonbSubtype(alias="dog", type=Dog.class), @JsonbSubtype(alias="cat", type=Cat.class), @JsonbSubtype(alias="elephant", type=Elephant.class)})
    public static interface Animal {
    }
}

