/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.client.syncinvoker;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JdkLoggingFilter;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.ee.rs.client.syncinvoker.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.client.syncinvoker.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 4942772066511819511L;
    protected long millis;
    static final String[] METHODS = new String[]{"DELETE", "GET", "OPTIONS"};
    static final String[] ENTITY_METHODS = new String[]{"PUT", "POST"};

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_client_syncinvoker_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/client/syncinvoker/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_client_syncinvoker_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, TRACE.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void deleteTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("delete");
        Response response = sync.delete();
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void deleteThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.delete();
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void deleteWithStringClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("delete");
        String response = (String)sync.delete(String.class);
        JAXRSClientIT.assertResponseString(response, "delete");
    }

    @Test
    public void deleteWithResponseClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("delete");
        Response response = (Response)sync.delete(Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void deleteWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.delete(String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void deleteWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("deletenotok");
                sync.delete(String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void deleteWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("deletenotok");
        Response response = (Response)sync.delete(Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void deleteWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("delete");
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        String response = (String)sync.delete(generic);
        JAXRSClientIT.assertResponseString(response, "delete");
    }

    @Test
    public void deleteWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("delete");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.delete(generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void deleteWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.delete(generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void deleteWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("deletenotok");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.delete(generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void deleteWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("deletenotok");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.delete(generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("get");
        Response response = sync.get();
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void getThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.get();
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void getWithStringClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("get");
        String response = (String)sync.get(String.class);
        JAXRSClientIT.assertResponseString(response, "get");
    }

    @Test
    public void getWithResponseClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("get");
        Response response = (Response)sync.get(Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void getWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.get(String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void getWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("getnotok");
                sync.get(String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void getWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("getnotok");
        Response response = (Response)sync.get(Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void getWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("get");
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        String response = (String)sync.get(generic);
        JAXRSClientIT.assertResponseString(response, "get");
    }

    @Test
    public void getWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("get");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.get(generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void getWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.get(generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void getWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("getnotok");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.get(generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void getWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("getnotok");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.get(generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void headTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("head");
        Response response = sync.head();
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        Assertions.assertTrue((status == Response.Status.OK || status == Response.Status.NO_CONTENT ? 1 : 0) != 0, (String)"Incorrect status for head received");
    }

    @Test
    public void headThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.head();
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void methodTest() throws JAXRSCommonClient.Fault {
        Response response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            response = sync.method(method);
            JAXRSClientIT.assertResponseOk(response);
        }
    }

    @Test
    public void methodThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    sync.method(method);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithStringClassTest() throws JAXRSCommonClient.Fault {
        String response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            response = (String)sync.method(method, String.class);
            JAXRSClientIT.assertResponseString(response, method.toLowerCase());
        }
    }

    @Test
    public void methodWithResponseClassTest() throws JAXRSCommonClient.Fault {
        Response response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            response = (Response)sync.method(method, Response.class);
            JAXRSClientIT.assertResponseOk(response);
        }
    }

    @Test
    public void methodWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    sync.method(method, String.class);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
                    sync.method(method, String.class);
                }
            };
            JAXRSClientIT.assertWebApplicationException(run);
        }
    }

    @Test
    public void methodWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
            Response response = (Response)sync.method(method, Response.class);
            JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        String response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            response = (String)sync.method(method, generic);
            JAXRSClientIT.assertResponseString(response, method.toLowerCase());
        }
    }

    @Test
    public void methodWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            response = (Response)sync.method(method, generic);
            JAXRSClientIT.assertResponseOk(response);
        }
    }

    @Test
    public void methodWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        final GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        for (final String method : METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    sync.method(method, generic);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        final GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        for (final String method : METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
                    sync.method(method, generic);
                }
            };
            JAXRSClientIT.assertWebApplicationException(run);
        }
    }

    @Test
    public void methodWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = null;
        for (String method : METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
            response = (Response)sync.method(method, generic);
            JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithEntityTest() throws JAXRSCommonClient.Fault {
        Response response = null;
        for (String method : ENTITY_METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            response = sync.method(method, entity);
            JAXRSClientIT.assertResponseOk(response);
        }
    }

    @Test
    public void methodWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        final Entity<String> entity = JAXRSClientIT.createEntity("entity");
        for (final String method : ENTITY_METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    sync.method(method, entity);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithStringClassWithEntityTest() throws JAXRSCommonClient.Fault {
        String response = null;
        for (String method : ENTITY_METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            response = (String)sync.method(method, entity, String.class);
            JAXRSClientIT.assertResponseString(response, method.toLowerCase());
        }
    }

    @Test
    public void methodWithResponseClassWithEntityTest() throws JAXRSCommonClient.Fault {
        String response = null;
        for (String method : ENTITY_METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            response = (String)sync.method(method, entity, String.class);
            JAXRSClientIT.assertResponseString(response, method.toLowerCase());
        }
    }

    @Test
    public void methodWithStringClassWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : ENTITY_METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
                    sync.method(method, entity, String.class);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithStringClassWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : ENTITY_METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
                    Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
                    sync.method(method, entity, String.class);
                }
            };
            JAXRSClientIT.assertWebApplicationException(run);
        }
    }

    @Test
    public void methodWithResponseClassWithEntityThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (String method : ENTITY_METHODS) {
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            Response response = (Response)sync.method(method, entity, Response.class);
            JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void methodWithGenericTypeStringWithEntityTest() throws JAXRSCommonClient.Fault {
        String response = null;
        for (String method : ENTITY_METHODS) {
            GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            response = (String)sync.method(method, entity, generic);
            JAXRSClientIT.assertResponseString(response, method.toLowerCase());
        }
    }

    @Test
    public void methodWithGenericTypeResponseWithEntityTest() throws JAXRSCommonClient.Fault {
        Response response = null;
        for (String method : ENTITY_METHODS) {
            GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase());
            Entity<String> entity = JAXRSClientIT.createEntity(method.toLowerCase());
            response = (Response)sync.method(method, entity, generic);
            JAXRSClientIT.assertResponseOk(response);
        }
    }

    @Test
    public void methodWithGenericTypeStringWithEntityThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : ENTITY_METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                    Entity<String> entity = JAXRSClientIT.createEntity(method);
                    sync.method(method, entity, generic);
                }
            };
            JAXRSClientIT.assertProcessingException(run);
        }
    }

    @Test
    public void methodWithGenericTypeStringWithEntityThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (final String method : ENTITY_METHODS) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                    SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
                    Entity<String> entity = JAXRSClientIT.createEntity(method);
                    sync.method(method, entity, generic);
                }
            };
            JAXRSClientIT.assertWebApplicationException(run);
        }
    }

    @Test
    public void methodWithGenericTypeResponseWithEntityThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        for (String method : ENTITY_METHODS) {
            GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
            SyncInvoker sync = this.createSyncInvokerForMethod(method.toLowerCase() + "notok");
            Entity<String> entity = JAXRSClientIT.createEntity(method);
            Response response = (Response)sync.method(method, entity, generic);
            JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
        }
    }

    @Test
    public void optionsTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("options");
        Response response = sync.options();
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void optionsThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.options();
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void optionsWithStringClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("options");
        String response = (String)sync.options(String.class);
        JAXRSClientIT.assertResponseString(response, "options");
    }

    @Test
    public void optionsWithResponseClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("options");
        Response response = (Response)sync.options(Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void optionsWithStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.options(String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void optionsWithStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("optionsnotok");
                sync.options(String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void optionsWithResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("optionsnotok");
        Response response = (Response)sync.options(Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void optionsWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("options");
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        String response = (String)sync.options(generic);
        JAXRSClientIT.assertResponseString(response, "options");
    }

    @Test
    public void optionsWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("options");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.options(generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void optionsWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.options(generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void optionsWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("optionsnotok");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.options(generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void optionsWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("optionsnotok");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.options(generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("post");
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        Response response = sync.post(entity);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void postThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("post");
                sync.post(entity);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void postWithStringClassTest() throws JAXRSCommonClient.Fault {
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        SyncInvoker sync = this.createSyncInvokerForMethod("post");
        String response = (String)sync.post(entity, String.class);
        JAXRSClientIT.assertResponseString(response, "post");
    }

    @Test
    public void postWithResponseClassTest() throws JAXRSCommonClient.Fault {
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        SyncInvoker sync = this.createSyncInvokerForMethod("post");
        Response response = (Response)sync.post(entity, Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void postWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("post");
                sync.post(entity, String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void postWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("postnotok");
                Entity<String> entity = JAXRSClientIT.createEntity("post");
                sync.post(entity, String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void postWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("postnotok");
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        Response response = (Response)sync.post(entity, Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void postWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        SyncInvoker sync = this.createSyncInvokerForMethod("post");
        String response = (String)sync.post(entity, generic);
        JAXRSClientIT.assertResponseString(response, "post");
    }

    @Test
    public void postWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        SyncInvoker sync = this.createSyncInvokerForMethod("post");
        Response response = (Response)sync.post(entity, generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void postWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("post");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.post(entity, generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void postWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("postnotok");
                Entity<String> entity = JAXRSClientIT.createEntity("post");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.post(entity, generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void postWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("postnotok");
        Entity<String> entity = JAXRSClientIT.createEntity("post");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.post(entity, generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("put");
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        Response response = sync.put(entity);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void putThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("put");
                sync.put(entity);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void putWithStringClassTest() throws JAXRSCommonClient.Fault {
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        SyncInvoker sync = this.createSyncInvokerForMethod("put");
        String response = (String)sync.put(entity, String.class);
        JAXRSClientIT.assertResponseString(response, "put");
    }

    @Test
    public void putWithResponseClassTest() throws JAXRSCommonClient.Fault {
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        SyncInvoker sync = this.createSyncInvokerForMethod("put");
        Response response = (Response)sync.put(entity, Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void putWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("put");
                sync.put(entity, String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void putWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("putnotok");
                Entity<String> entity = JAXRSClientIT.createEntity("put");
                sync.put(entity, String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void putWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("putnotok");
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        Response response = (Response)sync.put(entity, Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void putWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        SyncInvoker sync = this.createSyncInvokerForMethod("put");
        String response = (String)sync.put(entity, generic);
        JAXRSClientIT.assertResponseString(response, "put");
    }

    @Test
    public void putWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        SyncInvoker sync = this.createSyncInvokerForMethod("put");
        Response response = (Response)sync.put(entity, generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void putWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                Entity<String> entity = JAXRSClientIT.createEntity("put");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.put(entity, generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void putWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("putnotok");
                Entity<String> entity = JAXRSClientIT.createEntity("put");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.put(entity, generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void putWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("putnotok");
        Entity<String> entity = JAXRSClientIT.createEntity("put");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.put(entity, generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("trace");
        Response response = sync.trace();
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void traceThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.trace();
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void traceWithStringClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("trace");
        String response = (String)sync.trace(String.class);
        JAXRSClientIT.assertResponseString(response, "trace");
    }

    @Test
    public void traceWithResponseClassTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("trace");
        Response response = (Response)sync.trace(Response.class);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void traceWithStringClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                sync.trace(String.class);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void traceWithStringClassThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("tracenotok");
                sync.trace(String.class);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void traceWithResponseClassThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("tracenotok");
        Response response = (Response)sync.trace(Response.class);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    @Test
    public void traceWithGenericTypeStringTest() throws JAXRSCommonClient.Fault {
        GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
        SyncInvoker sync = this.createSyncInvokerForMethod("trace");
        String response = (String)sync.trace(generic);
        JAXRSClientIT.assertResponseString(response, "trace");
    }

    @Test
    public void traceWithGenericTypeResponseTest() throws JAXRSCommonClient.Fault {
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        SyncInvoker sync = this.createSyncInvokerForMethod("trace");
        Response response = (Response)sync.trace(generic);
        JAXRSClientIT.assertResponseOk(response);
    }

    @Test
    public void traceWithGenericTypeStringThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerWrongUrl();
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.trace(generic);
            }
        };
        JAXRSClientIT.assertProcessingException(run);
    }

    @Test
    public void traceWithGenericTypeStringThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SyncInvoker sync = JAXRSClientIT.this.createSyncInvokerForMethod("tracenotok");
                GenericType<String> generic = JAXRSClientIT.createGeneric(String.class);
                sync.trace(generic);
            }
        };
        JAXRSClientIT.assertWebApplicationException(run);
    }

    @Test
    public void traceWithGenericTypeResponseThrowsNoWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        SyncInvoker sync = this.createSyncInvokerForMethod("tracenotok");
        GenericType<Response> generic = JAXRSClientIT.createGeneric(Response.class);
        Response response = (Response)sync.trace(generic);
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.NOT_ACCEPTABLE);
    }

    protected String getUrl(String method) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this._hostname).append(":").append(this._port);
        url.append(this.getContextRoot()).append("/").append(method);
        return url.toString();
    }

    protected SyncInvoker createSyncInvokerForMethod(String methodName) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(false));
        WebTarget target = client.target(this.getUrl(methodName));
        Invocation.Builder sync = target.request();
        return sync;
    }

    protected SyncInvoker createSyncInvokerWrongUrl() {
        this._hostname = "tck.cts";
        this._port = 888;
        return this.createSyncInvokerForMethod("wrongurl");
    }

    protected static void assertStatusAndLog(Response response, Response.Status status) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((response.getStatus() == status.getStatusCode() ? 1 : 0) != 0, (String)("Returned unexpected status" + response.getStatus()));
        String msg = "Returned status " + status.getStatusCode() + " (" + status.name() + ")";
        TestUtil.logMsg(msg);
    }

    protected static void assertResponseOk(Response response) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertStatusAndLog(response, Response.Status.OK);
    }

    protected static void assertResponseString(String response, String expectedValue) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)expectedValue.equals(response), (String)("expected value" + expectedValue + "differes from acquired value" + response));
    }

    protected static <T> Entity<T> createEntity(T entity) {
        return Entity.entity(entity, (MediaType)MediaType.WILDCARD_TYPE);
    }

    protected static <T> GenericType<T> createGeneric(Class<T> clazz) {
        return new GenericType(clazz);
    }

    protected static void assertProcessingException(Runnable runnable) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertException(runnable, ProcessingException.class);
    }

    protected static void assertWebApplicationException(Runnable runnable) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertException(runnable, WebApplicationException.class);
    }

    protected static <T extends Exception> void assertException(Runnable runnable, Class<T> exception) throws JAXRSCommonClient.Fault {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (exception != null && exception.isInstance(e)) {
                return;
            }
            throw new JAXRSCommonClient.Fault("unexpected exception", e);
        }
        JAXRSClientIT.fault("ProcessingException has not been thrown");
    }
}

