/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.queryparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.ParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.queryparam.QueryParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.queryparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_queryparam_web/QueryParamTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/queryparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_queryparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, QueryParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamTest.class, JaxrsParamClient.CollectionName.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void queryParamStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest=cts"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=cts");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest=cts1&stringtest=cts2"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=cts1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest1=cts&stringtest2=ri_impl"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=abc|stringtest1=cts|stringtest2=ri_impl");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("stringtest1=cts&stringtest2=ri_impl&stringtest1=newone"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=abc|stringtest1=cts|stringtest2=ri_impl");
        this.invoke();
    }

    @Test
    public void queryParamNoQueryTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "Accept: text/plain");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(""));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "stringtest=abc|No QueryParam");
        this.invoke();
    }

    @Test
    public void queryParamIntTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest1=2147483647"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=2147483647");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest=-2147483648&inttest=2147483647"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest=-2147483648");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest1=2147483647&inttest2=-2147483648"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=2147483647|inttest2=-2147483648");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("inttest1=-2147483648&inttest2=2147483647&inttest1=1234"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "inttest1=-2147483648|inttest2=2147483647");
        this.invoke();
    }

    @Test
    public void queryParamDoubleTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest1=123"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest=123.1&doubletest=345"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest=123.1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest1=12.345&doubletest2=34.567"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=12.345|doubletest2=34.567");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("doubletest1=23.456&doubletest2=0.56789&doubletest1=1.234"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "doubletest1=23.456|doubletest2=0.56789");
        this.invoke();
    }

    @Test
    public void queryParamFloatTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest1=123"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=123.0");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest=123.1&floattest=345"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest=123.1");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest1=12.345&floattest2=34.567"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=12.345|floattest2=34.567");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("floattest1=23.456&floattest2=0.56789&floattest1=1.234"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "floattest1=23.456|floattest2=0.56789");
        this.invoke();
    }

    @Test
    public void queryParamLongTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest=-9223372036854775808"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest=-9223372036854775808");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest=9223372036854775807&longtest=-9223372036854775808"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest=9223372036854775807");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest1=-9223372036854775808&longtest2=9223372036854775807"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808|longtest2=9223372036854775807");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("longtest1=-9223372036854775808&longtest2=9223372036854775807&longtest1=1234"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "longtest1=-9223372036854775808|longtest2=9223372036854775807");
        this.invoke();
    }

    @Test
    public void queryParamShortTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest=-32768"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest=-32768");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest=32767&shorttest=-32768"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest=32767");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest1=32767&shorttest2=-32768"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767|shorttest2=-32768");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("shorttest1=32767&shorttest2=-32768&shorttest1=1234"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "shorttest1=32767|shorttest2=-32768");
        this.invoke();
    }

    @Test
    public void queryParamByteTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest=127"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest=127");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest=-128&bytetest=26"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest=-128");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest1=123&bytetest2=-128"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest1=123|bytetest2=-128");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("bytetest1=0&bytetest2=-128&bytetest1=127"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "bytetest2=-128");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "bytetest1");
        this.invoke();
    }

    @Test
    public void queryParamBooleanTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest=true"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest=true&booleantest=false"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest1=false&booleantest2=true"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest2=true");
        this.invoke();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest("booleantest1=true&booleantest2=false&booleantest1=true"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "booleantest1=true");
        this.invoke();
    }

    @Test
    public void queryParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithConstructorTest();
    }

    @Test
    public void queryParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithValueOfTest();
    }

    @Test
    public void queryParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithFromStringTest();
    }

    @Test
    public void queryParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void queryParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void queryParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.paramCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void queryFieldParamEntityWithConstructorTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithConstructorTest();
    }

    @Test
    public void queryFieldParamEntityWithValueOfTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithValueOfTest();
    }

    @Test
    public void queryFieldParamEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithFromStringTest();
    }

    @Test
    public void queryFieldParamSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SET);
    }

    @Test
    public void queryFieldParamSortedSetEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.SORTED_SET);
    }

    @Test
    public void queryFieldParamListEntityWithFromStringTest() throws JAXRSCommonClient.Fault {
        super.fieldCollectionEntityWithFromStringTest(JaxrsParamClient.CollectionName.LIST);
    }

    @Test
    public void queryParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        super.paramEntityWithEncodedTest();
    }

    @Test
    public void queryFieldParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        super.fieldEntityWithEncodedTest();
    }

    @Test
    public void queryParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void queryFieldThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.fieldThrowingWebApplicationExceptionTest();
    }

    @Test
    public void queryParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.NOT_FOUND.name());
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    @Test
    public void queryFieldThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.NOT_FOUND.name());
        super.fieldThrowingIllegalArgumentExceptionTest();
    }

    @Override
    protected String buildRequest(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append("GET ").append(this._contextRoot).append("?");
        sb.append(param).append(" HTTP/1.1");
        return sb.toString();
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append(param).append("=");
        sb.append(QueryParamTest.class.getSimpleName());
        return sb.toString();
    }
}

