/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.invocations;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JdkLoggingFilter;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.client.invocations.Resource;
import ee.jakarta.tck.ws.rs.spec.client.invocations.TSAppConfig;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_client_invocations_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/client/invocations/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_client_invocations_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void synchronousTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "call"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.class.getName());
        this.invoke();
    }

    @Test
    public void asynchronousTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "call"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.class.getName());
        this.setAsynchronousProcessing();
        this.invoke();
    }

    @Test
    public void invocationFromLinkTextXmlMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response r = this.invocationFromLinkWithMediaType("text/xml");
        this.checkResposeForMessage("text/xml", r);
    }

    @Test
    public void invocationFromLinkApplicationJsonMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response r = this.invocationFromLinkWithMediaType("application/json");
        this.checkResposeForMessage("application/json", r);
    }

    @Test
    public void invocationFromLinkTwoMediaTypesTest() throws JAXRSCommonClient.Fault {
        String type1 = "application/atom+xml";
        String type2 = "text/html";
        Response r = this.invocationFromLinkWithMediaType(type1 + "," + type2);
        r.bufferEntity();
        this.checkResposeForMessage(type1, r);
        this.checkResposeForMessage(type2, r);
    }

    protected Response invocationFromLinkWithMediaType(String mediaType) throws JAXRSCommonClient.Fault {
        String url = "mediatype";
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(false));
        URI uri = UriBuilder.fromPath((String)this.getUrl(url)).build(new Object[0]);
        Link link = Link.fromUri((URI)uri).type(mediaType).build(new Object[0]);
        Invocation i = client.invocation(link).buildGet();
        Response response = i.invoke();
        return response;
    }

    protected void checkResposeForMessage(String message, Response response) throws JAXRSCommonClient.Fault {
        String body = (String)response.readEntity(String.class);
        boolean containsMediaType = body.contains(message);
        Assertions.assertTrue((containsMediaType ? 1 : 0) != 0, (String)("The HTTP Accept header does not contain" + message));
    }

    protected String getUrl(String method) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(this._hostname).append(":").append(this._port);
        url.append(this.getContextRoot()).append("/").append(method);
        return url.toString();
    }
}

