/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.entitytag;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.EntityTag;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -5886257224223478590L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest1() throws JAXRSCommonClient.Fault {
        String value = "cts test entity tag test";
        boolean strong = true;
        EntityTag et1 = new EntityTag(value);
        JAXRSClientIT.verifyEntityTag(et1, value, strong);
    }

    @Test
    public void constructorTest2() throws JAXRSCommonClient.Fault {
        String value = "cts test entity tag test weak";
        boolean strong = false;
        EntityTag et2 = new EntityTag(value, true);
        JAXRSClientIT.verifyEntityTag(et2, value, strong);
        strong = true;
        EntityTag et3 = new EntityTag(value, false);
        JAXRSClientIT.verifyEntityTag(et3, value, strong);
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        EntityTag et7;
        EntityTag et6;
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String value = "cts test entity tag test";
        EntityTag et4 = new EntityTag(value);
        EntityTag et5 = new EntityTag(value, false);
        if (!et4.equals((Object)et5)) {
            pass = false;
            sb.append("Strong entity Tag equals test failed. " + et4.toString() + ";" + et5.toString() + ";");
        }
        if (et4.hashCode() != et5.hashCode()) {
            pass = false;
            sb.append("Strong entity Tag hashCode test failed. " + et4.toString() + ";" + et5.toString() + ";");
        }
        if ((et6 = new EntityTag(value = "cts test entity tag test weak", true)).equals((Object)(et7 = new EntityTag(value, false)))) {
            pass = false;
            sb.append("Weak entity Tag equals test failed. " + et6.toString() + ";" + et7.toString() + ";");
        }
        if (et6.hashCode() == et7.hashCode()) {
            pass = false;
            sb.append("Weak entity Tag hashCode test failed. " + et6.toString() + ";" + et7.toString() + ";");
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String value = "cts test Strong EntityTag test";
        EntityTag et8 = new EntityTag(value);
        String header = et8.toString();
        sb.append(header + "." + newline);
        if (!header.contains(value)) {
            pass = false;
            sb.append("Strong EnttyTag ToString Test failed: " + header + " does not contain " + value);
        }
        value = "cts test Weak EntityTag test";
        EntityTag et9 = new EntityTag(value, true);
        header = et9.toString();
        sb.append(header + "." + newline);
        if (!header.contains(value)) {
            pass = false;
            sb.append("Weak EnttyTag ToString Test failed: " + header + " does not contain " + value);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
        System.out.println(sb.toString());
    }

    @Test
    public void valueOfTest() throws JAXRSCommonClient.Fault {
        try {
            EntityTag.valueOf(null);
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException not thrown.  Test failed.");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void valueOfTest1() throws JAXRSCommonClient.Fault {
        String value = "\"cts test Strong EntityTag test\"";
        try {
            EntityTag et10 = EntityTag.valueOf((String)value);
            JAXRSClientIT.verifyEntityTag(et10, value, true);
        }
        catch (Exception ilex) {
            throw new JAXRSCommonClient.Fault("Unexpected exception throw: " + ilex.getMessage());
        }
    }

    private static void verifyEntityTag(EntityTag et, String value, boolean strong) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        if (!et.getValue().toLowerCase().replace("\"", "").equals(value.replace("\"", "").toLowerCase())) {
            pass = false;
            sb.append("Failed value test.  Expect " + value + " got " + et.getValue() + ".");
        }
        if (et.isWeak() == strong) {
            pass = false;
            sb.append("Failed isWeak test.  Expect " + !strong + " got " + et.isWeak());
        }
        Assertions.assertTrue((boolean)pass, (String)("at least one assertion failed: " + sb.toString()));
    }
}

