/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.redirectexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1351456637402581583L;
    public static final Response.Status.Family FAMILY = Response.Status.Family.REDIRECTION;
    protected static final String MESSAGE = "TCK RedirectionException description";
    protected static final String HOST = "www.jcp.org";
    protected static final URI LOCATION = URI.create("http://oracle.com:888/" + FAMILY + "test");

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorStatusUriTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(status, LOCATION);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            JAXRSClientIT.assertLocation(e, LOCATION);
        }
    }

    @Test
    public void constructorStatusUriThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(status, LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStatusNullUriThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            RedirectionException e = new RedirectionException((Response.Status)null, LOCATION);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorIntUriTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(status.getStatusCode(), LOCATION);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            JAXRSClientIT.assertLocation(e, LOCATION);
        }
    }

    @Test
    public void constructorIntUriThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(status.getStatusCode(), LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorIntNotValidStatusThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                RedirectionException e = new RedirectionException(status, LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(this.buildResponse(status));
            this.assertResponse((WebApplicationException)e, status, HOST);
        }
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusUriTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(MESSAGE, status, LOCATION);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            JAXRSClientIT.assertLocation(e, LOCATION);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringStatusUriThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(MESSAGE, status, LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringStatusNullUriThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            RedirectionException e = new RedirectionException(MESSAGE, (Response.Status)null, LOCATION);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for null status", "; exception", e);
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for null status");
        }
    }

    @Test
    public void constructorStringIntUriTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(MESSAGE, status.getStatusCode(), LOCATION);
            JAXRSClientIT.assertResponse((WebApplicationException)e, status);
            JAXRSClientIT.assertLocation(e, LOCATION);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringIntUriThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(MESSAGE, status.getStatusCode(), LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringIntNotValidStatusThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (int status : new int[]{-1, Integer.MAX_VALUE, Integer.MIN_VALUE}) {
            try {
                RedirectionException e = new RedirectionException(MESSAGE, status, LOCATION);
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesFromFamily()) {
            RedirectionException e = new RedirectionException(MESSAGE, this.buildResponse(status));
            this.assertResponse((WebApplicationException)e, status, HOST);
            this.assertMessage((WebApplicationException)e);
        }
    }

    @Test
    public void constructorStringResponseThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : JAXRSClientIT.getStatusesOutsideFamily()) {
            try {
                RedirectionException e = new RedirectionException(MESSAGE, this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected static void assertResponse(WebApplicationException e, Response.Status status) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), status.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", status, "status");
    }

    protected void assertResponse(WebApplicationException e, Response.Status status, String host) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertResponse(e, status);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected static void assertLocation(RedirectionException e, URI expected) throws JAXRSCommonClient.Fault {
        URI location = e.getLocation();
        JAXRSClientIT.assertEquals(location, expected, "#getLocation()={", location, "} differs from expected", expected);
        JAXRSClientIT.logMsg("Found expected location", location);
    }

    protected static List<Response.Status> getStatusesFromFamily() {
        LinkedList<Response.Status> list = new LinkedList<Response.Status>();
        for (Response.Status status : Response.Status.values()) {
            if (!Response.Status.Family.familyOf((int)status.getStatusCode()).equals((Object)FAMILY)) continue;
            list.add(status);
        }
        return list;
    }

    protected static List<Response.Status> getStatusesOutsideFamily() {
        LinkedList<Response.Status> list = new LinkedList<Response.Status>();
        for (Response.Status status : Response.Status.values()) {
            if (Response.Status.Family.familyOf((int)status.getStatusCode()).equals((Object)FAMILY)) continue;
            list.add(status);
        }
        return list;
    }

    protected void assertMessage(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

