/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.common.webclient.http;

import ee.jakarta.tck.ws.rs.common.webclient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;

public class HttpResponse {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String CONTENT_TYPE = "Content-Type";
    private HttpMethod _method = null;
    private HttpState _state = null;
    private String _encoding = "ISO-8859-1";
    private String _responseBody = null;
    private String _host = null;
    private int _port;
    private boolean _isSecure;

    public HttpResponse(String host, int port, boolean isSecure, HttpMethod method, HttpState state) {
        this._host = host;
        this._port = port;
        this._isSecure = isSecure;
        this._method = method;
        this._state = state;
    }

    public String getStatusCode() {
        return Integer.toString(this._method.getStatusCode());
    }

    public String getReasonPhrase() {
        return this._method.getStatusText();
    }

    public Header[] getResponseHeaders() {
        return this._method.getResponseHeaders();
    }

    public Header[] getResponseHeaders(String headerName) {
        return this._method.getResponseHeaders(headerName);
    }

    public Header getResponseHeader(String headerName) {
        return this._method.getResponseHeader(headerName);
    }

    public byte[] getResponseBodyAsBytes() throws IOException {
        return this.getEncodedResponse().getBytes();
    }

    public byte[] getResponseBodyAsRawBytes() throws IOException {
        return this._method.getResponseBody();
    }

    public String getResponseBodyAsString() throws IOException {
        return this.getEncodedResponse();
    }

    public String getResponseBodyAsRawString() throws IOException {
        return this._method.getResponseBodyAsString();
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return new ByteArrayInputStream(this.getEncodedResponse().getBytes());
    }

    public InputStream getResponseBodyAsRawStream() throws IOException {
        return this._method.getResponseBodyAsStream();
    }

    public String getResponseEncoding() {
        String headerVal;
        int idx;
        Header content = this._method.getResponseHeader(CONTENT_TYPE);
        if (content != null && (idx = (headerVal = content.getValue()).indexOf(";charset=")) > -1) {
            this._encoding = headerVal.substring(idx + 9);
        }
        return this._encoding;
    }

    public HttpState getState() {
        return this._state;
    }

    public String toString() {
        Object resBody;
        StringBuffer sb = new StringBuffer(255);
        sb.append("[RESPONSE STATUS LINE] -> ");
        sb.append(((HttpMethodBase)this._method).getParams().getVersion().equals(HttpVersion.HTTP_1_1) ? "HTTP/1.1 " : "HTTP/1.0 ");
        sb.append(this._method.getStatusCode()).append(' ');
        sb.append(this._method.getStatusText()).append('\n');
        Header[] headers = this._method.getResponseHeaders();
        if (headers != null && headers.length != 0) {
            for (int i = 0; i < headers.length; ++i) {
                sb.append("       [RESPONSE HEADER] -> ");
                sb.append(headers[i].toExternalForm()).append('\n');
            }
        }
        try {
            resBody = this._method.getResponseBodyAsString();
        }
        catch (IOException ioe) {
            resBody = "UNEXECTED EXCEPTION: " + ioe.toString();
        }
        if (resBody != null && ((String)resBody).length() != 0) {
            sb.append("------ [RESPONSE BODY] ------\n");
            sb.append((String)resBody);
            sb.append("\n-----------------------------\n\n");
        }
        return sb.toString();
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._isSecure ? "https" : "http";
    }

    public String getPath() {
        return this._method.getPath();
    }

    private String getEncodedResponse() throws IOException {
        if (this._responseBody == null) {
            this._responseBody = Util.getEncodedStringFromStream(this._method.getResponseBodyAsStream(), this.getResponseEncoding());
        }
        return this._responseBody;
    }
}

