/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class Package {
    private String name;
    private String pack;
    private boolean badPackage = false;
    private String failureReason = null;
    private String[] depends;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPackage(String pack) {
        this.pack = pack;
    }

    public String getPackage() {
        return this.pack;
    }

    public void setDepends(String d) {
        if (d == null) {
            throw new RuntimeException("depends cannot be set to null");
        }
        StringTokenizer tok = new StringTokenizer(d, ", \t");
        this.depends = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.depends[i] = tok.nextToken();
            ++i;
        }
    }

    public String[] getDepends() {
        return this.depends;
    }

    public FileSet getJavaCopyFileSet(Project p, Location l) throws BuildException {
        if (this.failureReason != null) {
            throw new BuildException(this.failureReason, l);
        }
        if (this.pack.indexOf("/") != -1 || this.pack.indexOf("\\") != -1) {
            throw new BuildException("A package name cannot contain '\\' or '/' like package=" + this.pack + "\nIt must look like biz.xsoftware.* for example", l);
        }
        FileSet set = new FileSet();
        String match = this.getMatch(p, this.pack, ".java");
        set.setIncludes(match);
        return set;
    }

    public FileSet getClassCopyFileSet(Project p, Location l) throws BuildException {
        FileSet set = new FileSet();
        set.setIncludes("**/*.class");
        return set;
    }

    public File getBuildSpace(File baseDir) {
        return new File(baseDir, this.name);
    }

    public Path getSrcPath(File baseDir, Project p) {
        Path path = new Path(p);
        path.setLocation(this.getBuildSpace(baseDir));
        return path;
    }

    public Path getClasspath(File baseDir, Project p) {
        Path path = new Path(p);
        if (this.depends != null) {
            for (int i = 0; i < this.depends.length; ++i) {
                String buildSpace = this.depends[i];
                File dependsDir = new File(baseDir, buildSpace);
                path.setLocation(dependsDir);
            }
        }
        return path;
    }

    private String getMatch(Project p, String pack, String postFix) {
        String match;
        pack = p.replaceProperties(pack);
        if ((pack = pack.replace('.', File.separatorChar)).endsWith("**")) {
            match = pack + File.separatorChar + "*" + postFix;
        } else if (pack.endsWith("*")) {
            match = pack + postFix;
        } else {
            throw new RuntimeException("Please report this bug");
        }
        return match;
    }

    public void setFaultReason(String r) {
        this.failureReason = r;
    }
}

