/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)Ctor.test.xml	1.3 02/12/17 Oleg Oleinik
 * Generated from : api/jakarta_xml/bind/helpers/PrintConversionEventImpl/Ctor.test.xml
 *
 * Constructor tests
 * Constructor tests.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.helpers.PrintConversionEventImpl;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.helpers.PrintConversionEventImpl;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class CtorTests extends MultiTest {

    int[] valid_severity = {ValidationEvent.ERROR, ValidationEvent.FATAL_ERROR, ValidationEvent.WARNING};
    int[] invalid_severity = {3, -1, 65535};

    ValidationEventLocator[] valid_locator = null;
    {
        try {
            valid_locator = new ValidationEventLocator[] {new MyValidationEventLocator(new java.net.URL("http://www.sun.com"), 10, 10, 10, null, null)};
        } catch (java.net.MalformedURLException me) {
            throw new RuntimeException(me.toString());
        }
    }
    ValidationEventLocator[] invalid_locator = {null};

    Throwable[] valid_exception = {new Error("error"), new Exception("exception"), 
        new RuntimeException("runtime exception"), new Throwable("throwable")};
    Throwable[] invalid_exception = {null};

    String[] valid_message = {"error"};
    String[] invalid_message = {"", null};

    /* standalone interface */
    public static void main(String argv[]) {
        CtorTests test = new CtorTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public PrintConversionEventImpl(int _severity, java.lang.String _message, ValidationEventLocator _locator),
     * PrintConversionEventImpl(int, String, ValidationEventLocator) with all arguments non-null, valid: getLinkedException() returns
     * null if the linked exception wasn't set..
     * <br><b>Expected results</b>: returns null
     */
    public Status Ctor001() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            for (int i_message = 0; i_message < valid_message.length; ++i_message){
                for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
                    PrintConversionEventImpl event = new PrintConversionEventImpl(valid_severity[i_severity], valid_message[i_message],
                         valid_locator[i_locator]);
                    if (event.getSeverity() != valid_severity[i_severity]){
                        return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getSeverity() returns " + event.getSeverity());
                    }
                    if (!valid_message[i_message].equals(event.getMessage())){
                        return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getMessage() returns " + event.getMessage());
                    }
                    ValidationEventLocator locator = event.getLocator();
                    if (locator.getOffset() != 10 || locator.getLineNumber() != 10 || locator.getColumnNumber() != 10){
                        return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getLocator() returns wrong object");
                    }
                    if (event.getLinkedException() != null){
                        return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                        "\", non-null locator):  getLinkedException() returns non-null value");
                    }
                }
            }
        }
        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public PrintConversionEventImpl(int _severity, java.lang.String _message, ValidationEventLocator _locator, java.lang.Throwable _linkedException),
     * PrintConversionEventImpl(int, String, ValidationEventLocator, Throwable) with all arguments non-null, valid: getLinkedException() returns
     * the linked exception for this warning/error..
     * <br><b>Expected results</b>: returns the exception with which PrintConversionEventImpl object was created
     */
    public Status Ctor101() {
        for (int i_severity = 0; i_severity < valid_severity.length; ++i_severity){
            for (int i_message = 0; i_message < valid_message.length; ++i_message){
                for (int i_locator = 0; i_locator < valid_locator.length; ++i_locator){
                    for (int i_exception = 0; i_exception < valid_exception.length; ++i_exception){
                        PrintConversionEventImpl event = new PrintConversionEventImpl(valid_severity[i_severity], valid_message[i_message],
                            valid_locator[i_locator], valid_exception[i_exception]);
                        if (event.getSeverity() != valid_severity[i_severity]){
                            return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getSeverity() returns " + event.getSeverity());
                        }
                        if (!valid_message[i_message].equals(event.getMessage())){
                            return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getMessage() returns " + event.getMessage());
                        }
                        ValidationEventLocator locator = event.getLocator();
                        if (locator.getOffset() != 10 || locator.getLineNumber() != 10 || locator.getColumnNumber() != 10){
                            return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getLocator() returns wrong object");
                        }
                        Throwable e = event.getLinkedException();
                        if (!(valid_exception[i_exception].getClass().isInstance(e)) || !(e.getMessage().equals(valid_exception[i_exception].getMessage()))){
                            return Status.failed("PrintConversionEventImpl(" + valid_severity[i_severity] + ", \"" + valid_message[i_message] +
                            "\", non-null locator, non-null exception):  getLinkedException() returns wrong value");
                        }
                    }
                }
            }
        }
        return Status.passed("OKAY");
    }
}

    class MyValidationEventLocator implements ValidationEventLocator {
        java.net.URL url = null;
        int offset = -1;
        int lineNumber = -1;
        int columnNumber = -1;
        Object object = null;
        org.w3c.dom.Node node = null;
        
        public MyValidationEventLocator (java.net.URL url, int offset, int lineNumber, 
                int columnNumber, Object object, org.w3c.dom.Node node){
            this.url = url;
            this.offset = offset;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
            this.object = object;
            this.node = node;
        }
        public java.net.URL getURL(){
            return url;
        }
        public int getOffset(){
            return offset;
        }
        public int getLineNumber(){
            return lineNumber;
        }
        public int getColumnNumber(){
            return columnNumber;
        }
        public java.lang.Object getObject(){
            return object;
        }
        public org.w3c.dom.Node getNode(){
            return node;
        }
    }
