/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import net.sf.antcontrib.net.httpclient.AbstractHttpStateTypeTask;
import net.sf.antcontrib.net.httpclient.HttpStateType;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Property;

public class GetCookieTask
extends AbstractHttpStateTypeTask {
    private String property;
    private String prefix;
    private String cookiePolicy = "default";
    private String realm = null;
    private int port = 80;
    private String path = null;
    private boolean secure = false;
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setCookiePolicy(String cookiePolicy) {
        this.cookiePolicy = cookiePolicy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    private Cookie findCookie(Cookie[] cookies, String name) {
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            return cookies[i];
        }
        return null;
    }

    protected void execute(HttpStateType stateType) throws BuildException {
        if (this.realm == null || this.path == null) {
            throw new BuildException("'realm' and 'path' attributes are required");
        }
        HttpState state = stateType.getState();
        CookieSpec spec = CookiePolicy.getCookieSpec((String)this.cookiePolicy);
        Cookie[] cookies = state.getCookies();
        Cookie[] matches = spec.match(this.realm, this.port, this.path, this.secure, cookies);
        if (this.name != null) {
            Cookie c = this.findCookie(matches, this.name);
            matches = c != null ? new Cookie[]{c} : new Cookie[]{};
        }
        if (this.property != null) {
            if (matches != null && matches.length > 0) {
                Property p = (Property)this.getProject().createTask("property");
                p.setName(this.property);
                p.setValue(matches[0].getValue());
                p.perform();
            }
        } else if (this.prefix != null) {
            if (matches != null && matches.length > 0) {
                for (int i = 0; i < matches.length; ++i) {
                    String propName = this.prefix + matches[i].getName();
                    Property p = (Property)this.getProject().createTask("property");
                    p.setName(propName);
                    p.setValue(matches[i].getValue());
                    p.perform();
                }
            }
        } else {
            throw new BuildException("Nothing to set");
        }
    }
}

