/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.collections;

import ee.jakarta.tck.json.bind.defaultmapping.collections.model.ArrayDequeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.ArrayListContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.CollectionContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.DequeContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.EnumMapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.EnumSetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.HashSetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.LinkedHashMapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.LinkedHashSetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.LinkedListContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.ListContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.MapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.NavigableMapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.NavigableSetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.PriorityQueueContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.QueueContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.SetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.SortedMapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.SortedSetContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.TreeMapContainer;
import ee.jakarta.tck.json.bind.defaultmapping.collections.model.TreeSetContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CollectionsMappingTest {
    private static final String COLLECTION_JSON = "{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }";
    private static final String MAP_JSON = "{ \"instance\" : { \"string1\" : \"Test 1\", \"string2\" : \"Test 2\" } }";
    private static final Pattern COLLECTION_PATTERN = Pattern.compile("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"Test \\d\"\\s*,\\s*\"Test \\d\"\\s*\\]\\s*\\}");
    private static final Pattern MAP_PATTERN = Pattern.compile("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"string1\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"string2\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}");
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testCollection() {
        String jsonString = (String)Assertions.assertDoesNotThrow(() -> this.jsonb.toJson((Object)new CollectionContainer(){
            {
                this.setInstance((Collection<String>)Arrays.asList("Test 1", "Test 2"));
            }
        }), (String)"An exception is not expected when marshalling a class with a Collection attribute.");
        MatcherAssert.assertThat((String)"Failed to get Collection attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}"));
        CollectionContainer unmarshall = (CollectionContainer)Assertions.assertDoesNotThrow(() -> (CollectionContainer)this.jsonb.fromJson(COLLECTION_JSON, CollectionContainer.class), (String)"An exception is not expected when unmarshalling a class with a Collection attribute.");
        MatcherAssert.assertThat((String)"Failed to marshal object with Collection attribute.", (Object)unmarshall.getInstance(), (Matcher)Matchers.contains((Object[])new String[]{"Test 1", "Test 2"}));
    }

    @Test
    public void testMap() {
        final HashMap<String, String> instance = new HashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new MapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get Map attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        MapContainer unmarshalledObject = (MapContainer)this.jsonb.fromJson(MAP_JSON, MapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with Map attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testSet() {
        final HashSet<String> instance = new HashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get Set attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        SetContainer unmarshalledObject = (SetContainer)this.jsonb.fromJson(COLLECTION_JSON, SetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with Set attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testHashSet() {
        final HashSet<String> instance = new HashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new HashSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get HashSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        HashSetContainer unmarshalledObject = (HashSetContainer)this.jsonb.fromJson(COLLECTION_JSON, HashSetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with HashSet attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testNavigableSet() {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new NavigableSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get NavigableSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        NavigableSetContainer unmarshalledObject = (NavigableSetContainer)this.jsonb.fromJson(COLLECTION_JSON, NavigableSetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with NavigableSet attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testSortedSet() {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SortedSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get SortedSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        SortedSetContainer unmarshalledObject = (SortedSetContainer)this.jsonb.fromJson(COLLECTION_JSON, SortedSetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with SortedSet attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testTreeSet() {
        final TreeSet<String> instance = new TreeSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new TreeSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get TreeSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        TreeSetContainer unmarshalledObject = (TreeSetContainer)this.jsonb.fromJson(COLLECTION_JSON, TreeSetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with TreeSet attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testLinkedHashSet() {
        final LinkedHashSet<String> instance = new LinkedHashSet<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedHashSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get LinkedHashSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        LinkedHashSetContainer unmarshalledObject = (LinkedHashSetContainer)this.jsonb.fromJson(COLLECTION_JSON, LinkedHashSetContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with LinkedHashSet attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testHashMap() {
        final HashMap<String, String> instance = new HashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new MapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get HashMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        MapContainer unmarshalledObject = (MapContainer)this.jsonb.fromJson(MAP_JSON, MapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with HashMap attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testNavigableMap() {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new NavigableMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get NavigableMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        NavigableMapContainer unmarshalledObject = (NavigableMapContainer)this.jsonb.fromJson(MAP_JSON, NavigableMapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with NavigableMap attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testSortedMap() {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new SortedMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get SortedMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        SortedMapContainer unmarshalledObject = (SortedMapContainer)this.jsonb.fromJson(MAP_JSON, SortedMapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with SortedMap attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testTreeMap() {
        final TreeMap<String, String> instance = new TreeMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new TreeMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get TreeMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        TreeMapContainer unmarshalledObject = (TreeMapContainer)this.jsonb.fromJson(MAP_JSON, TreeMapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with TreeMap attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testLinkedHashMap() {
        final LinkedHashMap<String, String> instance = new LinkedHashMap<String, String>(){
            {
                this.put("string1", "Test 1");
                this.put("string2", "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedHashMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get LinkedHashMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)MAP_PATTERN));
        LinkedHashMapContainer unmarshalledObject = (LinkedHashMapContainer)this.jsonb.fromJson(MAP_JSON, LinkedHashMapContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with LinkedHashMap attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testList() {
        final ArrayList<String> instance = new ArrayList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ListContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get List attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        ListContainer unmarshalledObject = (ListContainer)this.jsonb.fromJson(COLLECTION_JSON, ListContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with List attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testArrayList() {
        final ArrayList<String> instance = new ArrayList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ArrayListContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get ArrayList attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        ArrayListContainer unmarshalledObject = (ArrayListContainer)this.jsonb.fromJson(COLLECTION_JSON, ArrayListContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with ArrayList attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testLinkedList() {
        final LinkedList<String> instance = new LinkedList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new LinkedListContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get LinkedList attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        LinkedListContainer unmarshalledObject = (LinkedListContainer)this.jsonb.fromJson(COLLECTION_JSON, LinkedListContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with LinkedList attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)instance));
    }

    @Test
    public void testDeque() {
        final ArrayDeque<String> instance = new ArrayDeque<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new DequeContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get Deque attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        DequeContainer unmarshalledObject = (DequeContainer)this.jsonb.fromJson(COLLECTION_JSON, DequeContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with Deque attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.contains((Object[])instance.toArray()));
    }

    @Test
    public void testArrayDeque() {
        final ArrayDeque<String> instance = new ArrayDeque<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new ArrayDequeContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get ArrayDeque attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        ArrayDequeContainer unmarshalledObject = (ArrayDequeContainer)this.jsonb.fromJson(COLLECTION_JSON, ArrayDequeContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with ArrayDeque attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.contains((Object[])instance.toArray()));
    }

    @Test
    public void testQueue() {
        final LinkedList<String> instance = new LinkedList<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new QueueContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get Queue attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        QueueContainer unmarshalledObject = (QueueContainer)this.jsonb.fromJson(COLLECTION_JSON, QueueContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with Queue attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.contains((Object[])instance.toArray()));
    }

    @Test
    public void testPriorityQueue() {
        final PriorityQueue<String> instance = new PriorityQueue<String>(){
            {
                this.add("Test 1");
                this.add("Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new PriorityQueueContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get PriorityQueue attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)COLLECTION_PATTERN));
        PriorityQueueContainer unmarshalledObject = (PriorityQueueContainer)this.jsonb.fromJson(COLLECTION_JSON, PriorityQueueContainer.class);
        MatcherAssert.assertThat((String)"Failed to marshal object with PriorityQueue attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.contains((Object[])instance.toArray()));
    }

    @Test
    @Disabled(value="See: https://github.com/eclipse-ee4j/jakartaee-tck/issues/103")
    public void testEnumSet() {
        final EnumSet<EnumSetContainer.Enum> instance = EnumSet.allOf(EnumSetContainer.Enum.class);
        String jsonString = this.jsonb.toJson((Object)new EnumSetContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get EnumSet attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\"ONE\"\\s*,\\s*\"TWO\"\\s*\\]\\s*\\}"));
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : [ \"ONE\", \"TWO\" ] }", EnumSetContainer.class), (String)"An exception is expected when unmarshalling a class with an EnumSet attribute.");
    }

    @Test
    @Disabled(value="See: https://github.com/eclipse-ee4j/jakartaee-tck/issues/103")
    public void testEnumMap() {
        final EnumMap<EnumSetContainer.Enum, String> instance = new EnumMap<EnumSetContainer.Enum, String>(EnumSetContainer.Enum.class){
            {
                this.put(EnumSetContainer.Enum.ONE, "Test 1");
                this.put(EnumSetContainer.Enum.TWO, "Test 2");
            }
        };
        String jsonString = this.jsonb.toJson((Object)new EnumMapContainer(){
            {
                this.setInstance(instance);
            }
        });
        MatcherAssert.assertThat((String)"Failed to get EnumMap attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"ONE\"\\s*:\\s*\"Test 1\"\\s*,\\s*\"TWO\"\\s*:\\s*\"Test 2\"\\s*\\}\\s*\\}"));
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.fromJson("{ \"instance\" : { \"ONE\" : \"Test 1\", \"TWO\" : \"Test 2\" } }", EnumSetContainer.class), (String)"An exception is expected when unmarshalling a class with an EnumMap attribute.");
    }
}

