/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant;

import com.sun.ant.taskdefs.common.TaskUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.apache.tools.ant.types.Path;

public class TSBuildListener
implements BuildListener {
    private static String dtdDir;
    private static String schemaDir;
    public static boolean vehiclesBuilt;
    private static boolean isBin;
    public static String tsHome;
    public static String jdkHome;
    public static String j2eeHomeRi;
    public static String sSrcDir;
    public static File fSrcDir;
    public static String sClassDir;
    public static File fClassDir;
    public static File fBin;
    private static Path tsClasspath;
    private static boolean skipMakeup;
    private static byte askTimes;
    private static boolean alreadyMadeup;

    public static Path getTsClasspath(Project project) {
        if (tsClasspath != null) {
            return tsClasspath;
        }
        String sTsClasspath = project.getUserProperty("ts.classpath");
        if ((sTsClasspath == null || sTsClasspath.length() == 0) && (sTsClasspath = System.getProperty("ts.classpath")) == null) {
            File[] libJars;
            project.log("WARNING: could not get ts.classpath from System.", 1);
            if (j2eeHomeRi == null) {
                project.log("j2ee.home.ri not set, use ts.home as j2ee.home.ri");
            }
            if ((libJars = new File(tsHome, "lib").listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (!pathname.isFile()) {
                        return false;
                    }
                    String fname = pathname.getName();
                    return fname.endsWith(".jar") && !fname.equals("riinterceptors.jar");
                }
            })) != null) {
                sTsClasspath = "";
                for (int i = 0; i < libJars.length; ++i) {
                    sTsClasspath = sTsClasspath + libJars[i].getPath() + ":";
                }
                if (j2eeHomeRi != null) {
                    sTsClasspath = sTsClasspath + j2eeHomeRi + File.separator + "lib" + File.separator + "j2ee.jar";
                }
            }
        }
        tsClasspath = new Path(project, sTsClasspath + ":" + sClassDir);
        return tsClasspath;
    }

    public static boolean getAlreadyMadeup() {
        return alreadyMadeup;
    }

    public static void setAlreadyMadeup(boolean b) {
        alreadyMadeup = b;
    }

    public static boolean skipMakeupCompile() {
        String sUserDir;
        File userDir;
        if (askTimes > 0) {
            return skipMakeup;
        }
        skipMakeup = isBin ? true : (userDir = new File(sUserDir = System.getProperty("user.dir"))).compareTo(new File(tsHome, "src")) == 0;
        askTimes = 1;
        return skipMakeup;
    }

    private void checkAntVersion() {
        String antVersion = Main.getAntVersion();
        if (!antVersion.startsWith("Ant version 1.4.1")) {
            throw new BuildException("Expect Ant version 1.4.1, but found " + antVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(BuildEvent event) {
        Project proj = event.getProject();
        this.defineUserEnv(proj);
        tsHome = proj.getProperty("env.TS_HOME");
        Hashtable table = event.getProject().getProperties();
        proj.log("Dumping ANTS properties from:  TSBuildListener.buildStarted()", 3);
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String sourceKey = (String)keys.nextElement();
            String sourceVal = (String)table.get(sourceKey);
            proj.log("KEY = " + sourceKey, 3);
            proj.log("VAL = " + sourceVal, 3);
        }
        if (tsHome == null) {
            throw new BuildException("TS_HOME is not set in the environment or as system property.");
        }
        System.setProperty("ts.home", tsHome);
        proj.setUserProperty("ts.home", tsHome);
        System.out.println("TS_HOME Environment variable set to \"" + tsHome + "\"");
        jdkHome = proj.getProperty("env.JAVA_HOME");
        if (jdkHome == null) {
            throw new BuildException("JAVA_HOME is not set in the environment or as system property.");
        }
        System.setProperty("jdk.home", jdkHome);
        proj.setUserProperty("jdk.home", jdkHome);
        fBin = new File(tsHome, "bin");
        String sUserDir = System.getProperty("user.dir");
        if (new File(sUserDir).compareTo(fBin) == 0 || new File(sUserDir, "ts.jte").exists() || new File(sUserDir, "ts.jtx").exists() || new File(sUserDir, "version").exists()) {
            isBin = true;
        }
        String vehicleDir = "com" + File.separator + "sun" + File.separator + "ts" + File.separator + "tests" + File.separator + "common" + File.separator + "vehicle";
        proj.setUserProperty("vehicle.dir", vehicleDir);
        sSrcDir = tsHome + File.separator + "src";
        fSrcDir = new File(sSrcDir);
        Properties buildProps = new Properties();
        boolean noBuildProps = false;
        FileInputStream ins = null;
        try {
            File pfile = new File(tsHome + File.separator + "bin" + File.separator + "build.properties");
            if (!pfile.exists()) {
                pfile = new File(tsHome + File.separator + "bin" + File.separator + "ts.jte");
            }
            ins = new FileInputStream(pfile);
            buildProps.load(ins);
            buildProps.setProperty("ts.home", tsHome);
            this.resolveAllProperties(buildProps, proj);
            this.checkJ2eeHomeRi(buildProps, proj);
            System.err.println("build.vi = " + System.getProperty("build.vi", "false"));
            sClassDir = System.getProperty("build.vi", "false").equals("true") ? tsHome + File.separator + "classes_vi_built" : tsHome + File.separator + "classes";
            fClassDir = new File(sClassDir);
            proj.setUserProperty("class.dir", sClassDir);
            System.setProperty("class.dir", sClassDir);
            System.err.println("class.dir set to:  " + System.getProperty("class.dir"));
            fClassDir.mkdir();
        }
        catch (IOException ex) {
            noBuildProps = true;
            if (sUserDir != null && sUserDir.replace('\\', '/').indexOf((tsHome + "/install").replace('\\', '/')) == -1) {
                throw new BuildException("Could not find top level ts.jte or build.properties");
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ex) {}
            }
        }
        if (!noBuildProps) {
            Enumeration<?> enum1 = buildProps.propertyNames();
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String val = buildProps.getProperty(key);
                proj.setUserProperty(key, val);
            }
            String sDeliverableClass = proj.getUserProperty("deliverable.class");
            if (sDeliverableClass == null || sDeliverableClass.length() == 0) {
                throw new BuildException("deliverable.class property not set in ts.jte or build.properties.");
            }
            String sTsClasspath = proj.getUserProperty("ts.classpath");
            if (sTsClasspath != null && sTsClasspath.length() != 0) {
                System.setProperty("ts.classpath", sTsClasspath);
            }
            System.setProperty("deliverable.class", sDeliverableClass);
            String endorsedDir = proj.getUserProperty("java.endorsed.dirs");
            if (endorsedDir == null) {
                endorsedDir = proj.getProperty("java.endorsed.dirs");
            }
            if (endorsedDir != null) {
                System.setProperty("java.endorsed.dirs", endorsedDir);
            }
        }
        try {
            proj.addDataTypeDefinition("support", Class.forName("com.sun.ant.types.Support"));
            proj.addTaskDefinition("translatepath", Class.forName("com.sun.ant.taskdefs.common.PathTranslator"));
            proj.addTaskDefinition("elementappend", Class.forName("com.sun.ant.taskdefs.common.ElementAppend"));
            proj.addTaskDefinition("getclient", Class.forName("com.sun.ant.taskdefs.common.GetClient"));
            proj.addTaskDefinition("dosubdirs", Class.forName("com.sun.ant.taskdefs.common.DoSubdirs"));
            proj.addTaskDefinition("dotarget", Class.forName("com.sun.ant.taskdefs.common.DoTarget"));
            proj.addTaskDefinition("webwar", Class.forName("com.sun.ant.taskdefs.web.WebWar"));
            proj.addTaskDefinition("clientjar", Class.forName("com.sun.ant.taskdefs.client.ClientJar"));
            proj.addTaskDefinition("appear", Class.forName("com.sun.ant.taskdefs.app.J2eeEar"));
            proj.addTaskDefinition("resrar", Class.forName("com.sun.ant.taskdefs.connector.ConnectorRar"));
            proj.addTaskDefinition("ejb-jar", Class.forName("com.sun.ant.taskdefs.ejb.EJBJar"));
            proj.addTaskDefinition("vehicles", Class.forName("com.sun.ant.taskdefs.common.TSVehicles"));
            proj.addTaskDefinition("package", Class.forName("com.sun.ant.taskdefs.common.ContainerPackage"));
            proj.addTaskDefinition("ant", Class.forName("org.apache.tools.ant.taskdefs.Ant"));
            proj.addTaskDefinition("property", Class.forName("org.apache.tools.ant.taskdefs.Property"));
            proj.addTaskDefinition("appendafter", Class.forName("com.sun.ant.taskdefs.common.AppendAfter"));
            proj.addTaskDefinition("insertbefore", Class.forName("com.sun.ant.taskdefs.common.InsertBefore"));
            proj.addTaskDefinition("encode", Class.forName("com.sun.ant.taskdefs.common.Encoder"));
            proj.addTaskDefinition("propertyindex", Class.forName("com.sun.ant.taskdefs.common.PropertyIndex"));
            if (TaskUtil.isCompatDir(System.getProperty("user.dir"))) {
                proj.addTaskDefinition("compathelper", Class.forName("com.sun.ant.taskdefs.common.CompatHelper"));
            }
        }
        catch (ClassNotFoundException nodef) {
            nodef.printStackTrace();
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
        }
        this.addImplicitTargets(proj, tsHome);
        proj.setUserProperty("dist.dir", tsHome + File.separator + "dist");
        System.setProperty("dist.dir", tsHome + File.separator + "dist");
    }

    private void defineUserEnv(Project proj) {
        Property propertyTask = new Property();
        propertyTask.setProject(proj);
        propertyTask.init();
        propertyTask.setTaskName("listener");
        propertyTask.setEnvironment("env");
        propertyTask.execute();
    }

    private void checkJ2eeHomeRi(Properties props, Project proj) {
        String jri = props.getProperty("j2ee.home.ri");
        if (jri != null && jri.length() != 0) {
            j2eeHomeRi = jri;
            return;
        }
        jri = proj.getProperty("env.J2EE_HOME_RI");
        if (jri != null) {
            props.setProperty("j2ee.home.ri", jri);
            j2eeHomeRi = jri;
        } else {
            String tmp = props.getProperty("build.level");
            if (tmp == null || !tmp.equals("1")) {
                proj.log("j2ee.home.ri not set in ts.jte  or build.properties file; J2EE_HOME_RI not set in environment.", 3);
            }
        }
    }

    private void addTaskDefinition(Project proj, String tsHome, String[][] toAdd) {
        if (toAdd == null) {
            return;
        }
        Path path = TSBuildListener.getTsClasspath(proj);
        for (int i = 0; i < toAdd.length; ++i) {
            String taskType = toAdd[i][0];
            String className = toAdd[i][1];
            Taskdef taskdef = new Taskdef();
            taskdef.setProject(proj);
            taskdef.init();
            taskdef.setName(taskType);
            taskdef.setClassname(className);
            taskdef.setClasspath(path);
            taskdef.execute();
            proj.log("Added" + taskType + " " + className + " " + path.toString());
        }
    }

    private void printAllProps(Project proj) {
        String val;
        Hashtable ht = proj.getProperties();
        proj.log("The following are all " + ht.size() + " properties:", 3);
        for (String key : ht.keySet()) {
            val = (String)ht.get(key);
            proj.log(key + "=" + val, 3);
        }
        ht = proj.getUserProperties();
        proj.log("The following are all " + ht.size() + " user properties:", 3);
        for (String key : ht.keySet()) {
            val = (String)ht.get(key);
            proj.log(key + "=" + val, 3);
        }
    }

    private void addImplicitTargets(Project proj, String tsHome) {
        String sUserDir;
        String pkgDir;
        String guiName = "gui";
        File baseDir = proj.getBaseDir();
        if (!isBin && (pkgDir = TaskUtil.path2PkgDir(sUserDir = System.getProperty("user.dir"))) != null) {
            proj.setProperty("pkg.dir", pkgDir);
        }
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    private void resolveAllProperties(Properties props, Project proj) throws BuildException {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly defined.");
                        }
                        fragment = proj.getProperty(propertyName);
                        if (fragment == null) {
                            if (props.containsKey(propertyName)) {
                                fragment = props.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                props.put(name, value);
            }
        }
    }

    public static String getDtdDir(Project project) {
        if (dtdDir == null) {
            if (j2eeHomeRi != null) {
                dtdDir = j2eeHomeRi + File.separator + "lib" + File.separator + "dtds";
            } else {
                String altDtdDir = project.getProperty("alt.dtd.dir");
                if (altDtdDir == null || altDtdDir.length() == 0) {
                    altDtdDir = tsHome + File.separator + "lib" + File.separator + "dtds";
                }
                dtdDir = altDtdDir;
            }
            project.log("Searching dtds in: " + dtdDir);
        }
        return dtdDir;
    }

    public static String getSchemaDir(Project project) {
        if (schemaDir == null) {
            if (j2eeHomeRi != null) {
                schemaDir = j2eeHomeRi + File.separator + "lib" + File.separator + "schemas";
            } else {
                String altschemaDir = project.getProperty("alt.schema.dir");
                if (altschemaDir == null || altschemaDir.length() == 0) {
                    altschemaDir = tsHome + File.separator + "lib" + File.separator + "schemas";
                }
                schemaDir = altschemaDir;
            }
            project.log("Searching schemas in: " + schemaDir);
        }
        return schemaDir;
    }

    static {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.indexOf("xp") != -1 && osName.indexOf("windows") != -1) {
            System.setProperty("os.name", "Windows 2000");
        }
    }
}

