/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceQuestion
extends Question {
    protected String value;
    private String[] choices;
    private String[] displayChoices;
    private String defaultValue;

    protected ChoiceQuestion(Interview interview, String tag) {
        super(interview, tag);
    }

    protected ChoiceQuestion(Interview interview, String tag, String ... choices) {
        super(interview, tag);
        this.setChoices(choices, choices);
    }

    protected void setChoices(String[] choices, boolean localize) {
        this.setChoices(choices, localize ? null : choices);
    }

    protected void setChoices(String[] choices, String ... displayChoices) {
        if (choices == null) {
            throw new NullPointerException();
        }
        if (displayChoices != null && choices.length != displayChoices.length) {
            throw new IllegalArgumentException();
        }
        boolean needClear = this.choices == null;
        this.choices = choices;
        this.displayChoices = displayChoices;
        this.defaultValue = choices[0];
        if (needClear && this.interview.getInterviewSemantics() > 0) {
            this.clear();
        } else if (this.value == null) {
            this.value = choices[0];
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        } else {
            for (String choice : choices) {
                if (!this.value.equals(choice)) continue;
                this.value = choice;
                return;
            }
            this.value = choices[0];
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    @Deprecated
    protected void setI18NChoices(String ... choices) {
        this.setChoices(choices, true);
    }

    public String[] getChoices() {
        return this.choices;
    }

    protected void setChoices(String ... choices) {
        this.setChoices(choices, choices);
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle b = this.interview.getResourceBundle();
            if (b == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            for (int i = 0; i < this.choices.length; ++i) {
                String c = this.choices[i];
                try {
                    this.displayChoices[i] = c == null ? null : b.getString(this.key + "." + c);
                    continue;
                }
                catch (MissingResourceException e) {
                    this.displayChoices[i] = c;
                }
            }
        }
        return this.displayChoices;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String v) {
        this.defaultValue = v;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        if (this.choices == null) {
            return;
        }
        if (newValue == null) {
            if (this.value != null) {
                this.value = null;
                this.interview.updatePath(this);
                this.interview.setEdited(true);
            }
        } else {
            for (String choice : this.choices) {
                if (!newValue.equals(choice)) continue;
                newValue = choice;
                break;
            }
            if (!newValue.equals(this.value)) {
                this.value = newValue;
                this.interview.updatePath(this);
                this.interview.setEdited(true);
            }
        }
    }

    public String getDisplayValue() {
        this.getDisplayChoices();
        String v = this.getValue();
        for (int i = 0; i < this.choices.length; ++i) {
            if (!(v == null ? this.choices[i] == null : v.equals(this.choices[i]))) continue;
            return this.displayChoices[i];
        }
        return v;
    }

    public String getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return this.getValue();
    }

    @Override
    public boolean isValueValid() {
        for (String choice : this.choices) {
            if (!(this.value == null ? choice == null : this.value.equals(choice))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void save(Map<String, String> data) {
        if (this.value != null) {
            data.put(this.tag, this.value);
        }
    }
}

