/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;

public abstract class TemplateFilter
implements ContainerResponseFilter {
    public static final String OPERATION = "OPERATION";
    public static final String PROPERTYNAME = "getSetProperty";
    public static final String HEADER = "HEADER";
    protected ContainerRequestContext requestContext;
    protected ContainerResponseContext responseContext;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Method[] methods;
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        String operation = this.getHeaderString();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!operation.equalsIgnoreCase(method.getName())) continue;
            try {
                method.invoke((Object)this, new Object[0]);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                responseContext.setStatus(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
                this.setEntity(e.getMessage());
                return;
            }
        }
        this.operationMethodNotFound(operation);
    }

    protected void operationMethodNotFound(String operation) {
        this.responseContext.setStatus(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
        this.setEntity("Operation " + operation + " not implemented");
    }

    protected static <T> String collectionToString(Collection<T> collection) {
        StringBuilder sb = new StringBuilder();
        for (T item : collection) {
            String replace = item.toString().toLowerCase().replace("_", "-").replace(" ", "");
            sb.append(replace).append(" ");
        }
        return sb.toString();
    }

    protected boolean assertTrue(boolean conditionTrue, Object ... msg) {
        if (conditionTrue) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            for (Object str : msg) {
                sb.append(str).append(" ");
            }
        }
        this.setEntity(sb.toString());
        this.responseContext.setStatus(Response.Status.NOT_ACCEPTABLE.getStatusCode());
        return true;
    }

    protected String getHeaderString() {
        MultivaluedMap headers = this.responseContext.getHeaders();
        return (String)headers.getFirst((Object)OPERATION);
    }

    protected void setEntity(String entity) {
        this.responseContext.setEntity((Object)entity, null, MediaType.TEXT_PLAIN_TYPE);
    }
}

