/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.abstractmultivaluedmap;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.AbstractMultivaluedMap;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -6248642901050437887L;
    protected static final String KEY = "key";
    static final String[] VALUES = new String[]{"value1", "value2", "value3", "value4", "value5"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        JAXRSClientIT.assertContainsDefaultValues(map);
    }

    @Test
    public void addTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add((Object)"key2", (Object)VALUES[3]);
        map.add((Object)"key2", (Object)VALUES[4]);
        JAXRSClientIT.assertContains(map, "key2", new Object[]{VALUES[3], VALUES[4]});
    }

    @Test
    public void addNullKeyTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add(null, (Object)VALUES[3]);
        JAXRSClientIT.assertContains(map, null, VALUES[3]);
    }

    @Test
    public void addNullValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add((Object)"key2", null);
        map.add((Object)"key3", null);
        JAXRSClientIT.assertNotContains(map, "key2", new Object[]{null});
        JAXRSClientIT.assertNotContains(map, "key3", new Object[]{null});
    }

    @Test
    public void addAllValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addAll((Object)KEY, new Object[]{VALUES[3], VALUES[4]});
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[3], VALUES[4]});
    }

    @Test
    public void addAllNullValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addAll((Object)KEY, new Object[]{VALUES[3], null});
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[3]});
        JAXRSClientIT.assertNotContains(map, KEY, new Object[]{null});
    }

    @Test
    public void addAllEmptyValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addAll((Object)"key2", new Object[0]);
        JAXRSClientIT.assertContainsDefaultValues(map);
        Assertions.assertTrue((!map.containsKey((Object)"key2") ? 1 : 0) != 0, (String)"The method didn't returned immediatelly when empty array");
    }

    @Test
    public void addAllThrowsNPETest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        try {
            map.addAll((Object)"key2", (Object[])null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", e);
            return;
        }
    }

    @Test
    public void addAllListTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[3]);
        list.add(VALUES[4]);
        map.addAll((Object)KEY, list);
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[3], VALUES[4]});
    }

    @Test
    public void addAllListNullValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[3]);
        list.add(null);
        map.addAll((Object)KEY, list);
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[3]});
        JAXRSClientIT.assertNotContains(map, KEY, new Object[]{null});
    }

    @Test
    public void addAllListEmptyValuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addAll((Object)"key2", new ArrayList());
        JAXRSClientIT.assertContainsDefaultValues(map);
        Assertions.assertTrue((!map.containsKey((Object)"key2") ? 1 : 0) != 0, (String)"The method didn't returned immediatelly when empty array");
    }

    @Test
    public void addAllListThrowsNPETest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        try {
            map.addAll((Object)"key2", (List)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", e);
            return;
        }
    }

    @Test
    public void addFirstTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addFirst((Object)KEY, (Object)VALUES[3]);
        Object first = map.getFirst((Object)KEY);
        Assertions.assertTrue((boolean)first.equals(VALUES[3]), (String)("First is unexpected item " + first));
        JAXRSClientIT.logMsg("Found first item", first);
    }

    @Test
    public void addFirstNullTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.addFirst((Object)KEY, null);
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertNotContains(map, KEY, new Object[]{null});
    }

    @Test
    public void clearTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.clear();
        JAXRSClientIT.assertNotContains(map, KEY, VALUES[0], VALUES[1], VALUES[2]);
    }

    @Test
    public void containsKeyTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add(null, (Object)VALUES[3]);
        Assertions.assertTrue((boolean)map.containsKey((Object)KEY), (String)"#containsKey has not found given key");
        Assertions.assertTrue((boolean)map.containsKey(null), (String)"#containsKey has not found NULL key");
        JAXRSClientIT.logMsg("#containsKey found non-null key and also the null key");
    }

    @Test
    public void containsValueTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        List list = map.get((Object)KEY);
        Assertions.assertTrue((boolean)map.containsValue((Object)list), (String)("#containsValue has not found " + list));
        Assertions.assertTrue((!map.containsValue((Object)VALUES[3]) ? 1 : 0) != 0, (String)("#containsValue has found " + VALUES[3]));
        Assertions.assertTrue((!map.containsValue((Object)KEY) ? 1 : 0) != 0, (String)"#containsValue has found key");
        JAXRSClientIT.logMsg("#containsValue() found list of items as expected");
    }

    @Test
    public void entrySetTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Assertions.assertTrue((boolean)((String)entry.getKey()).equals(KEY), (String)"no key has been found in #entrySet()");
            List list = (List)entry.getValue();
            Assertions.assertTrue((boolean)list.contains(VALUES[0]), (String)(VALUES[0] + " was not found in #entrySet()"));
            Assertions.assertTrue((boolean)list.contains(VALUES[1]), (String)(VALUES[1] + " was not found in #entrySet()"));
            Assertions.assertTrue((boolean)list.contains(VALUES[2]), (String)(VALUES[2] + " was not found in #entrySet()"));
        }
        JAXRSClientIT.logMsg("#entrySet() has correct values");
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[0]);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put(KEY, list);
        AbstractMultivaluedMap<String, Object> map = new AbstractMultivaluedMap<String, Object>(hashMap){};
        Assertions.assertTrue((boolean)map.equals(hashMap), (String)"delegation of #equals() not sucessfull");
        hashMap.put("key2", list);
        Assertions.assertTrue((boolean)map.equals(hashMap), (String)"delegation of #equals() not sucessfull");
        JAXRSClientIT.logMsg("#equals() is delegated to underlaying map");
    }

    @Test
    public void getTest() throws JAXRSCommonClient.Fault {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[0]);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put(KEY, list);
        AbstractMultivaluedMap<String, Object> map = new AbstractMultivaluedMap<String, Object>(hashMap){};
        Assertions.assertTrue((map.get((Object)KEY) == list ? 1 : 0) != 0, (String)"#get() not sucessfull");
        JAXRSClientIT.logMsg("#get() is sucessfull");
    }

    @Test
    public void hashCodeTest() throws JAXRSCommonClient.Fault {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[0]);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put(KEY, list);
        AbstractMultivaluedMap<String, Object> map = new AbstractMultivaluedMap<String, Object>(hashMap){};
        Assertions.assertTrue((map.hashCode() == map.hashCode() ? 1 : 0) != 0, (String)"delegation of #hashCode() not sucessfull");
        hashMap.put("key2", list);
        Assertions.assertTrue((map.hashCode() == map.hashCode() ? 1 : 0) != 0, (String)"delegation of #hashCode() not sucessfull");
        JAXRSClientIT.logMsg("#hashCode() is delegated to underlaying map");
    }

    @Test
    public void isEmptyTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        Assertions.assertTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"#isEmpty returns true for one key and a list");
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"#isEmpty returns false after #clear call");
        map.add(null, (Object)VALUES[0]);
        Assertions.assertTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"#isEmpty returns true for null key and a list");
        JAXRSClientIT.logMsg("#isEmpty returns correct values");
    }

    @Test
    public void keySetTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        Assertions.assertTrue((map.keySet().size() == 1 ? 1 : 0) != 0, (String)("#keySet returns set of size " + map.keySet().size() + " for one key"));
        map.add((Object)"key2", (Object)VALUES[3]);
        Assertions.assertTrue((map.keySet().size() == 2 ? 1 : 0) != 0, (String)("#keySet returns set of size " + map.keySet().size() + " for two keys"));
        Assertions.assertTrue((boolean)map.keySet().contains(KEY), (String)"key was not found");
        Assertions.assertTrue((boolean)map.keySet().contains("key2"), (String)"key2 was not found");
        map.clear();
        Assertions.assertTrue((map.keySet().size() == 0 ? 1 : 0) != 0, (String)("#keySet returns set of size " + map.keySet().size() + " after #clear()"));
        map.add(null, (Object)VALUES[3]);
        Assertions.assertTrue((map.keySet().size() == 1 ? 1 : 0) != 0, (String)("#keySet returns set of size " + map.keySet().size() + " for null key"));
        JAXRSClientIT.logMsg("#keySet returns correct values");
    }

    @Test
    public void putTest() throws JAXRSCommonClient.Fault {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[0]);
        list.add(VALUES[1]);
        list.add(VALUES[2]);
        HashMap hashMap = new HashMap();
        AbstractMultivaluedMap<String, Object> map = new AbstractMultivaluedMap<String, Object>(hashMap){};
        map.put((Object)KEY, list);
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.logMsg("#put() put the value");
    }

    @Test
    public void putAllTest() throws JAXRSCommonClient.Fault {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VALUES[0]);
        list.add(VALUES[1]);
        list.add(VALUES[2]);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put(KEY, list);
        hashMap.put("key2", list);
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"#clear did not emptied map");
        map.putAll(hashMap);
        JAXRSClientIT.assertContainsDefaultValues(map);
        JAXRSClientIT.assertContains(map, "key2", new Object[]{VALUES[0], VALUES[1], VALUES[2]});
        JAXRSClientIT.logMsg("#putAll() put all the values of both keys");
    }

    @Test
    public void putSingleTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.putSingle((Object)KEY, (Object)VALUES[4]);
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[4]});
        JAXRSClientIT.assertNotContains(map, KEY, VALUES[0], VALUES[1], VALUES[2]);
        JAXRSClientIT.logMsg("#putSingle() sucessfully replaced the values by a new one");
    }

    @Test
    public void putSingleNullValueTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.putSingle((Object)KEY, null);
        JAXRSClientIT.assertNotContains(map, KEY, new Object[]{null});
        JAXRSClientIT.logMsg("#putSingle(key, null) did replaced the values as expected");
    }

    @Test
    public void removeTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add((Object)"key2", (Object)VALUES[3]);
        List list = map.remove((Object)KEY);
        Assertions.assertTrue((list.size() == 3 ? 1 : 0) != 0, (String)("removed a list of size " + list.size()));
        JAXRSClientIT.assertNotContains(map, KEY, VALUES[0], VALUES[1], VALUES[2]);
        JAXRSClientIT.assertContains(map, "key2", new Object[]{VALUES[3]});
        JAXRSClientIT.logMsg("#removeTest(key) removed the correct key and the value as expected");
    }

    @Test
    public void sizeTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add((Object)"key2", (Object)VALUES[3]);
        Assertions.assertTrue((map.size() == 2 ? 1 : 0) != 0, (String)("returned unexpected size " + map.size()));
        map.clear();
        Assertions.assertTrue((map.size() == 0 ? 1 : 0) != 0, (String)("returned unexpected size after clear " + map.size()));
        JAXRSClientIT.logMsg("#size() returns correct values");
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        Assertions.assertTrue((map.toString() != null ? 1 : 0) != 0, (String)"#toString isNull");
        JAXRSClientIT.logMsg("#toString returned", map.toString());
    }

    @Test
    public void valuesTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        map.add((Object)"key2", (Object)VALUES[3]);
        Collection values = map.values();
        for (List list : values) {
            Assertions.assertTrue((list.size() == 1 || list.size() == 3 ? 1 : 0) != 0, (String)("Got unexpected values of size " + list.size()));
        }
        Assertions.assertTrue((values.size() == 2 ? 1 : 0) != 0, (String)("Unexpected #values of size " + values.size()));
        JAXRSClientIT.logMsg("#values returned", values.size(), "lists");
    }

    @Test
    public void equalsIgnoreValueOrderTest() throws JAXRSCommonClient.Fault {
        AbstractMultivaluedMap<String, Object> map = JAXRSClientIT.createMap();
        MultivaluedHashMap map2 = new MultivaluedHashMap();
        map2.addAll((Object)KEY, new Object[]{VALUES[2], VALUES[0], VALUES[1]});
        Assertions.assertTrue((boolean)map.equalsIgnoreValueOrder((MultivaluedMap)map2), (String)(map + " and " + map2 + " are not equalIgnoreValueOrder"));
        Assertions.assertFalse((boolean)map.equals((Object)map2), (String)(map + " and " + map2 + " are equal"));
        JAXRSClientIT.logMsg("#equalsIgnoreValueOrder compared maps", map, "and", map2, "as expected");
    }

    protected static AbstractMultivaluedMap<String, Object> createMap() {
        return JAXRSClientIT.createMap(KEY, VALUES[0], VALUES[1], VALUES[2]);
    }

    protected static AbstractMultivaluedMap<String, Object> createMap(String key, Object ... values) {
        HashMap hashMap = new HashMap();
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(values));
        hashMap.put(key, list);
        AbstractMultivaluedMap<String, Object> map = new AbstractMultivaluedMap<String, Object>(hashMap){};
        return map;
    }

    protected static void assertContainsDefaultValues(AbstractMultivaluedMap<String, Object> map) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertContains(map, KEY, new Object[]{VALUES[0], VALUES[1], VALUES[2]});
    }

    protected static void assertContains(AbstractMultivaluedMap<String, Object> map, String key, Object ... values) throws JAXRSCommonClient.Fault {
        List list = map.get((Object)key);
        for (Object item : values) {
            Assertions.assertTrue((boolean)list.contains(item), (String)("Given map does not contain value " + item));
        }
        JAXRSClientIT.logMsg("Found key", key, "with following values:");
        JAXRSClientIT.logMsg(values);
    }

    protected static void assertNotContains(AbstractMultivaluedMap<String, Object> map, String key, Object ... values) throws JAXRSCommonClient.Fault {
        List list = map.get((Object)key);
        if (list != null) {
            for (Object item : values) {
                Assertions.assertTrue((!list.contains(item) ? 1 : 0) != 0, (String)("Given map does contain value " + item));
            }
        }
        JAXRSClientIT.logMsg("Given key", key, "does not contain following values as expected:");
        JAXRSClientIT.logMsg(values);
    }
}

