/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.securitycontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.webclient.http.HttpResponse;
import jakarta.ws.rs.core.Response;
import org.apache.commons.httpclient.Header;
import org.junit.jupiter.api.Assertions;

public abstract class JAXRSClient
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    protected static final String URL = "Context";
    protected HttpResponse response;
    protected String wwwAuthenticate;
    protected String user;
    protected String password;
    protected String authuser;
    protected String authpassword;

    @Override
    public void setup() {
        this.user = System.getProperty("user");
        this.password = System.getProperty("password");
        this.authuser = System.getProperty("authuser");
        this.authpassword = System.getProperty("authpassword");
        Assertions.assertTrue((!this.isNullOrEmpty(this.user) ? 1 : 0) != 0, (String)"user was not set");
        Assertions.assertTrue((!this.isNullOrEmpty(this.password) ? 1 : 0) != 0, (String)"password was not set");
        Assertions.assertTrue((!this.isNullOrEmpty(this.authuser) ? 1 : 0) != 0, (String)"authuser was not set");
        Assertions.assertTrue((!this.isNullOrEmpty(this.authpassword) ? 1 : 0) != 0, (String)"authpassword was not set");
        super.setup();
    }

    public void noAuthorizationTest() throws JAXRSCommonClient.Fault {
        this.setProperty("STATUS_CODE", JAXRSClient.getStatusCode(Response.Status.UNAUTHORIZED));
        this.invokeRequest();
        Assertions.assertTrue((this.wwwAuthenticate != null ? 1 : 0) != 0, (String)"Expected authentication request missing!");
    }

    protected void invokeRequest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET", URL));
        this.invoke();
        this.response = this._testCase.getResponse();
        Header header = this.response.getResponseHeader("WWW-Authenticate");
        this.wwwAuthenticate = header == null ? null : header.getValue();
    }
}

