/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.servlet3.rs.core.streamingoutput;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.servlet3.rs.core.streamingoutput.StreamOutputTest;
import ee.jakarta.tck.ws.rs.servlet3.rs.core.streamingoutput.TSAppConfig;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    public static final String _root = "/jaxrs_ee_core_streamoutput/StreamOutputTest";

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot(_root);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/servlet3/rs/core/streamingoutput/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_streamoutput.war");
        archive.addClasses(new Class[]{TSAppConfig.class, StreamOutputTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void writeTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "Test1"));
        this.setProperty("SEARCH_STRING", "StreamingOutputTest1");
        this.invoke();
    }

    @Test
    public void writeIOExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "IOExceptionTest"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.INTERNAL_SERVER_ERROR));
        this.invoke();
    }

    @Test
    public void writeWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "Test2"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.NOT_FOUND));
        this.invoke();
    }
}

