/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.namebinding;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.AbstractAddInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.AddOneInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.AddTenInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.AllMethodBindingResource;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.ComplementNameBinding;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.Resource;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.SingleNameBinding;
import ee.jakarta.tck.ws.rs.spec.filter.namebinding.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_filter_namebinding_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/filter/namebinding/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_filter_namebinding_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractAddInterceptor.class, AddOneInterceptor.class, AddTenInterceptor.class, AllMethodBindingResource.class, ComplementNameBinding.class, SingleNameBinding.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void noInterceptorBoundTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "one"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "1");
        this.invoke();
        JAXRSClientIT.logMsg("No interceptor has been bound as expected");
    }

    @Test
    public void singleInterceptorBoundTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "ten"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "11");
        this.invoke();
        JAXRSClientIT.logMsg("Interceptor has been bound as expected");
    }

    @Test
    public void onlyPartOfUnionOfInterceptorsBoundTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "complement"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "10000");
        this.invoke();
        JAXRSClientIT.logMsg("No interceptor has been bound as expected");
    }

    @Test
    public void readerWriterInterceptorBoundTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.setRequestContentEntity("1111");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "1113");
        this.invoke();
        JAXRSClientIT.logMsg("Reader and Writer interceptor has been bound as expected");
    }

    @Test
    public void resourceAnnotatedFirstMethodInterceptedTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "all/hundred"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "101");
        this.invoke();
        JAXRSClientIT.logMsg("Both name bound interceptors has been bound as expected");
    }

    @Test
    public void resourceAnnotatedSecondMethodInterceptedTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "all/thousand"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "1011");
        this.invoke();
        JAXRSClientIT.logMsg("Both name bound interceptors has been bound as expected");
    }
}

