/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.reader;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.reader.AbstractReader;
import ee.jakarta.tck.ws.rs.spec.provider.reader.AppJavaReader;
import ee.jakarta.tck.ws.rs.spec.provider.reader.AppOctetReader;
import ee.jakarta.tck.ws.rs.spec.provider.reader.EntityForReader;
import ee.jakarta.tck.ws.rs.spec.provider.reader.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.reader.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.provider.reader.WildCardReader;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_reader_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/reader/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_reader_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractReader.class, AppJavaReader.class, AppOctetReader.class, EntityForReader.class, WildCardReader.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void noEntityProviderTest() throws JAXRSCommonClient.Fault {
        this.enableAppJava(false);
        String ct = JAXRSClientIT.buildContentType(AbstractReader.NO_PROVIDER_MEDIATYPE);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "meadiaTypeContentTypeTest");
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE));
        this.invoke();
    }

    @Test
    public void meadiaTypeContentTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_HTML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "meadiaTypeContentTypeTest");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "meadiaTypeContentTypeTest");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/html");
        this.invoke();
    }

    @Test
    public void meadiaTypeDefaultTest() throws JAXRSCommonClient.Fault {
        this.enableAppJava(false);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "meadiaTypeDefaultTest");
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppOctetReader.class.getSimpleName().toUpperCase());
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "meadiaTypeDefaultTest");
        this.invoke();
    }

    @Test
    public void iterateAllAppJavaReadersTest() throws JAXRSCommonClient.Fault {
        this.enableAppJava(false);
        MediaType mt = new MediaType("application", "java");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "some content");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppJavaReader.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, WildCardReader.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, WildCardReader.class.getSimpleName().toUpperCase());
        this.invoke();
    }

    @Test
    public void iterateFirstAppJavaReaderTest() throws JAXRSCommonClient.Fault {
        this.enableAppJava(true);
        MediaType mt = new MediaType("application", "java");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "plain"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "some content");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(mt));
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppJavaReader.class.getSimpleName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, AppJavaReader.class.getSimpleName().toUpperCase());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, mt.toString());
        this.invoke();
    }

    private void enableAppJava(boolean enable) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "appjava"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, String.valueOf(enable));
        this.invoke();
    }
}

