/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.provider;

import com.sun.ts.tests.jacc.provider.TSLogger;
import com.sun.ts.tests.jacc.provider.TSPolicyConfigurationFactoryImpl;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public class TSPolicyConfigurationImpl
implements PolicyConfiguration {
    private PolicyConfiguration policyConfiguration = null;
    private PolicyConfigurationFactory pcf = null;
    private static TSLogger logger = null;
    private String applicationContext = null;
    private String appTime = null;
    private Vector applicationLinkTable = new Vector();

    public TSPolicyConfigurationImpl(String contextId, boolean remove, TSLogger lgr) throws PolicyContextException {
        Date date = new Date();
        this.appTime = "" + date.getTime();
        logger = lgr;
        this.applicationContext = contextId;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "TSPolicyConfigurationImpl");
        }
        this.pcf = TSPolicyConfigurationFactoryImpl.getPolicyConfigurationFactory();
        this.policyConfiguration = this.pcf.getPolicyConfiguration(contextId, remove);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "appId :: " + TSPolicyConfigurationImpl.stuffData(this.applicationContext) + " , " + this.appTime);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "TSPolicyConfigurationImpl");
        }
    }

    public String getContextID() throws PolicyContextException {
        boolean bWasInservice = this.policyConfiguration.inService();
        String contextId = this.policyConfiguration.getContextID();
        if (bWasInservice) {
            this.assertIsInserviceState("getContextID");
        } else {
            this.assertStateNotInservice("getContextID");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "contextId =" + contextId);
        }
        return contextId;
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        String permissionType = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToRole");
        }
        if (roleName == null || permissions == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToRole(roleName, permissions);
        this.assertStateNotInservice("addToRole");
        if (logger.isLoggable(Level.INFO)) {
            StringBuffer sbuf = new StringBuffer("");
            int bufLength = 0;
            Enumeration<Permission> en = permissions.elements();
            while (en.hasMoreElements()) {
                sbuf.append("addToRole :: ");
                sbuf.append(this.applicationContext + " , ");
                sbuf.append(this.appTime + " , ");
                Permission p = en.nextElement();
                permissionType = this.getPermissionType(p);
                sbuf.append(permissionType + " , ");
                sbuf.append(p.getName() + " , ");
                sbuf.append(p.getActions());
                logger.log(Level.INFO, sbuf.toString());
                bufLength = sbuf.length();
                sbuf.delete(0, bufLength);
                if (!permissionType.equals("WebResourcePermission") && !permissionType.equals("WebRoleRefPermission") && !permissionType.equals("EJBMethodPermission") && !permissionType.equals("EJBRoleRefPermission")) continue;
                logger.log(Level.INFO, "MSG_TAG :: " + permissionType + " :: " + roleName + " :: " + this.applicationContext + " :: " + p.getName());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToRole");
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        String permissionType = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToRole");
        }
        if (roleName == null || permission == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToRole(roleName, permission);
        this.assertStateNotInservice("addToRole");
        permissionType = this.getPermissionType(permission);
        if (logger.isLoggable(Level.INFO)) {
            String sbuf = new String("addToRole :: " + this.applicationContext + " , " + this.appTime + " , " + permissionType + " , " + permission.getName() + " , " + permission.getActions());
            logger.log(Level.INFO, sbuf);
        }
        if (permissionType.equals("WebResourcePermission") || permissionType.equals("WebRoleRefPermission") || permissionType.equals("EJBMethodPermission") || permissionType.equals("EJBRoleRefPermission")) {
            logger.log(Level.INFO, "MSG_TAG :: " + permissionType + " :: " + roleName + " :: " + this.applicationContext + " :: " + permission.getName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToRole");
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        String permissionType = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToUncheckedPolicy");
        }
        if (permissions == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToUncheckedPolicy(permissions);
        this.assertStateNotInservice("addToUncheckedPolicy");
        if (logger.isLoggable(Level.INFO)) {
            StringBuffer sbuf = new StringBuffer("");
            int bufLength = 0;
            Enumeration<Permission> en = permissions.elements();
            while (en.hasMoreElements()) {
                sbuf.append("unchecked :: ");
                sbuf.append(this.applicationContext + " , ");
                sbuf.append(this.appTime + " , ");
                Permission p = en.nextElement();
                permissionType = this.getPermissionType(p);
                sbuf.append(permissionType + " , ");
                sbuf.append(p.getName() + " , ");
                sbuf.append(p.getActions());
                logger.log(Level.INFO, sbuf.toString());
                bufLength = sbuf.length();
                sbuf.delete(0, bufLength);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToUncheckedPolicy");
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToUncheckedPolicy");
        }
        if (permission == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToUncheckedPolicy(permission);
        this.assertStateNotInservice("addToUncheckedPolicy");
        String permissionType = this.getPermissionType(permission);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "unchecked :: " + this.applicationContext + " , " + this.appTime + " , " + permissionType + " , " + permission.getName() + " , " + permission.getActions());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToUncheckedPolicy");
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        String permissionType = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToExcludedPolicy");
        }
        if (permissions == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToExcludedPolicy(permissions);
        this.assertStateNotInservice("addToExcludedPolicy");
        if (logger.isLoggable(Level.INFO)) {
            StringBuffer sbuf = new StringBuffer("");
            int bufLength = 0;
            Enumeration<Permission> en = permissions.elements();
            while (en.hasMoreElements()) {
                sbuf.append("excluded :: ");
                sbuf.append(this.applicationContext + " , ");
                sbuf.append(this.appTime + " , ");
                Permission p = en.nextElement();
                permissionType = this.getPermissionType(p);
                sbuf.append(permissionType + " , ");
                sbuf.append(p.getName() + " , ");
                sbuf.append(p.getActions());
                logger.log(Level.INFO, sbuf.toString());
                bufLength = sbuf.length();
                sbuf.delete(0, bufLength);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToExcludedPolicy");
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        String permissionType = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "addToExcludedPolicy");
        }
        if (permission == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.addToExcludedPolicy(permission);
        this.assertStateNotInservice("addToExcludedPolicy");
        permissionType = this.getPermissionType(permission);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "excluded :: " + this.applicationContext + " , " + this.appTime + " , " + permissionType + " , " + permission.getName() + " , " + permission.getActions());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "addToExcludedPolicy");
        }
    }

    public void removeRole(String roleName) throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "removeRole");
        }
        if (roleName == null) {
            return;
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.removeRole(roleName);
        this.assertStateNotInservice("removeRole");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Removed Role :: " + roleName);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "removeRole");
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "removeUncheckedPolicy");
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.removeUncheckedPolicy();
        this.assertStateNotInservice("removeUncheckedPolicy");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Removed all unchecked policy statements");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "removeUncheckedPolicy");
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "removeExcludedPolicy");
        }
        this.policyConfiguration = this.pcf.getPolicyConfiguration(this.applicationContext, false);
        this.policyConfiguration.removeExcludedPolicy();
        this.assertStateNotInservice("removeExcludedPolicy");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Removed all excluded policy statements");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "removeExcludedPolicy");
        }
    }

    public void commit() throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "commit");
        }
        boolean bWasInservice = this.policyConfiguration.inService();
        this.policyConfiguration.commit();
        this.assertIsInserviceState("commit");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "PolicyConfiguration.commit() called");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "commit");
        }
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        String contextId = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "linkConfiguration");
        }
        if (link != null) {
            contextId = link.getContextID();
            if (this.applicationLinkTable != null) {
                if (!this.applicationLinkTable.contains(contextId)) {
                    this.applicationLinkTable.add(contextId);
                }
                if (!this.applicationLinkTable.contains(this.applicationContext)) {
                    this.applicationLinkTable.add(this.applicationContext);
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                StringBuffer sbuf = new StringBuffer("");
                boolean bufLength = false;
                sbuf.append("link :: ");
                Enumeration appEnum = this.applicationLinkTable.elements();
                while (appEnum.hasMoreElements()) {
                    String stuffedAppName = TSPolicyConfigurationImpl.stuffData((String)appEnum.nextElement());
                    sbuf.append(stuffedAppName);
                    if (!appEnum.hasMoreElements()) continue;
                    sbuf.append(",");
                }
                sbuf.append(" : ");
                sbuf.append(this.appTime);
                logger.log(Level.INFO, sbuf.toString());
            }
        }
        String vendorContextId = link.getContextID();
        PolicyConfiguration vendorPC = this.pcf.getPolicyConfiguration(vendorContextId, false);
        boolean bWasInservice = this.policyConfiguration.inService();
        this.policyConfiguration.linkConfiguration(vendorPC);
        this.assertStateNotInservice("linkConfiguration");
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "linkConfiguration");
        }
    }

    public void delete() throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "delete");
        }
        this.policyConfiguration.delete();
        this.assertStateNotInservice("delete");
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Deleted all policy statements");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "delete");
        }
    }

    public boolean inService() throws PolicyContextException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering("TSPolicyConfigurationImpl", "inService");
        }
        boolean bWasInservice = this.policyConfiguration.inService();
        boolean ret = this.policyConfiguration.inService();
        if (bWasInservice) {
            this.assertIsInserviceState("inService");
        } else {
            this.assertStateNotInservice("inService");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "PolicyConfiguration.inService() called");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting("TSPolicyConfigurationImpl", "inService");
        }
        return ret;
    }

    public String getPermissionType(Permission permission) {
        if (permission instanceof WebResourcePermission) {
            return "WebResourcePermission";
        }
        if (permission instanceof WebUserDataPermission) {
            return "WebUserDataPermission";
        }
        if (permission instanceof WebRoleRefPermission) {
            return "WebRoleRefPermission";
        }
        if (permission instanceof EJBMethodPermission) {
            return "EJBMethodPermission";
        }
        if (permission instanceof EJBRoleRefPermission) {
            return "EJBRoleRefPermission";
        }
        return null;
    }

    public static String stuffData(String inputStr) {
        char[] outStr = new char[2048];
        char[] str = inputStr.toCharArray();
        int j = 0;
        for (int i = 0; i < str.length; ++i) {
            new Character(str[i]);
            int a = Character.getNumericValue(str[i]);
            if (a > 9 && a < 36) {
                outStr[j++] = str[i];
                continue;
            }
            outStr[j++] = str[i];
            outStr[j++] = str[i];
        }
        return new String(outStr).trim();
    }

    public PermissionCollection getExcludedPermissions() {
        return this.policyConfiguration.getExcludedPermissions();
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.policyConfiguration.getUncheckedPermissions();
    }

    public Map<String, PermissionCollection> getPerRolePermissions() {
        return this.policyConfiguration.getPerRolePermissions();
    }

    private void assertIsInserviceState(String callingMethod) {
        try {
            if (!this.policyConfiguration.inService()) {
                String msg1 = "ERROR - our policy config should be in the INSERVICE state.";
                String msg2 = "In the wrong state after having called:  " + callingMethod;
                this.debugOut(msg1);
                this.debugOut(msg2);
                logger.log(Level.SEVERE, msg1);
            }
        }
        catch (SecurityException ex) {
            Object err = "ERROR - got securityException calling policyConfiguration.inService().";
            err = (String)err + "  You likely need to have 'setPolicy' grant set";
            this.debugOut((String)err);
            this.debugOut(ex.toString());
        }
        catch (Exception ex) {
            this.debugOut("ERROR - Exception calling policyConfiguration.inService():  " + ex.toString());
            ex.printStackTrace();
        }
    }

    private void assertStateNotInservice(String callingMethod) {
        try {
            if (this.policyConfiguration.inService()) {
                String msg1 = "ERROR - our policy config should not be in the INSERVICE state.";
                String msg2 = "In the wrong state after having called:  " + callingMethod;
                this.debugOut(msg1);
                this.debugOut(msg2);
                logger.log(Level.SEVERE, msg1);
            }
        }
        catch (SecurityException ex) {
            Object err = "ERROR - got securityException calling policyConfiguration.inService().";
            err = (String)err + "  You likely need to have 'setPolicy' grant set";
            this.debugOut((String)err);
            this.debugOut(ex.toString());
        }
        catch (Exception ex) {
            this.debugOut("ERROR - Exception calling policyConfiguration.inService():  " + ex.toString());
            ex.printStackTrace();
        }
    }

    private void debugOut(String str) {
        System.out.println(str);
    }
}

