/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.selectiontree.SelectionTree;
import com.sun.interview.wizard.selectiontree.selection.SelectionElement;
import com.sun.interview.wizard.selectiontree.selection.SelectionType;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class TreeQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        TreeQuestion tq = (TreeQuestion)qq;
        SelectNode rootNode = new SelectNode(tq.getModel(), tq.getModel().getRoot());
        SelectionTree tree = new SelectionTree(rootNode, null, true);
        tree.setName("tree");
        tree.setToolTipText(i18n.getString("tree.tip"));
        tree.getAccessibleContext().setAccessibleName(tree.getName());
        tree.getAccessibleContext().setAccessibleDescription(tree.getToolTipText());
        JScrollPane sp = new JScrollPane(tree);
        tree.setSelection(tq.getValue());
        Runnable valueSaver = () -> tq.setValue(tree.getSelection());
        sp.putClientProperty("valueSaver", valueSaver);
        return sp;
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected static class SelectNode
    implements SelectionElement {
        private SelectionType type = SelectionType.UNSELECTED;
        private Object object;
        private LinkedList<SelectionElement> children;
        private TreeQuestion.Model model;
        private String name;

        public SelectNode(TreeQuestion.Model model, Object object) {
            this.model = model;
            this.object = object;
        }

        @Override
        public SelectionType getSelectionType() {
            return this.type;
        }

        @Override
        public void setSelectionType(SelectionType selectionType) {
            if (!this.type.equals((Object)selectionType)) {
                this.type = selectionType;
            }
        }

        @Override
        public String getDisplayableName() {
            return this.getName();
        }

        @Override
        public String getToolTip() {
            return null;
        }

        @Override
        public boolean isToolTipAlwaysShown() {
            return false;
        }

        @Override
        public List<SelectionElement> getChildren() {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children;
        }

        private void initChildren() {
            int childCount = this.model.getChildCount(this.object);
            this.children = new LinkedList();
            for (int i = 0; i < childCount; ++i) {
                SelectNode newChild = new SelectNode(this.model, this.model.getChild(this.object, i));
                this.children.add(newChild);
                if (!this.type.equals((Object)SelectionType.SELECTED)) continue;
                newChild.setSelectionType(SelectionType.SELECTED);
            }
            this.model.getChild(this.object, 0);
        }

        private String getName() {
            if (this.name == null) {
                this.name = this.model.getName(this.object);
            }
            return this.name;
        }
    }
}

