/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.JavaTestToolBar;
import com.sun.javatest.exec.ToolBarPanel;
import com.sun.javatest.tool.UIFactory;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class ToolBarManager {
    private UIFactory uif;
    private JMenu toolBarMenu;
    private TBMenuManager mmanager = new TBMenuManager();
    private Map<String, JavaTestToolBar> store = Collections.synchronizedMap(new LinkedHashMap());
    private ToolBarPanel panel;

    public boolean addToolBar(JavaTestToolBar theBar, String toolBarID) {
        if (!this.store.containsKey(toolBarID)) {
            this.store.put(toolBarID, theBar);
            if (this.panel != null) {
                SwingUtilities.invokeLater(() -> {
                    this.panel.add(theBar);
                    this.mmanager.addToolbar(theBar);
                });
            }
            return true;
        }
        return false;
    }

    public JavaTestToolBar getToolBar(String toolBarID) {
        return this.store.get(toolBarID);
    }

    public JavaTestToolBar[] getToolBars() {
        JavaTestToolBar[] ret = new JavaTestToolBar[]{};
        ret = this.store.values().toArray(ret);
        return ret;
    }

    boolean removeToolBar(String toolBarID) {
        if (this.store.containsKey(toolBarID)) {
            JavaTestToolBar tb = this.store.get(toolBarID);
            if (this.panel != null) {
                SwingUtilities.invokeLater(() -> {
                    this.panel.remove(tb);
                    this.mmanager.removeToolbar(tb);
                });
            } else {
                this.mmanager.removeToolbar(tb);
            }
            this.store.remove(toolBarID);
            return true;
        }
        return false;
    }

    JMenu getToolbarMenu() {
        if (this.toolBarMenu == null) {
            this.toolBarMenu = this.uif.createMenu("tbmanager.viewmenu");
            this.toolBarMenu.setVisible(false);
        }
        return this.toolBarMenu;
    }

    void save(Map<String, Object> m) {
        if (m != null) {
            for (JavaTestToolBar tb : this.store.values()) {
                tb.save(m);
            }
        }
    }

    void load(Map<String, Object> m) {
        if (m != null) {
            for (JavaTestToolBar tb : this.store.values()) {
                tb.load(m);
            }
        }
    }

    void setUIFactory(UIFactory u) {
        this.uif = u;
    }

    void setPanel(ToolBarPanel p) {
        if (p == null) {
            throw new NullPointerException();
        }
        this.panel = p;
        if (!this.store.isEmpty()) {
            JavaTestToolBar[] tbs;
            for (JavaTestToolBar tb : tbs = this.getToolBars()) {
                this.panel.add(tb);
                this.mmanager.addToolbar(tb);
            }
        }
    }

    void setVisibleFromPrefs(boolean visible) {
        int count = this.toolBarMenu.getItemCount();
        for (int i = 0; i < count; ++i) {
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)this.toolBarMenu.getItem(i);
            if (mi == null) continue;
            ToolbarMenuAction a = (ToolbarMenuAction)mi.getAction();
            JavaTestToolBar bar = a.getBar();
            if (!visible) {
                bar.setVisibleNoStateAffect(visible);
            } else {
                bar.setVisibleNoStateAffect(bar.readVisibleState());
            }
            mi.setState(bar.isVisible());
        }
    }

    class TBMenuManager {
        TBMenuManager() {
        }

        public void addToolbar(JavaTestToolBar t) {
            if (t.isMenuControlled()) {
                JMenu m = ToolBarManager.this.getToolbarMenu();
                ToolbarMenuAction ac = new ToolbarMenuAction(t);
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(ac);
                mi.setState(t.isVisible());
                ((Container)m).add(mi);
                ToolBarManager.this.toolBarMenu.setVisible(true);
            }
        }

        public void removeToolbar(JavaTestToolBar t) {
            if (t.isMenuControlled()) {
                JMenu m = ToolBarManager.this.getToolbarMenu();
                for (int i = 0; i < m.getItemCount(); ++i) {
                    JMenuItem it = m.getItem(i);
                    Action act = it.getAction();
                    if (!(act instanceof ToolbarMenuAction) || ((ToolbarMenuAction)act).getBar() != t) continue;
                    m.remove(i);
                    break;
                }
                if (m.getItemCount() == 0) {
                    m.setVisible(false);
                }
            }
        }
    }

    static class ToolbarMenuAction
    extends AbstractAction {
        private JavaTestToolBar theBar;

        public ToolbarMenuAction(JavaTestToolBar bar) {
            super(bar.getName());
            this.theBar = bar;
        }

        public JavaTestToolBar getBar() {
            return this.theBar;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.theBar.setVisible(!this.theBar.isVisible());
        }
    }
}

