/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends JFileChooser {
    private static File userDir = new File(System.getProperty("user.dir"));
    private boolean showAllFilesFilter;
    private boolean enableDirs = true;

    public FileChooser() {
        this(true);
    }

    public FileChooser(boolean showAllFilesFilter) {
        this.showAllFilesFilter = showAllFilesFilter;
        this.setCurrentDirectory(userDir);
        if (showAllFilesFilter) {
            this.setAcceptAllFileFilterUsed(true);
        } else {
            this.setAcceptAllFileFilterUsed(false);
        }
    }

    public void addChoosableExtension(String extn, String desc) {
        ExtensionFileFilter f = new ExtensionFileFilter(extn, desc);
        this.addChoosableFileFilter(f);
        this.setFileFilter(f);
        if (!this.showAllFilesFilter && this.isAcceptAllFileFilterUsed()) {
            this.setAcceptAllFileFilterUsed(false);
        }
    }

    public String getChosenExtension() {
        FileFilter f = this.getFileFilter();
        if (f instanceof ExtensionFileFilter) {
            return ((ExtensionFileFilter)f).getExtension();
        }
        return null;
    }

    public void enableDirectories(boolean enableDirs) {
        this.enableDirs = enableDirs;
    }

    private class ExtensionFileFilter
    extends FileFilter {
        private String extn;
        private String desc;

        ExtensionFileFilter(String extn, String desc) {
            this.extn = extn;
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            return FileChooser.this.enableDirs && f.isDirectory() || f.getName().endsWith(this.extn);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String getExtension() {
            return this.extn;
        }
    }
}

