/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.webtarget;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 5527613586671403135L;
    private static final String ENCODED = "%42%5A%61%7a%2F%%21";
    private static final String SLASHED = "%42%5A%61%7a/%%21";
    protected static final String URL = "http://cts.tck:888/resource";
    protected static final ClientRequestFilter FILTER = JAXRSClientIT.createRequestFilter();

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getUriTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        URI uri = target.getUri();
        JAXRSClientIT.assertContains(uri.toASCIIString(), URL);
        JAXRSClientIT.logMsg("URI", uri, "contains", URL);
    }

    @Test
    public void getUriBuilderTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        URI uri = target.getUriBuilder().build(new Object[0]);
        JAXRSClientIT.assertContains(uri.toASCIIString(), URL);
        JAXRSClientIT.logMsg("URI", uri, "contains", URL);
    }

    @Test
    public void getUriBuilderIsDetachedTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URL);
        UriBuilder builder = target.getUriBuilder();
        client.close();
        URI uri = builder.build(new Object[0]);
        JAXRSClientIT.assertContains(uri.toASCIIString(), URL);
        JAXRSClientIT.logMsg("URI", uri, "contains", URL);
    }

    @Test
    public void matrixParamTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.matrixParam("matrix", new Object[]{"arg1", "arg2", "arg3"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertContains(uri.toASCIIString(), ";matrix=arg1");
        JAXRSClientIT.assertContains(uri.toASCIIString(), ";matrix=arg2");
        JAXRSClientIT.assertContains(uri.toASCIIString(), ";matrix=arg3");
        JAXRSClientIT.logMsg("URI", uri, "contains given matrix params");
    }

    @Test
    public void matrixParamOnTwoSegmentsTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.matrixParam("matrix1", new Object[]{"segment1"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.path("path");
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.matrixParam("matrix2", new Object[]{"segment2"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, ";matrix1=segment1/path;matrix2=segment2");
        JAXRSClientIT.logMsg("URI", uri, "contains given matrix params");
    }

    @Test
    public void matrixParamWithNullValueRemovesParamsWithTheNameOnMoreSegmentsTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.matrixParam("matrix1", new Object[]{"segment1"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.path("path1");
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.matrixParam("matrix2", new Object[]{"segment1"});
        target = target.matrixParam("matrix2", new Object[]{null});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.path("path2");
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.matrixParam("matrix1", new Object[]{"segment1"});
        target = target.matrixParam("matrix1", new Object[]{null});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.path("path3");
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, ";matrix1=segment1/path1/path2/path3");
        JAXRSClientIT.logMsg("URI", uri, "contains given matrix params");
    }

    @Test
    public void matrixParamThrowsNPEOnNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.matrixParam(null, new Object[]{"segment1"});
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void matrixParamThrowsNPEOnFirstArgIsNullTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.matrixParam("matrix", new Object[]{null, "segment1"});
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void matrixParamThrowsNPEOnSecondArgIsNullTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.matrixParam("matrix", new Object[]{"segment1", null});
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void pathTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("a/").path("/b/").path("/c/").path("d").path("e");
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/a/b/c/d/e");
        JAXRSClientIT.logMsg("URI", uri, "contains given path");
    }

    @Test
    public void pathThrowsNPEOnNullTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path(null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void queryParamTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.queryParam("paramName", new Object[]{new StringBuffer().append("value1"), new StringBuilder().append("value2"), "value3"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "?paramName=value1&paramName=value2&paramName=value3");
        JAXRSClientIT.logMsg("URI", uri, "contains given query parameter");
    }

    @Test
    public void queryParamNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("path").queryParam("paramName", new Object[]{new StringBuffer().append("value1"), new StringBuilder().append("value2"), "value3"});
        JAXRSClientIT.assertConfigurationSnapshot(target);
        target = target.queryParam("param", (Object[])null).path("path2");
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/path/path2");
        JAXRSClientIT.logMsg("#paramName(name, null) removed values as expected");
    }

    @Test
    public void queryParamThrowsNPEOnNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.queryParam(null, new Object[]{"lane"});
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void queryParamThrowsNPEOnNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.queryParam("param", new Object[]{null, ""});
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void requestNoArgTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        Response response = target.request().buildGet().invoke();
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, URL);
        JAXRSClientIT.assertContains(body, "*/*");
    }

    @Test
    public void requestStringTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        Response response = target.request(new String[]{"application/atom+xml", "application/json", "text/xml"}).buildGet().invoke();
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, URL);
        JAXRSClientIT.assertContains(body, "application/atom+xml");
        JAXRSClientIT.assertContains(body, "application/json");
        JAXRSClientIT.assertContains(body, "text/xml");
    }

    @Test
    public void requestMediaTypeTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_ATOM_XML_TYPE, MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_XML_TYPE}).buildGet().invoke();
        String body = (String)response.readEntity(String.class);
        JAXRSClientIT.assertContains(body, URL);
        JAXRSClientIT.assertContains(body, "application/atom+xml");
        JAXRSClientIT.assertContains(body, "application/json");
        JAXRSClientIT.assertContains(body, "text/xml");
    }

    @Test
    public void resolveTemplateTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").resolveTemplate("path", (Object)"lane");
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/lane");
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameter");
    }

    @Test
    public void resolveTemplateThrowsNPEOnNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate(null, (Object)"lane");
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateThrowsNPEOnNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate("path", null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateWithBooleanFalseTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").resolveTemplate("path", (Object)ENCODED, false);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/" + ENCODED.replace("%", "%25"));
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameter");
    }

    @Test
    public void resolveTemplateWithBooleanTrueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").resolveTemplate("path", (Object)SLASHED, true);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/" + SLASHED.replace("%", "%25").replace("/", "%2F"));
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameter");
    }

    @Test
    public void resolveTemplateWithBooleanTrueThrowsNPEOnNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate(null, (Object)"lane", true);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateWithBooleanTrueThrowsNPEOnNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate("path", null, true);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateWithBooleanFalseThrowsNPEOnNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate(null, (Object)"lane", false);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateWithBooleanFalseThrowsNPEOnNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplate("path", null, false);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateFromEncodedTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        StringBuilder sb = new StringBuilder();
        sb.append(ENCODED);
        target = target.path("{path}").resolveTemplateFromEncoded("path", (Object)sb);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/" + ENCODED.replace("%%", "%25%"));
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameter");
    }

    @Test
    public void resolveTemplateFromEncodedThrowsNPEForNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplateFromEncoded(null, (Object)"xyz");
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplateFromEncodedThrowsNPEForNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplateFromEncoded("path", null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesTest() throws JAXRSCommonClient.Fault {
        TreeMap<String, CharSequence> map = new TreeMap<String, CharSequence>();
        map.put("path", new StringBuilder().append("lane"));
        map.put("highway", new StringBuffer().append("route66"));
        map.put("sidewalk", "pavement");
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").path("{highway}").path("{sidewalk}");
        target = target.resolveTemplates(map);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/lane/route66/pavement");
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameters");
    }

    @Test
    public void resolveTemplatesReturnsTheSameTargetTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}");
        WebTarget other = target.resolveTemplates(new TreeMap());
        JAXRSClientIT.assertEquals(target, other, "#pathParams did not return the same target when the input map is empty");
        JAXRSClientIT.logMsg("#pathParams returned the same traget wehn empty as expected");
    }

    @Test
    public void resolveTemplatesNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", null);
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates(map);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesNullNameTest() throws JAXRSCommonClient.Fault {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "xyz");
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates(map);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesNullMapTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates((Map)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesWithBooleanTrueTest() throws JAXRSCommonClient.Fault {
        TreeMap<String, CharSequence> map = new TreeMap<String, CharSequence>();
        map.put("path", new StringBuilder().append("lane"));
        map.put("highway", new StringBuffer().append("route66"));
        map.put("sidewalk", SLASHED);
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").path("{highway}").path("{sidewalk}");
        target = target.resolveTemplates(map, true);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/lane/route66/" + SLASHED.replace("%", "%25").replace("/", "%2F"));
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameters");
    }

    @Test
    public void resolveTemplatesWithBooleanFalseTest() throws JAXRSCommonClient.Fault {
        TreeMap<String, CharSequence> map = new TreeMap<String, CharSequence>();
        map.put("path", new StringBuilder().append("lane"));
        map.put("highway", new StringBuffer().append("route66"));
        map.put("sidewalk", "pavement");
        WebTarget target = this.createWebTarget();
        target = target.path("{path}").path("{highway}").path("{sidewalk}");
        target = target.resolveTemplates(map, false);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/lane/route66/pavement");
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameters");
    }

    @Test
    public void resolveTemplatesWithBooleanTrueReturnsTheSameTargetTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}");
        WebTarget other = target.resolveTemplates(new TreeMap(), true);
        JAXRSClientIT.assertEquals(target, other, "#pathParams did not return the same target when the input map is empty");
        JAXRSClientIT.logMsg("#pathParams returned the same traget wehn empty as expected");
    }

    @Test
    public void resolveTemplatesWithBooleanFalseReturnsTheSameTargetTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}");
        WebTarget other = target.resolveTemplates(new TreeMap(), false);
        JAXRSClientIT.assertEquals(target, other, "#pathParams did not return the same target when the input map is empty");
        JAXRSClientIT.logMsg("#pathParams returned the same traget wehn empty as expected");
    }

    @Test
    public void resolveTemplatesWithBooleanNullValueTest() throws JAXRSCommonClient.Fault {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", null);
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates(map, true);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesWithBooleanNullNameTest() throws JAXRSCommonClient.Fault {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "xyz");
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates(map, false);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesWithBooleanNullMapTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplates((Map)null, false);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesFromEncodedTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        StringBuilder sb = new StringBuilder();
        sb.append(ENCODED);
        HashMap<String, StringBuilder> map = new HashMap<String, StringBuilder>();
        map.put("path", sb);
        target = target.path("{path}").resolveTemplatesFromEncoded(map);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        URI uri = target.getUri();
        JAXRSClientIT.assertUriContains(uri, "/" + ENCODED.replace("%%", "%25%"));
        JAXRSClientIT.logMsg("URI", uri, "contains given path parameter");
    }

    @Test
    public void resolveTemplatesFromEncodedReturnsTheSameTargetTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        target = target.path("{path}");
        WebTarget other = target.resolveTemplatesFromEncoded(new TreeMap());
        JAXRSClientIT.assertEquals(target, other, "#pathParams did not return the same target when the input map is empty");
        JAXRSClientIT.logMsg("#pathParams returned the same traget wehn empty as expected");
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNPEForNullNameTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(null, "xyz");
        try {
            target.path("{path}").resolveTemplatesFromEncoded(map);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNPEForNullValueTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", null);
        try {
            target.path("{path}").resolveTemplatesFromEncoded(map);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    @Test
    public void resolveTemplatesFromEncodedThrowsNPEForNullMapTest() throws JAXRSCommonClient.Fault {
        WebTarget target = this.createWebTarget();
        try {
            target.path("{path}").resolveTemplatesFromEncoded((Map)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected", npe);
            return;
        }
    }

    protected static ClientRequestFilter createRequestFilter() {
        ClientRequestFilter filter = new ClientRequestFilter(){

            public void filter(ClientRequestContext ctx) throws IOException {
                StringBuilder sb = new StringBuilder();
                sb.append(ctx.getMethod()).append(";");
                sb.append(ctx.getUri().toASCIIString()).append(";");
                if (ctx.hasEntity()) {
                    sb.append(ctx.getEntity()).append(";");
                }
                List list = ctx.getAcceptableMediaTypes();
                for (MediaType type : list) {
                    sb.append(type).append(";");
                }
                Response r = Response.ok((Object)sb.toString()).build();
                ctx.abortWith(r);
            }
        };
        return filter;
    }

    protected WebTarget createWebTarget() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        client.register((Object)FILTER);
        WebTarget target = client.target(URL);
        JAXRSClientIT.assertConfigurationSnapshot(target);
        return target;
    }

    protected static void assertContains(String string, String substring) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)string.toLowerCase().contains(substring.toLowerCase()), (String)(string + " does not contain expected " + substring));
        JAXRSClientIT.logMsg("Found expected", substring);
    }

    protected static void assertUriContains(URI uri, String suffix) throws JAXRSCommonClient.Fault {
        String normalizedUri = uri.toASCIIString().replace(" ", "").replace("%2f", "%2F");
        JAXRSClientIT.assertContains(normalizedUri, URL + suffix);
    }

    protected static void assertConfigurationSnapshot(WebTarget target) throws JAXRSCommonClient.Fault {
        Set filters = target.getConfiguration().getInstances();
        Assertions.assertTrue((boolean)filters.contains(FILTER), (String)"The snapshot of configuration has not been taken");
    }
}

