/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.assembly.initorder.warejb;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.assembly.initorder.common.InitOrderRemoteIF;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;

@WebServlet(urlPatterns={"/TestServlet"}, loadOnStartup=1)
public class TestServlet
extends HttpTCKServlet {
    @Resource(lookup="java:app/AppName")
    private String appNameInjected;

    @PostConstruct
    private void postConstruct() {
        Helper.getLogger().info("In postConstruct of " + String.valueOf((Object)this));
        TestServlet.getHelloBean().addRecord("TestServlet");
    }

    public void initOrder(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            List<String> expected = Arrays.asList("TestServlet", "InitOrderBean");
            List<String> records = TestServlet.getHelloBean().getAndClearRecords();
            Helper.assertEquals(null, expected, records, reason);
            pw.println("Test PASSED");
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    public void appName(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        StringBuilder reason = new StringBuilder();
        try {
            String expected = "renamed";
            String lookup = "java:app/AppName";
            String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
            Helper.assertEquals("Check " + lookup, expected, actual, reason);
            Helper.assertEquals("Check appNameInjected ", expected, this.appNameInjected, reason);
            String s = "java:global/renamed/ejb3_assembly_initorder_warejb_ejb/InitOrderBean";
            InitOrderRemoteIF b = (InitOrderRemoteIF)ServiceLocator.lookupNoTry(s, new Context[0]);
            reason.append("Looked up InitOrderBean by global jndi name: " + s);
            reason.append(b.toString());
            s = "java:global/ejb3_assembly_initorder_warejb/ejb3_assembly_initorder_warejb_ejb/InitOrderBean";
            try {
                b = (InitOrderRemoteIF)ServiceLocator.lookup(s, new Context[0]);
                throw new RuntimeException("Expecting NamingException when looking up " + s + ", but got " + String.valueOf(b));
            }
            catch (NamingException e) {
                reason.append(" Got expected ").append(e).append(" when looking up ").append(s);
                pw.println("Test PASSED");
            }
        }
        catch (Exception e) {
            pw.println("Test FAILED");
            reason.append(TestUtil.printStackTraceToString((Throwable)e));
        }
        pw.println(reason.toString());
    }

    private static HelloRemoteIF getHelloBean() {
        return (HelloRemoteIF)ServiceLocator.lookupNoTry(HelloRemoteIF.GLOBAL_JNDI_NAME, new Context[0]);
    }
}

