/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.stateful.timeout.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.stateful.timeout.common.StatefulTimeoutIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBs;
import jakarta.ejb.NoSuchEJBException;

@EJBs(value={@EJB(name="defaultUnitBeanLocalName", beanName="DefaultUnitBean", beanInterface=StatefulTimeoutIF.class), @EJB(name="secondUnitBeanLocalName", beanName="SecondUnitBean", beanInterface=StatefulTimeoutIF.class)})
public abstract class ClientBase
extends EJBLiteClientBase {
    public static final String defaultUnitBeanLocalName = "defaultUnitBeanLocalName";
    public static final String defaultUnitBeanRemoteName = "defaultUnitBeanRemoteName";
    public static final String defaultUnitBeanNoInterfaceName = "defaultUnitBeanNoInterfaceName";
    public static final String secondUnitBeanLocalName = "secondUnitBeanLocalName";
    public static final String secondUnitBeanRemoteName = "secondUnitBeanRemoteName";
    public static final String secondUnitBeanNoInterfaceName = "secondUnitBeanNoInterfaceName";
    public static final String dayUnitBeanLocalName = "dayUnitBeanLocalName";
    public static final String hourUnitBeanLocalName = "hourUnitBeanLocalName";
    public static final String millisecondUnitBeanLocalName = "millisecondUnitBeanLocalName";
    public static final String microsecondUnitBeanLocalName = "microsecondUnitBeanLocalName";
    public static final String nanosecondUnitBeanLocalName = "nanosecondUnitBeanLocalName";
    public static final String minus1TimeoutBeanLocalName = "minus1TimeoutBeanLocalName";
    public static final String zeroTimeoutBeanLocalName = "zeroTimeoutBeanLocalName";

    protected StatefulTimeoutIF getMinus1TimeoutBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(minus1TimeoutBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getZeroTimeoutBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(zeroTimeoutBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getDefaultUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(defaultUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getDefaultUnitBeanRemote() {
        return (StatefulTimeoutIF)this.lookup(defaultUnitBeanRemoteName, null, null);
    }

    protected StatefulTimeoutIF getDefaultUnitBeanNoInterface() {
        return (StatefulTimeoutIF)this.lookup(defaultUnitBeanNoInterfaceName, null, null);
    }

    protected StatefulTimeoutIF getSecondUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(secondUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getSecondUnitBeanRemote() {
        return (StatefulTimeoutIF)this.lookup(secondUnitBeanRemoteName, null, null);
    }

    protected StatefulTimeoutIF getSecondUnitBeanNoInterface() {
        return (StatefulTimeoutIF)this.lookup(secondUnitBeanNoInterfaceName, null, null);
    }

    protected StatefulTimeoutIF getDayUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(dayUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getHourUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(hourUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getMillisecondUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(millisecondUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getMicrosecondUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(microsecondUnitBeanLocalName, null, null);
    }

    protected StatefulTimeoutIF getNanosecondUnitBeanLocal() {
        return (StatefulTimeoutIF)this.lookup(nanosecondUnitBeanLocalName, null, null);
    }

    @PostConstruct
    private void postConstruct() {
        Helper.getLogger().info("The test will wait for at least " + StatefulTimeoutIF.EXTRA_WAIT_SECONDS + " seconds before verifying the bean's timeout and removal.");
    }

    private void assertBeanRemoved(StatefulTimeoutIF b) {
        try {
            b.ping();
            throw new RuntimeException("Expecting NoSuchEJBException, but got none.");
        }
        catch (NoSuchEJBException e) {
            this.appendReason("Got expected NoSuchEJBException: " + String.valueOf((Object)e));
            return;
        }
    }

    private void assertBeanActive(StatefulTimeoutIF b) {
        b.ping();
        this.appendReason("The target bean is still active, as expected.");
    }

    private void defaultUnit(StatefulTimeoutIF b) {
        b.ping();
        TestUtil.sleepSec((int)50);
        this.assertBeanActive(b);
        TestUtil.sleepSec((int)((int)(60L + StatefulTimeoutIF.EXTRA_WAIT_SECONDS)));
        this.assertBeanRemoved(b);
    }

    private void secondUnit(StatefulTimeoutIF b) {
        b.ping();
        TestUtil.sleepSec((int)2);
        this.assertBeanActive(b);
        TestUtil.sleepSec((int)((int)(5L + StatefulTimeoutIF.EXTRA_WAIT_SECONDS)));
        this.assertBeanRemoved(b);
    }

    public void defaultUnitLocal() {
        this.defaultUnit(this.getDefaultUnitBeanLocal());
    }

    public void defaultUnitRemote() {
        this.defaultUnit(this.getDefaultUnitBeanRemote());
    }

    public void defaultUnitNoInterface() {
        this.defaultUnit(this.getDefaultUnitBeanNoInterface());
    }

    public void secondUnitLocal() {
        this.secondUnit(this.getSecondUnitBeanLocal());
    }

    public void secondUnitRemote() {
        this.secondUnit(this.getSecondUnitBeanRemote());
    }

    public void secondUnitNoInterface() {
        this.secondUnit(this.getSecondUnitBeanNoInterface());
    }

    public void dayUnitLocal() {
        StatefulTimeoutIF b = this.getDayUnitBeanLocal();
        b.ping();
        TestUtil.sleepSec((int)((int)StatefulTimeoutIF.EXTRA_WAIT_SECONDS));
        this.assertBeanActive(b);
    }

    public void minus1Timeout() {
        StatefulTimeoutIF b = this.getMinus1TimeoutBeanLocal();
        b.ping();
        TestUtil.sleepSec((int)((int)StatefulTimeoutIF.EXTRA_WAIT_SECONDS));
        this.assertBeanActive(b);
    }

    public void hourUnitLocal() {
        StatefulTimeoutIF b = this.getHourUnitBeanLocal();
        b.ping();
        TestUtil.sleepSec((int)((int)StatefulTimeoutIF.EXTRA_WAIT_SECONDS));
        this.assertBeanActive(b);
    }

    public void millisecondUnitLocal() {
        this.secondUnit(this.getMillisecondUnitBeanLocal());
    }

    public void microsecondUnitLocal() {
        this.secondUnit(this.getMicrosecondUnitBeanLocal());
    }

    public void nanosecondUnitLocal() {
        this.secondUnit(this.getNanosecondUnitBeanLocal());
    }

    public void zeroTimeout() {
        boolean passed = false;
        StatefulTimeoutIF b = this.getZeroTimeoutBeanLocal();
        try {
            b.ping();
        }
        catch (NoSuchEJBException e) {
            this.appendReason(new Object[]{"Got the expected ", e, TestUtil.NEW_LINE, b, " was removed immediately after lookup."});
            passed = true;
        }
        if (passed) {
            return;
        }
        TestUtil.sleepSec((int)((int)(5L + StatefulTimeoutIF.EXTRA_WAIT_SECONDS)));
        this.assertBeanRemoved(b);
    }
}

