/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.interceptor.aroundtimeout.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.timer.common.TimeoutStatusBean;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import jakarta.ejb.EJB;
import jakarta.ejb.Timer;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.util.logging.Level;

@EJB(name="timeoutStatusBean", beanInterface=TimeoutStatusBean.class)
public class InterceptorBase {
    private static final String simpleName = "InterceptorBase";

    @AroundTimeout
    private Object aroundTimeoutInInterceptorBase(InvocationContext inv) throws Exception {
        return InterceptorBase.handleAroundTimeout(inv, simpleName, this, "aroundTimeoutInInterceptorBase", new TimeoutStatusBean[0]);
    }

    public static Object handleAroundTimeout(InvocationContext inv, String record, Object component, String methodName, TimeoutStatusBean ... statusBean) throws Exception {
        InterceptorBase.addAroundInvokeRecord((Timer)inv.getTimer(), record, component, methodName, statusBean);
        return inv.proceed();
    }

    public static void addAroundInvokeRecord(Timer timer, String record, Object component, String methodName, TimeoutStatusBean ... statusBean) {
        TimeoutStatusBean sta = statusBean.length > 0 ? statusBean[0] : (TimeoutStatusBean)ServiceLocator.lookupByShortNameNoTry("timeoutStatusBean");
        String recordKey = TimerUtil.getTimerName(timer) + ".around-timeout";
        Helper.getLogger().logp(Level.FINE, record, methodName, "Adding around-timeout record: " + recordKey + " : " + record + ", requested by : " + String.valueOf(component));
        sta.addRecord(recordKey, record);
    }
}

