/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.elementcollection;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.Client1;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.Customer;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.CustomerXML;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"myMappingFile.xml"};
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "Customer", pkgName + "CustomerXML"};
        return this.createDeploymentJar("jpa_core_annotations_elementcollection2.jar", pkgNameWithoutSuffix, classes, xmlFile);
    }

    @BeforeEach
    public void setupCust() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeCustTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void elementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            logger.log(System.Logger.Level.TRACE, "Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                logger.log(System.Logger.Level.TRACE, "Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.TRACE, "phone:" + s);
                    }
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    for (String s : expectedphones) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + s);
                    }
                    logger.log(System.Logger.Level.ERROR, "actual:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicType failed");
        }
    }

    @Test
    public void elementCollectionBasicTypeXMLTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CustomerXML expected = new CustomerXML("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            logger.log(System.Logger.Level.TRACE, "Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Customer and Country and verify them");
            CustomerXML cust = (CustomerXML)this.getEntityManager().find(CustomerXML.class, (Object)expected.getId());
            if (cust != null) {
                logger.log(System.Logger.Level.TRACE, "Found CustomerXML: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.TRACE, "phone:" + s);
                    }
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    for (String s : expectedphones) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + s);
                    }
                    logger.log(System.Logger.Level.ERROR, "actual:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicTypeXMLTest failed");
        }
    }

    @AfterEach
    public void cleanupCust() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeCustTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeCustTestData() {
        logger.log(System.Logger.Level.TRACE, "removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

