/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeycolumn;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Department2;
import ee.jakarta.tck.persistence.core.annotations.mapkeycolumn.Employee;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static Employee[] empRef = new Employee[10];
    private static Department[] deptRef = new Department[5];
    private static Department2[] deptRef2 = new Department2[5];
    public Map<String, Employee> link = new HashMap<String, Employee>();

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Department2", pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_annotations_mapkeycolumn.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMapKeyColumnTest1() throws Exception {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e from Employee e where e.department.name = 'Marketing'").setMaxResults(10).getResultList();
            if (e.size() != 3) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected resultsExpected 3 Employees, Received: " + e.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "annotationMapKeyColumnTest1: Expected results received. Expected 3 Employees, Received: " + e.size());
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMapKeyColumnTest2() throws Exception {
        boolean pass = false;
        List e = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedEmps = new Integer[]{4, 2};
            logger.log(System.Logger.Level.TRACE, "find Employees belonging to Department: Marketing");
            e = this.getEntityManager().createQuery("Select e.id from Employee e where e.department.name = 'Administration' ORDER BY e.id DESC").setMaxResults(10).getResultList();
            Object[] result = e.toArray(new Integer[e.size()]);
            logger.log(System.Logger.Level.TRACE, "Compare results of Employee Ids ");
            pass = Arrays.equals(expectedEmps, result);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 Employees :  Received: " + e.size());
                Iterator it = e.iterator();
                while (it.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, " Employee PK : " + it.next());
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest2 failed");
        }
    }

    @Test
    public void annotationMapKeyColumnTest3() throws Exception {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(0);
        expected.add(2);
        expected.add(4);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (emps.size() == 3) {
                logger.log(System.Logger.Level.TRACE, "number of employees=" + emps.size());
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.TRACE, "id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                    actual.add(entry.getValue().getId() - 1);
                }
                Collections.sort(actual);
                if (expected.equals(actual)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected employees");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct employees");
                    logger.log(System.Logger.Level.ERROR, "Expected:");
                    for (Integer i : expected) {
                        logger.log(System.Logger.Level.TRACE, "id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName());
                    }
                    logger.log(System.Logger.Level.ERROR, "Actual:");
                    for (Integer i : actual) {
                        logger.log(System.Logger.Level.TRACE, "id=" + empRef[i].getId() + ", Name=" + empRef[i].getFirstName() + " " + empRef[i].getLastName());
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 3 employees, actual:" + emps.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("annotationMapKeyColumnTest3 Failed");
        }
    }

    @Test
    public void mapKeyColumnInsertableFalseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)3);
            if (dept != null) {
                logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
                Map<String, Employee> emps = dept.getLastNameEmployees();
                if (emps.size() == 0) {
                    logger.log(System.Logger.Level.TRACE, "Received expected number of employees");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected 0 employees, actual:" + emps.size());
                    logger.log(System.Logger.Level.ERROR, "Actual:");
                    for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                        logger.log(System.Logger.Level.ERROR, "id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Department2 returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("mapKeyColumnInsertableFalseTest Failed");
        }
    }

    @Test
    public void mapKeyColumnUpdatableFalseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find Department");
            Department2 dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            logger.log(System.Logger.Level.TRACE, "Dept=" + dept.getName());
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-006", empRef[6]);
            logger.log(System.Logger.Level.TRACE, "set last names of employees and save");
            dept.setLastNameEmployees(this.link);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find Department again");
            dept = (Department2)this.getEntityManager().find(Department2.class, (Object)deptRef2[0].getId());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (emps.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Received expected number of employees for department: " + deptRef2[0].getId());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 0 employees, actual:" + emps.size());
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.ERROR, "id=" + entry.getValue().getId() + ", Name=" + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("mapKeyColumnUpdatableFalseTest Failed");
        }
    }

    @Test
    public void criteriaBuilderKeysValuesTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("OFF-000");
        expected.add("OFF-002");
        expected.add("OFF-004");
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            System.out.println("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            System.out.println("Dept=" + dept.getName());
            Map<String, Employee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<String, Employee> entry : emps.entrySet()) {
                    logger.log(System.Logger.Level.TRACE, "map:" + entry.getKey() + ", " + entry.getValue().getId() + " " + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            Set<String> keys = emps.keySet();
            for (String key : keys) {
                logger.log(System.Logger.Level.TRACE, "key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected keys");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected keys");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (String key : expected) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (String key : keys) {
                    logger.log(System.Logger.Level.TRACE, "key:" + key);
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[2]);
            hashSet.add(empRef[4]);
            Collection<Employee> employees = emps.values();
            for (Employee e : employees) {
                logger.log(System.Logger.Level.TRACE, "values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected values");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not received expected values");
                logger.log(System.Logger.Level.ERROR, "Expected:");
                for (Employee e : hashSet) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
                logger.log(System.Logger.Level.ERROR, "Actual:");
                for (Employee e : employees) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("criteriaBuilderKeysValuesTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Create 2 Departments");
            Client.deptRef[0] = new Department(1, "Marketing");
            Client.deptRef[1] = new Department(2, "Administration");
            logger.log(System.Logger.Level.TRACE, "Start to persist departments ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                logger.log(System.Logger.Level.TRACE, "persisted department " + department.getName());
            }
            logger.log(System.Logger.Level.TRACE, "Create 2 Department2 ");
            Client.deptRef2[0] = new Department2(3, "IT");
            logger.log(System.Logger.Level.TRACE, "Start to persist Department2 ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted department " + ((Department2)serializable).getName());
            }
            logger.log(System.Logger.Level.TRACE, "Create 5 employees");
            Client.empRef[0] = new Employee(1, "Alan", "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(2, "Arthur", "Frechette");
            empRef[1].setDepartment(deptRef[1]);
            Client.empRef[2] = new Employee(3, "Shelly", "McGowan");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef[3] = new Employee(4, "Robert", "Bissett");
            empRef[3].setDepartment(deptRef[1]);
            Client.empRef[4] = new Employee(5, "Stephen", "DMilla");
            empRef[4].setDepartment(deptRef[0]);
            this.link.put("OFF-000", empRef[0]);
            this.link.put("OFF-002", empRef[2]);
            this.link.put("OFF-004", empRef[4]);
            deptRef[0].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-001", empRef[1]);
            this.link.put("OFF-003", empRef[3]);
            deptRef[1].setLastNameEmployees(this.link);
            this.link = new HashMap<String, Employee>();
            this.link.put("OFF-005", empRef[5]);
            deptRef2[0].setLastNameEmployees(this.link);
            logger.log(System.Logger.Level.TRACE, "Start to persist employees ");
            for (Serializable serializable : empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted employee " + ((Employee)serializable).getId());
            }
            logger.log(System.Logger.Level.TRACE, "Start to Merge department ");
            for (Serializable serializable : deptRef) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "merged department " + ((Department)serializable).getName());
            }
            logger.log(System.Logger.Level.TRACE, "Start to Merge department ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "merged department " + ((Department2)serializable).getName());
            }
            logger.log(System.Logger.Level.TRACE, "Start to persist employees ");
            for (Serializable serializable : empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted employee " + ((Employee)serializable).getId());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

