/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.ordercolumn;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Client1;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Course;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Department;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Department2;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Employee;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Employee2;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Student;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private List<Student> expectedResults;
    private List<Employee> expectedEmployees;
    private List<Employee2> expectedEmployees2;
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Course", pkgName + "Department", pkgName + "Department2", pkgName + "Employee", pkgName + "Employee2", pkgName + "Student"};
        return this.createDeploymentJar("jpa_core_annotations_ordercolumn2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupEmployee() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeEmployeeTestData();
            this.createEmployeeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void propertyAccessWithNameTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department d = (Department)this.getEntityManager().find(Department.class, (Object)50);
            logger.log(System.Logger.Level.INFO, "Display find data");
            for (Employee e : d.getEmployees()) {
                logger.log(System.Logger.Level.INFO, "Employee:" + e);
            }
            ArrayList<Employee> actual = new ArrayList<Employee>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 0", Employee.class);
            Employee emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 1", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 2", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees.size(); ++i) {
                    logger.log(System.Logger.Level.TRACE, "Testing - expected[" + this.expectedEmployees.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!this.expectedEmployees.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "count=" + count + ", expected size:" + this.expectedEmployees.size());
                    for (Employee e : this.expectedEmployees) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + e);
                    }
                    logger.log(System.Logger.Level.ERROR, "------------");
                    for (Employee e : actual) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + e);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected list size:" + this.expectedEmployees.size() + ", actual size:" + actual.size());
                for (Employee e : this.expectedEmployees) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + e);
                }
                logger.log(System.Logger.Level.ERROR, "------------");
                for (Employee e : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("propertyAccessWithNameTest test failed");
        }
    }

    @Test
    public void fieldAccessWithNameTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 d = (Department2)this.getEntityManager().find(Department2.class, (Object)55);
            logger.log(System.Logger.Level.INFO, "Display find data");
            for (Employee2 e : d.getEmployees()) {
                logger.log(System.Logger.Level.INFO, "Employee2:" + e);
            }
            ArrayList<Employee2> actual = new ArrayList<Employee2>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 0", Employee2.class);
            Employee2 emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 1", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 2", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                logger.log(System.Logger.Level.ERROR, "Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees2.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees2.size(); ++i) {
                    logger.log(System.Logger.Level.TRACE, "Testing - expected[" + this.expectedEmployees2.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!this.expectedEmployees2.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "count=" + count + ", expected size:" + this.expectedEmployees2.size());
                    for (Employee2 e : this.expectedEmployees2) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + e);
                    }
                    logger.log(System.Logger.Level.ERROR, "------------");
                    for (Employee2 e : actual) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + e);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected list size:" + this.expectedEmployees2.size() + ", actual size:" + actual.size());
                for (Employee2 e : this.expectedEmployees2) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + e);
                }
                logger.log(System.Logger.Level.ERROR, "------------");
                for (Employee2 e : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fieldAccessWithNameTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStudentTestData() {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData");
            this.getEntityTransaction().begin();
            Student student1 = new Student(1, "Neo");
            Student student2 = new Student(2, "Vivek");
            Student student3 = new Student(3, "Arun");
            Student student4 = new Student(4, "Ganesh");
            Student student5 = new Student(5, "Ram");
            Student student6 = new Student(6, "Rahim");
            Student student7 = new Student(7, "Joseph");
            Student student8 = new Student(8, "Krishna");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            Course operationResearch = new Course(103, "OperationResearch");
            Course statistics = new Course(201, "Statistics");
            Course operatingSystem = new Course(202, "OperatingSystem");
            ArrayList<Student> studentList1 = new ArrayList<Student>();
            studentList1.add(student1);
            studentList1.add(student7);
            studentList1.add(student2);
            studentList1.add(student8);
            this.expectedResults = new ArrayList<Student>();
            this.expectedResults.addAll(studentList1);
            ArrayList<Student> studentList2 = new ArrayList<Student>();
            studentList2.add(student3);
            studentList2.add(student4);
            ArrayList<Student> studentList3 = new ArrayList<Student>();
            studentList3.add(student5);
            studentList3.add(student6);
            ArrayList<Student> studentList4 = new ArrayList<Student>();
            studentList4.add(student7);
            studentList4.add(student8);
            appliedMath.setStudents(studentList1);
            physics.setStudents(studentList1);
            operationResearch.setStudents(studentList1);
            statistics.setStudents(studentList2);
            operatingSystem.setStudents(studentList2);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            firstSemCourses.add(operationResearch);
            ArrayList<Course> secondSemCourses = new ArrayList<Course>();
            secondSemCourses.add(statistics);
            secondSemCourses.add(operatingSystem);
            student1.setCourses(firstSemCourses);
            student2.setCourses(firstSemCourses);
            student3.setCourses(secondSemCourses);
            student4.setCourses(secondSemCourses);
            student5.setCourses(secondSemCourses);
            student6.setCourses(secondSemCourses);
            student7.setCourses(firstSemCourses);
            student8.setCourses(firstSemCourses);
            EntityManager entityManager = this.getEntityManager();
            entityManager.persist((Object)student1);
            entityManager.persist((Object)student2);
            entityManager.persist((Object)student3);
            entityManager.persist((Object)student4);
            entityManager.persist((Object)student5);
            entityManager.persist((Object)student6);
            entityManager.persist((Object)student7);
            entityManager.persist((Object)student8);
            logger.log(System.Logger.Level.TRACE, "persisted 8 students");
            entityManager.persist((Object)appliedMath);
            entityManager.persist((Object)physics);
            entityManager.persist((Object)operationResearch);
            entityManager.persist((Object)statistics);
            entityManager.persist((Object)operatingSystem);
            logger.log(System.Logger.Level.TRACE, "persisted 5 Courses");
            logger.log(System.Logger.Level.TRACE, "persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createEmployeeTestData");
            this.getEntityTransaction().begin();
            Department d1 = new Department(50, "Dept1");
            Department2 d2 = new Department2(55, "Dept2");
            this.getEntityManager().persist((Object)d1);
            Employee e1 = new Employee(20, "Jie", "Leng", 0.0f, d1);
            Employee e2 = new Employee(40, "Zoe", "Leng", 0.0f, d1);
            Employee e3 = new Employee(60, "John", "Smith", 0.0f, d1);
            Employee2 e4 = new Employee2(80, "Song", "Leng", 0.0f, d2);
            Employee2 e5 = new Employee2(100, "May", "Leng", 0.0f, d2);
            Employee2 e6 = new Employee2(120, "Donny", "Oz", 0.0f, d2);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            this.getEntityManager().persist((Object)e6);
            this.expectedEmployees = new ArrayList<Employee>();
            this.expectedEmployees.add(e3);
            this.expectedEmployees.add(e1);
            this.expectedEmployees.add(e2);
            d1.setEmployees(this.expectedEmployees);
            this.getEntityManager().merge((Object)d1);
            this.expectedEmployees2 = new ArrayList<Employee2>();
            this.expectedEmployees2.add(e6);
            this.expectedEmployees2.add(e4);
            this.expectedEmployees2.add(e5);
            d2.setEmployees(this.expectedEmployees2);
            this.getEntityManager().merge((Object)d2);
            logger.log(System.Logger.Level.TRACE, "persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanupEmployee() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanupEmployee");
            this.removeEmployeeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeEmployeeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeEmployeeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

