/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.version;

import ee.jakarta.tck.persistence.core.annotations.version.Client;
import ee.jakarta.tck.persistence.core.annotations.version.ShortClass_Field;
import ee.jakarta.tck.persistence.core.annotations.version.ShortClass_Property;
import ee.jakarta.tck.persistence.core.annotations.version.Short_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Short_Property;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "Int_Field", pkgName + "Int_Property", pkgName + "Integer_Field", pkgName + "Integer_Property", pkgName + "Long_Field", pkgName + "Long_Property", pkgName + "LongClass_Field", pkgName + "LongClass_Property", pkgName + "Short_Field", pkgName + "Short_Property", pkgName + "ShortClass_Field", pkgName + "ShortClass_Property", pkgName + "Timestamp_Field", pkgName + "Timestamp_Property"};
        return this.createDeploymentJar("jpa_core_annotations_version2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupShortData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupShortData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createShortTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void shortFieldTest() throws Exception {
        boolean pass = false;
        try {
            Short_Field a = (Short_Field)this.getEntityManager().find(Short_Field.class, (Object)"1");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                short version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Short_Field a1 = (Short_Field)this.getEntityManager().find(Short_Field.class, (Object)"1");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortFieldTest failed");
        }
    }

    @Test
    public void shortPropertyTest() throws Exception {
        boolean pass = false;
        try {
            Short_Property a = (Short_Property)this.getEntityManager().find(Short_Property.class, (Object)"2");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicShort());
                short version = a.getBasicShort();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Short_Property a1 = (Short_Property)this.getEntityManager().find(Short_Property.class, (Object)"2");
                if (a1 != null) {
                    if (a1.getBasicShort() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicShort());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicShort());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortPropertyTest failed");
        }
    }

    @Test
    public void shortClassFieldTest() throws Exception {
        boolean pass = false;
        try {
            ShortClass_Field a = (ShortClass_Field)this.getEntityManager().find(ShortClass_Field.class, (Object)"3");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                Short version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                ShortClass_Field a1 = (ShortClass_Field)this.getEntityManager().find(ShortClass_Field.class, (Object)"3");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortClassFieldTest failed");
        }
    }

    @Test
    public void shortClassPropertyTest() throws Exception {
        boolean pass = false;
        try {
            ShortClass_Property a = (ShortClass_Property)this.getEntityManager().find(ShortClass_Property.class, (Object)"4");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicShort());
                Short version = a.getBasicShort();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                ShortClass_Property a1 = (ShortClass_Property)this.getEntityManager().find(ShortClass_Property.class, (Object)"4");
                if (a1 != null) {
                    if (a1.getBasicShort() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicShort());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicShort());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("shortClassPropertyTest failed");
        }
    }

    public void createShortTestData() {
        logger.log(System.Logger.Level.TRACE, "createShortTestData");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)new Short_Field("1"));
            this.getEntityManager().persist((Object)new Short_Property("2"));
            this.getEntityManager().persist((Object)new ShortClass_Field("3", new Short(0)));
            this.getEntityManager().persist((Object)new ShortClass_Property("4", new Short(0)));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createShortTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

