/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.methodoverride;

import ee.jakarta.tck.persistence.core.callback.common.EntityCallbackClientBase;
import ee.jakarta.tck.persistence.core.callback.methodoverride.LineItem;
import ee.jakarta.tck.persistence.core.callback.methodoverride.Order;
import ee.jakarta.tck.persistence.core.callback.methodoverride.Product;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends EntityCallbackClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private Product product;
    private Order order;
    private LineItem lineItem;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "LineItem", pkgName + "Order", pkgName + "Product"};
        String[] xmlFiles = new String[]{"orm.xml"};
        return this.createDeploymentJar("jpa_core_callback_methodoverride.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void prePersistTest() throws Exception {
        String testName = "prePersistTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("prePersistTest");
            this.getEntityManager().persist((Object)this.product);
            if (!this.product.isPrePersistCalled()) {
                String reason = "Product: prePersist was not called.";
                throw new Exception(reason);
            }
            String reason = "Product: prePersist was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void prePersistMultiTest() throws Exception {
        String testName = "prePersistMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("prePersistMultiTest");
            this.getEntityManager().persist((Object)this.product);
            List<String> expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "Product");
            List actual = this.product.getPrePersistCalls();
            this.compareResultList(expected, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void prePersistCascadeTest() throws Exception {
        String testName = "prePersistCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("prePersistCascadeTest");
            this.product = this.newProduct("prePersistCascadeTest");
            this.lineItem = this.newLineItem("prePersistCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            if (!this.order.isPrePersistCalled()) {
                String reason = "Order: prePersist was not called.";
                throw new Exception(reason);
            }
            String reason = "Order: prePersist was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            if (!this.lineItem.isPrePersistCalled()) {
                reason = "LineItem: prePersist was not called.";
                throw new Exception(reason);
            }
            reason = "LineItem: prePersist was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during prePersistCascadeTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void prePersistMultiCascadeTest() throws Exception {
        String testName = "prePersistMultiCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("prePersistMultiCascadeTest");
            this.product = this.newProduct("prePersistMultiCascadeTest");
            this.lineItem = this.newLineItem("prePersistMultiCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            List<String> expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "Order");
            List actual = this.order.getPrePersistCalls();
            this.compareResultList(expected, actual);
            expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "LineItem");
            actual = this.lineItem.getPrePersistCalls();
            this.compareResultList(expected, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveTest() throws Exception {
        String testName = "preRemoveTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preRemoveTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().remove((Object)this.product);
            if (!this.product.isPreRemoveCalled()) {
                String reason = "Product: preRemove was not called.";
                throw new Exception(reason);
            }
            String reason = "Product: preRemove was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.product = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preRemoveTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveMultiTest() throws Exception {
        String testName = "preRemoveMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preRemoveMultiTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().remove((Object)this.product);
            List<String> expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "Product");
            List actual = this.product.getPreRemoveCalls();
            this.compareResultList(expected, actual);
            this.product = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveCascadeTest() throws Exception {
        String testName = "preRemoveCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("preRemoveCascadeTest");
            this.product = this.newProduct("preRemoveCascadeTest");
            this.lineItem = this.newLineItem("preRemoveCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            this.getEntityManager().remove((Object)this.order);
            boolean b = this.order.isPreRemoveCalled();
            this.order = null;
            if (!b) {
                String reason = "Order: preRemove was not called.";
                throw new Exception(reason);
            }
            String reason = "Order: preRemove was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            if (!this.lineItem.isPreRemoveCalled()) {
                reason = "LineItem: preRemove was not called.";
                throw new Exception(reason);
            }
            reason = "LineItem: preRemove was called.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preRemoveCascadeTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preRemoveMultiCascadeTest() throws Exception {
        String testName = "preRemoveMultiCascadeTest";
        try {
            this.getEntityTransaction().begin();
            this.order = this.newOrder("preRemoveMultiCascadeTest");
            this.product = this.newProduct("preRemoveMultiCascadeTest");
            this.lineItem = this.newLineItem("preRemoveMultiCascadeTest");
            this.lineItem.setOrder(this.order);
            this.lineItem.setProduct(this.product);
            this.order.addLineItem(this.lineItem);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().persist((Object)this.order);
            this.getEntityManager().remove((Object)this.order);
            boolean b = this.order.isPreRemoveCalled();
            List<String> expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "Order");
            List actual = this.order.getPreRemoveCalls();
            this.compareResultList(expected, actual);
            expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "LineItem");
            actual = this.lineItem.getPreRemoveCalls();
            this.compareResultList(expected, actual);
            this.order = null;
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preRemoveMultiCascadeTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void preUpdateTest() throws Exception {
        String testName = "preUpdateTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("preUpdateTest");
            this.getEntityManager().persist((Object)this.product);
            this.product.setPrice(2.0);
            this.getEntityManager().persist((Object)this.product);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during preUpdateTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void postLoadTest() throws Exception {
        String testName = "postLoadTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("postLoadTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.product);
            Query q = this.getEntityManager().createQuery("select distinct p from Product p");
            List results = q.getResultList();
            logger.log(System.Logger.Level.TRACE, results.toString());
            if (!this.product.isPostLoadCalled()) {
                String reason = "Product: postLoad was not called even after the query result was returned.";
                throw new Exception(reason);
            }
            String reason = "Product: postLoad was called after the query result was returned.";
            logger.log(System.Logger.Level.TRACE, reason);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught during postLoadTest", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    @Test
    public void postLoadMultiTest() throws Exception {
        String testName = "postLoadMultiTest";
        try {
            this.getEntityTransaction().begin();
            this.product = this.newProduct("postLoadMultiTest");
            this.getEntityManager().persist((Object)this.product);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)this.product);
            Query q = this.getEntityManager().createQuery("select distinct p from Product p");
            List results = q.getResultList();
            logger.log(System.Logger.Level.TRACE, results.toString());
            List<String> expected = Arrays.asList("ListenerA", "ListenerB", "ListenerC", "Product");
            List actual = this.product.getPostLoadCalls();
            this.compareResultList(expected, actual);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Exception caught while rolling back TX", (Throwable)re);
            }
        }
    }

    private Product newProduct(String testName) {
        Product product = new Product();
        product.setTestName(testName);
        product.setId(testName);
        product.setName(testName);
        product.setPartNumber(1L);
        product.setPrice(1.0);
        product.setQuantity(1);
        return product;
    }

    private Order newOrder(String testName) {
        Order order = new Order(testName, 1.0);
        order.setTestName(testName);
        return order;
    }

    private LineItem newLineItem(String testName) {
        LineItem lineItem = new LineItem();
        lineItem.setTestName(testName);
        lineItem.setId(testName);
        lineItem.setQuantity(1);
        return lineItem;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM LINEITEM_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM ORDER_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

