/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.From;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Department;
import ee.jakarta.tck.persistence.common.schema30.Department_;
import ee.jakarta.tck.persistence.common.schema30.Employee;
import ee.jakarta.tck.persistence.common.schema30.UtilDepartmentEmployeeData;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client4
extends UtilDepartmentEmployeeData {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_from4.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapStringTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1, Marketing, Frechette");
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root department = cquery.from(Department.class);
            MapJoin mEmployee = department.joinMap("lastNameEmployees");
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1"));
            cquery.multiselect(new Selection[]{department.get(Department_.id), department.get(Department_.name), mEmployee.value().get("lastName")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            for (Tuple tuple : clist) {
                logger.log(System.Logger.Level.TRACE, "result:" + tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2));
                actual.add((CallSite)((Object)(tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2))));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results:");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapStringTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void joinMapStringJoinTypeTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1, Marketing, Frechette");
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root department = cquery.from(Department.class);
            MapJoin mEmployee = department.joinMap("lastNameEmployees", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)mEmployee.get("id"), (Object)"1"));
            cquery.multiselect(new Selection[]{department.get(Department_.id), department.get(Department_.name), mEmployee.value().get("lastName")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            for (Tuple tuple : clist) {
                logger.log(System.Logger.Level.TRACE, "result:" + tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2));
                actual.add((CallSite)((Object)(tuple.get(0) + ", " + tuple.get(1) + ", " + tuple.get(2))));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results:");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinMapStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void fromGetMapAttributeTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1, Alan, Frechette");
        expected.add("3, Shelly, McGowan");
        expected.add("5, Stephen, DMilla");
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root department = cquery.from(Department.class);
            cquery.where((Expression)cbuilder.equal((Expression)department.get("id"), (Object)1));
            cquery.select((Selection)department.get(Department_.lastNameEmployees));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List list = tquery.getResultList();
            for (Employee employee : list) {
                logger.log(System.Logger.Level.TRACE, " employee:" + employee.getId() + ", " + employee.getFirstName() + ", " + employee.getLastName());
                actual.add((CallSite)((Object)(employee.getId() + ", " + employee.getFirstName() + ", " + employee.getLastName())));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results:");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fromGetMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    @Test
    public void pathGetMapAttributeTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("1, Alan, Frechette");
        expected.add("3, Shelly, McGowan");
        expected.add("5, Stephen, DMilla");
        ArrayList<CallSite> actual = new ArrayList<CallSite>();
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            Root department = cquery.from(Department.class);
            cquery.where((Expression)cbuilder.equal((Expression)department.get("id"), (Object)1));
            cquery.select((Selection)department.get(Department_.lastNameEmployees));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List list = tquery.getResultList();
            for (Employee employee : list) {
                logger.log(System.Logger.Level.TRACE, " employee:" + employee.getId() + ", " + employee.getFirstName() + ", " + employee.getLastName());
                actual.add((CallSite)((Object)(employee.getId() + ", " + employee.getFirstName() + ", " + employee.getLastName())));
            }
            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results:");
                for (String string : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + string);
                }
                for (String string : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + string);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("pathGetMapAttributeTest failed");
        }
    }
}

