/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Address_;
import ee.jakarta.tck.persistence.common.schema30.CreditCard;
import ee.jakarta.tck.persistence.common.schema30.CreditCard_;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.LineItem_;
import ee.jakarta.tck.persistence.common.schema30.Order_;
import ee.jakarta.tck.persistence.common.schema30.Product_;
import ee.jakarta.tck.persistence.common.schema30.UtilOrderData;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilOrderData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_metamodelquery2.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Orders for Customer: Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Expression)cbuilder.parameter(String.class, "name"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("name", (Object)"Robert E. Bissett");
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest5() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all Customers with AXP Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin a = customer.join(Customer_.creditCards);
            cquery.where((Expression)cbuilder.equal((Expression)a.get(CreditCard_.type), (Expression)cbuilder.parameter(String.class, "ccard")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("ccard", (Object)"AXP");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "4", "5", "8", "9", "12", "15"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 7 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest5 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest8() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders where the total price is NOT less than $4500");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)order.get(Order_.totalPrice), (Number)4500).not());
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "11", "16"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest8 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest9() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders where the customer name is Karen R. Tegan OR the total price is less than $100");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Karen R. Tegan"), (Expression)cbuilder.lt((Expression)order.get(Order_.totalPrice), (Number)100)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "10", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 5 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest9 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest10() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders where line item quantity is 1 AND the order total less than 100 or customer name is Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin l = order.join(Order_.lineItemsCollection);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get(LineItem_.quantity), (Number)2), (Expression)cbuilder.lt((Expression)order.get(Order_.totalPrice), cbuilder.sum(cbuilder.sum(cbuilder.literal((Object)3), cbuilder.prod(cbuilder.literal((Object)54), (Number)2)), (Number)-8))), (Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9", "12", "13"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 4 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest10 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest11() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders with line item quantity < 2 for customer Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin l = order.join(Order_.lineItemsCollection);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.lt((Expression)l.get(LineItem_.quantity), (Number)2), (Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Robert E. Bissett")));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "9"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest11 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest12() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders with a total price BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get(Order_.totalPrice), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "14"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 5 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest12 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest13() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders with a total price NOT BETWEEN $1000 and $1200");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.between((Expression)order.get(Order_.totalPrice), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)).not()).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 15 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest13 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest14() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders that do not have approved Credit Cards");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isFalse((Expression)order.get(Order_.creditCard).get(CreditCard_.approved)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "7", "11", "13", "18", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 6 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest14 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest27() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all Orders with a total price greater than 1180");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.lt((Expression)cbuilder.parameter(Double.class, "dbl"), cbuilder.abs((Expression)order.get(Order_.totalPrice))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)1180.0);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "4", "5", "6", "11", "16", "17", "18"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 9 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Caught unexpected exception:", (Throwable)e);
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest29() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "finding a line item from order 1");
            LineItem li = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"1");
            logger.log(System.Logger.Level.TRACE, "LineItem found was:" + li.toString());
            logger.log(System.Logger.Level.TRACE, "find line items who are members of line item found");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isMember((Object)li, order.get((PluralAttribute)Order_.lineItemsCollection)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List actual = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (ee.jakarta.tck.persistence.common.schema30.Order o : actual) {
                    logger.log(System.Logger.Level.TRACE, "actual:" + o.toString());
                    for (LineItem li2 : o.getLineItemsCollection()) {
                        logger.log(System.Logger.Level.TRACE, "   LineItems:" + li2.toString());
                    }
                }
            }
            String[] expectedPKs = new String[]{this.orderRef[0].getId()};
            if (!this.checkEntityPK(actual, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest29 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest30() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "finding a line item from order 11");
            LineItem li = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"11");
            logger.log(System.Logger.Level.TRACE, "LineItem found was:" + li.toString());
            logger.log(System.Logger.Level.TRACE, "find orders who have line items that are not members of the line item found");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotMember((Object)li, order.get((PluralAttribute)Order_.lineItemsCollection)));
            cquery.select((Selection)order);
            cquery.distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List actual = tquery.getResultList();
            Collections.sort(actual);
            String[] expectedPKs = new String[]{this.orderRef[0].getId(), this.orderRef[1].getId(), this.orderRef[2].getId(), this.orderRef[4].getId(), this.orderRef[5].getId(), this.orderRef[6].getId(), this.orderRef[7].getId(), this.orderRef[8].getId(), this.orderRef[9].getId(), this.orderRef[10].getId(), this.orderRef[11].getId(), this.orderRef[12].getId(), this.orderRef[13].getId(), this.orderRef[14].getId(), this.orderRef[15].getId(), this.orderRef[16].getId(), this.orderRef[17].getId(), this.orderRef[18].getId(), this.orderRef[19].getId()};
            if (!this.checkEntityPK(actual, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected:" + expectedPKs.length + " references, got: " + actual.size());
                if (TestUtil.traceflag) {
                    for (ee.jakarta.tck.persistence.common.schema30.Order o : actual) {
                        logger.log(System.Logger.Level.TRACE, "actual:" + o.toString());
                        for (LineItem li2 : o.getLineItemsCollection()) {
                            logger.log(System.Logger.Level.TRACE, "   LineItems:" + li2.toString());
                        }
                    }
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest30 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest32() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders where line items are members of the orders");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root l = cquery.from(LineItem.class);
            cquery.where((Expression)cbuilder.isMember((Expression)l, order.get((PluralAttribute)Order_.lineItemsCollection)));
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[this.orderRef.length];
            for (int i = 0; i < this.orderRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + this.orderRef.length + "references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest32 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest33() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find orders whose orders are do NOT contain the specified line items");
            LineItem liDvc = (LineItem)this.getEntityManager().find(LineItem.class, (Object)"30");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)cbuilder.parameter(LineItem.class, "liDvc"), order.get((PluralAttribute)Order_.lineItemsCollection)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("liDvc", (Object)liDvc);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 19 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest33 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest34() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find orders who have Samples in their orders");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isMember((Expression)order.get(Order_.sampleLineItem), order.get((PluralAttribute)Order_.lineItemsCollection)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "6"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest34 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest35() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders which contain lineitems not of quantities 1 or 5");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin l = order.join(Order_.lineItemsCollection);
            cquery.where((Expression)l.get(LineItem_.quantity).in(new Object[]{1, 5}).not());
            cquery.select((Selection)order).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 9 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest35 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest39() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find customers with specific credit card balance");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin b = customer.join(Customer_.creditCards);
            cquery.where((Expression)cbuilder.equal(cbuilder.sqrt((Expression)b.get(CreditCard_.balance)), (Expression)cbuilder.parameter(Double.class, "dbl")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("dbl", (Object)50.0);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest39 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest42() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all orders where related customer name is not null");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)order.get(Order_.customer).get(Customer_.name)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(olist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 19 references, got: " + olist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest42 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest48() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedBalances = new Double[]{400.0, 500.0, 750.0, 1000.0, 1400.0, 1500.0, 2000.0, 2500.0, 4400.0, 5000.0, 5500.0, 7000.0, 7400.0, 8000.0, 9500.0, 13000.0, 15000.0, 23000.0};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find all credit card balances");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order.get(Order_.creditCard).get(CreditCard_.balance)).distinct(true);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get(Order_.creditCard).get(CreditCard_.balance))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List olist = tquery.getResultList();
            Object[] result = olist.toArray(new Double[olist.size()]);
            if (TestUtil.traceflag) {
                for (Double d : olist) {
                    logger.log(System.Logger.Level.TRACE, "query results returned:  " + d);
                }
            }
            logger.log(System.Logger.Level.TRACE, "Compare expected results to query results");
            pass = Arrays.equals(expectedBalances, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest48 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest60() throws Exception {
        boolean pass = false;
        String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find Customers with an Order");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join(Customer_.orders);
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest60 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest62() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.ge(cbuilder.size(customer.get((PluralAttribute)Customer_.orders)), (Number)2));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"4", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest62 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest63() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.size(customer.get((PluralAttribute)Customer_.orders)), (Number)100));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest63 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest65() throws Exception {
        boolean pass = false;
        String s1 = "4";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            logger.log(System.Logger.Level.TRACE, "find MINIMUM order id for Robert E. Bissett");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Robert E. Bissett")).select((Selection)cbuilder.least((Expression)order.get(Order_.id)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            String s2 = (String)tquery.getSingleResult();
            if (s2.equals("4")) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "queryTest65 returned " + s2 + "expected: 4");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest65 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest66() throws Exception {
        boolean pass = false;
        Integer i1 = 8;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            logger.log(System.Logger.Level.TRACE, "find MAXIMUM number of lineItem quantities available an order may have");
            CriteriaQuery cquery = cbuilder.createQuery(Integer.class);
            Root l = cquery.from(LineItem.class);
            cquery.select((Selection)cbuilder.max((Expression)l.get(LineItem_.quantity)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Integer i2 = (Integer)tquery.getSingleResult();
            if (i2.equals(i1)) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "queryTest66 returned:" + i2 + "expected: " + i1);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest66 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void queryTest67() throws Exception {
        boolean pass = false;
        Double d1 = 1487.29;
        Double d2 = 1487.3;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            logger.log(System.Logger.Level.TRACE, "find AVERAGE price of all orders");
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.avg((Expression)order.get(Order_.totalPrice)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Double d3 = (Double)tquery.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                logger.log(System.Logger.Level.TRACE, "queryTest67 returned expected results: " + d1);
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "queryTest67 returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest67 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_leftouterjoin_Mx1() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"15", "14"}, {"16", "14"}};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join c = order.join(Order_.customer, JoinType.LEFT);
            cquery.where((Expression)cbuilder.equal((Expression)c.get(Customer_.name), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.multiselect(new Selection[]{order.get(Order_.id), c.get(Customer_.id)});
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)order.get(Order_.id))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            tquery.setMaxResults(this.orderRef.length);
            List q = tquery.getResultList();
            if (q.size() != 2) {
                logger.log(System.Logger.Level.TRACE, "test_leftouterjoin_Mx1:  Did not get expected results. Expected 2,  got: " + q.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    pass1 = true;
                    Object obj = q.get(i);
                    Object[] orderAndCustomerExpected = expectedResultSet[i];
                    Tuple orderAndCustomerTuple = null;
                    Object[] orderAndCustomer = null;
                    if (obj instanceof Tuple) {
                        logger.log(System.Logger.Level.TRACE, "The element in the result list is of type Object[], continue . . .");
                        orderAndCustomerTuple = (Tuple)obj;
                        orderAndCustomer = orderAndCustomerTuple.toArray();
                        if (Arrays.equals(orderAndCustomerExpected, orderAndCustomer)) continue;
                        logger.log(System.Logger.Level.ERROR, "Expecting element value: " + Arrays.asList(orderAndCustomerExpected) + ", actual element value: " + Arrays.asList(orderAndCustomer));
                        pass2 = false;
                        break;
                    }
                    logger.log(System.Logger.Level.ERROR, "The element in the result list is not of type Object[]:" + obj);
                    pass2 = false;
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_leftouterjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_groupBy_1() throws Exception {
        boolean pass = false;
        Object[] expectedTypes = new String[]{"AXP", "MCARD", "VISA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root cc = cquery.from(CreditCard.class);
            cc.join(CreditCard_.customer);
            cquery.select((Selection)cc.get(CreditCard_.type)).groupBy(new Expression[]{cc.get(CreditCard_.type)});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.creditCard.length);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedTypes, output);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 Credit Card Types: AXP, MCARD, VISA. Received: " + result.size());
                for (String s : result) {
                    logger.log(System.Logger.Level.TRACE, " Credit Card Type: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_groupBy_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_innerjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin cc = customer.join(Customer_.creditCards);
            cquery.where((Expression)cbuilder.equal((Expression)cc.get(CreditCard_.type), (Object)"VISA")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "10", "14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_innerjoin_Mx1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join c = order.join(Order_.customer);
            cquery.where((Expression)cbuilder.equal((Expression)c.get(Customer_.name), (Expression)cbuilder.parameter(String.class, "one")));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("one", (Object)"Kellie A. Sanborn");
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchPluralAttributeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch((PluralAttribute)Customer_.orders2);
            SetJoin o = customer.join(Customer_.orders2);
            SetAttribute pa = o.getModel();
            Fetch f1 = f.fetch((PluralAttribute)pa);
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals(Customer_.orders2.getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.orders2.getName() + ", actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchPluralAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchPluralAttributeJoinTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch((PluralAttribute)Customer_.orders2);
            SetJoin o = customer.join(Customer_.orders2);
            SetAttribute pa = o.getModel();
            Fetch f1 = f.fetch((PluralAttribute)pa, JoinType.INNER);
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals(Customer_.orders2.getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.orders2.getName() + ", actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchPluralAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchStringTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch("orders");
            Fetch f1 = f.fetch("creditCard");
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals("creditCard")) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:creditCard, actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchStringJoinTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch("orders");
            Fetch f1 = f.fetch("creditCard", JoinType.INNER);
            Attribute attr = f1.getAttribute();
            if (attr.getName().equals("creditCard")) {
                logger.log(System.Logger.Level.TRACE, "Received expected attribute:" + attr.getName());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected attribute:" + Customer_.orders.getName() + ", actual:" + attr.getName());
            }
            JoinType jt = f1.getJoinType();
            if (jt.equals((Object)JoinType.INNER)) {
                logger.log(System.Logger.Level.TRACE, "Received expected JoinType:" + jt.name());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected JoinType:" + JoinType.INNER.name() + ", actual:" + jt.name());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fetchFetchStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch("orders");
            try {
                Fetch f1 = f.fetch("doesnotexist");
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchFetchStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchFetchStringJoinTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Fetch f = customer.fetch("orders");
            try {
                Fetch f1 = f.fetch("doesnotexist", JoinType.INNER);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchFetchStringJoinTypeIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchPluralAttribute1xMTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch((PluralAttribute)Customer_.orders);
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.state).in(new Object[]{"NY", "RI"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchPluralAttribute1xMTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fetchPluralAttributeJoinType1xMTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch((PluralAttribute)Customer_.orders, JoinType.INNER);
            cquery.where((Expression)customer.get(Customer_.home).get(Address_.state).in(new Object[]{"NY", "RI"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fetchPluralAttributeJoinType1xMTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_fetchjoin_Mx1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            order.fetch(Order_.customer, JoinType.LEFT);
            cquery.where((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.home).get(Address_.city), (Object)"Lawrence")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"15", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_fetchjoin_Mx1_1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            order.fetch(Order_.customer, JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)order.get(Order_.customer).get(Customer_.name), "%Caruso")).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_Mx1_1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_notBetweenArithmetic() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.between((Expression)order.get(Order_.totalPrice), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0))));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "4", "5", "6", "9", "10", "11", "12", "13", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenArithmetic failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ANDconditionTT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)500)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ANDconditionTF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)10000)));
            cquery.select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ANDconditionFT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.id), (Object)"1001"), cbuilder.lt((Expression)order.get(Order_.totalPrice), (Number)1000)}).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ANDconditionFF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.id), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ANDconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ORconditionTT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)5000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ORconditionTF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.name), (Object)"Karen R. Tegan"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionTF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ORconditionFT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.id), (Object)"1001"), (Expression)cbuilder.lt((Expression)order.get(Order_.totalPrice), (Number)1000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "10", "12", "13", "15", "19", "20"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expectedPKs.length + " references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ORconditionFF() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)order.get(Order_.customer).get(Customer_.id), (Object)"1001"), (Expression)cbuilder.gt((Expression)order.get(Order_.totalPrice), (Number)10000))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 0) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ORconditionFF failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_groupByWhereClause() throws Exception {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Jonathan K. Smith", "Kellie A. Sanborn", "Robert E. Bissett"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            cquery.where((Expression)cbuilder.between((Expression)o.get(Order_.totalPrice), (Comparable)Double.valueOf(90.0), (Comparable)Double.valueOf(160.0))).groupBy(new Expression[]{customer.get(Customer_.name)}).select((Selection)customer.get(Customer_.name));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 Customers : Jonathan K. Smith, Kellie A. Sanborn and Robert E. Bissett. Received: " + result.size());
                for (String s : result) {
                    logger.log(System.Logger.Level.TRACE, " Customer: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_groupByWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_ABSHavingClause() throws Exception {
        boolean pass = false;
        Double expectedPrice = 10191.9;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Double.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)cbuilder.sum((Expression)order.get(Order_.totalPrice))).groupBy(new Expression[]{order.get(Order_.totalPrice)}).having((Expression)cbuilder.equal(cbuilder.abs((Expression)order.get(Order_.totalPrice)), (Expression)cbuilder.parameter(Double.class, "doubleValue")));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)5095.95);
            Object result = tquery.getSingleResult();
            if (expectedPrice.equals(result)) {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Expected results received");
            } else {
                logger.log(System.Logger.Level.ERROR, "test_ABSHavingClause:  Did not get expected results.Expected 10190, got: " + (Double)result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_ABSHavingClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_SQRTWhereClause() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "SQRT: Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.sqrt((Expression)order.get(Order_.totalPrice)), (Expression)cbuilder.parameter(Double.class, "doubleValue"))).select((Selection)order);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("doubleValue", (Object)70.0);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"11", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_SQRTWhereClause:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_SQRTWhereClause failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryGetSelectionGetParentTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(String.class);
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            AbstractQuery parent = sq.getParent();
            if (parent != null) {
                logger.log(System.Logger.Level.TRACE, "Received non-null parent query");
                if (parent instanceof CriteriaQuery || parent instanceof Subquery) {
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "getParent() did not return a query of type CriteriaQuery or Subquery:" + parent);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getParent() returned null");
            }
            Path selExpression1 = order2.get(Order_.id);
            sq.select((Expression)selExpression1);
            Expression selExpression2 = sq.getSelection();
            if (selExpression1.getJavaType().equals(selExpression2.getJavaType())) {
                logger.log(System.Logger.Level.TRACE, "Received expected selection expression" + selExpression1.getJavaType());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Receive unexpected expression - Expected:" + selExpression1.getJavaType() + ", actual" + selExpression2.getJavaType());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("subQueryGetSelectionGetParentTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryHavingExpressionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(String.class);
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            AbstractQuery parent = sq.getParent();
            if (parent != null) {
                logger.log(System.Logger.Level.TRACE, "Received non-null parent query");
                if (parent instanceof CriteriaQuery || parent instanceof Subquery) {
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "getParent() did not return a query of type CriteriaQuery or Subquery:" + parent);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "SubQuery.getParent returned null");
            }
            Path selExpression1 = order2.get(Order_.id);
            sq.select((Expression)selExpression1);
            Expression selExpression2 = sq.getSelection();
            if (selExpression1.getJavaType().equals(selExpression2.getJavaType())) {
                logger.log(System.Logger.Level.TRACE, "Received expected selection expression");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "SubQuery.getParent returned null");
            }
            sq.groupBy(new Expression[]{order2.get(Order_.id)});
            Predicate pred = sq.getGroupRestriction();
            if (pred == null) {
                logger.log(System.Logger.Level.TRACE, "Received null result from subquery.getGroupRestriction() when no restrictions exist");
                Predicate exp = cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"2"));
                sq.having((Expression)exp);
                Predicate exp2 = cbuilder.lessThanOrEqualTo((Expression)order2.get(Order_.id), (Comparable)((Object)"1"));
                sq.having((Expression)exp2);
                pred = sq.getGroupRestriction();
                if (pred != null) {
                    String[] expectedPKs;
                    logger.log(System.Logger.Level.TRACE, "Received non-null result from subquery.getGroupRestriction() when restrictions do exist");
                    cquery.where((Expression)cbuilder.in((Expression)order.get(Order_.id)).value((Expression)sq));
                    TypedQuery tquery = this.getEntityManager().createQuery(cquery);
                    List result = tquery.getResultList();
                    if (TestUtil.traceflag) {
                        for (ee.jakarta.tck.persistence.common.schema30.Order o : result) {
                            logger.log(System.Logger.Level.TRACE, "id:" + o.getId());
                        }
                    }
                    if (!this.checkEntityPK(result, expectedPKs = new String[]{"1"})) {
                        logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected results received");
                        pass3 = true;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received null result from subquery.getGroupRestriction() when restrictions do exist");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected null result from subquery.getGroupRestriction() when no restrictions exist:" + pred.toString());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2 | !pass3) {
            throw new Exception("subQueryHavingExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryHavingPredicateArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(String.class);
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select((Expression)order2.get(Order_.id));
            sq.groupBy(new Expression[]{order2.get(Order_.id)});
            Predicate[] predArray1 = new Predicate[]{cbuilder.greaterThan((Expression)order2.get(Order_.id), (Comparable)((Object)"3")), cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"4"))};
            sq.having(predArray1);
            Predicate[] predArray2 = new Predicate[]{cbuilder.greaterThan((Expression)order2.get(Order_.id), (Comparable)((Object)"1")), cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"2"))};
            sq.having(predArray2);
            cquery.where((Expression)cbuilder.in((Expression)order.get(Order_.id)).value((Expression)sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (ee.jakarta.tck.persistence.common.schema30.Order o : result) {
                    logger.log(System.Logger.Level.TRACE, "id:" + o.getId() + ", totalprice:" + o.getTotalPrice());
                }
            }
            String[] expectedPKs = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subQueryHavingPredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQuerySelectExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            String[] expectedPKs = new String[]{"11", "16"};
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Double.class);
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)order2.get(Order_.totalPrice)));
            sq.select(cbuilder.max((Expression)order2.get(Order_.totalPrice)));
            cquery.where((Expression)cbuilder.in((Expression)order.get(Order_.totalPrice)).value((Expression)sq));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            if (TestUtil.traceflag) {
                for (ee.jakarta.tck.persistence.common.schema30.Order o : result) {
                    logger.log(System.Logger.Level.TRACE, "id:" + o.getId() + ", totalprice:" + o.getTotalPrice());
                }
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subQuerySelectExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryWhereExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(String.class);
            logger.log(System.Logger.Level.TRACE, "Received null from subquery.getRestriction() when no restrictions exist");
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select((Expression)order2.get(Order_.id));
            Predicate exp1 = cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"2"));
            sq.where((Expression)exp1);
            Predicate exp2 = cbuilder.lessThanOrEqualTo((Expression)order2.get(Order_.id), (Comparable)((Object)"1"));
            sq.where((Expression)exp2);
            cquery.where((Expression)cbuilder.in((Expression)order.get(Order_.id)).value((Expression)sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (TestUtil.traceflag) {
                for (ee.jakarta.tck.persistence.common.schema30.Order o : result) {
                    logger.log(System.Logger.Level.TRACE, "id:" + o.getId());
                }
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subQueryWhereExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryWherePredicateArrayTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(String.class);
            Root order2 = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select((Expression)order2.get(Order_.id));
            Predicate[] predArray1 = new Predicate[]{cbuilder.greaterThan((Expression)order2.get(Order_.id), (Comparable)((Object)"3")), cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"4"))};
            sq.where(predArray1);
            Predicate[] predArray2 = new Predicate[]{cbuilder.greaterThan((Expression)order2.get(Order_.id), (Comparable)((Object)"1")), cbuilder.lessThan((Expression)order2.get(Order_.id), (Comparable)((Object)"2"))};
            sq.where(predArray2);
            cquery.where((Expression)cbuilder.in((Expression)order.get(Order_.id)).value((Expression)sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19"};
            if (TestUtil.traceflag) {
                for (ee.jakarta.tck.persistence.common.schema30.Order o : result) {
                    logger.log(System.Logger.Level.TRACE, "id:" + o.getId());
                }
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subQueryWherePredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subQueryDistinctTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass4 = false;
        boolean pass5 = true;
        boolean pass6 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(LineItem.class);
            Root lineItem = cquery.from(LineItem.class);
            cquery.select((Selection)lineItem);
            Subquery sq = cquery.subquery(String.class);
            String name = sq.getResultType().getName();
            if (name.equals("java.lang.String")) {
                logger.log(System.Logger.Level.TRACE, "Received expected type:" + name);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected type: java.lang.String, actual: " + name);
            }
            Root lineItem2 = sq.from(LineItem.class);
            sq.where((Expression)cbuilder.greaterThan((Expression)lineItem2.get(LineItem_.product).get(Product_.price), (Comparable)Double.valueOf(5000.0))).select((Expression)lineItem2.get(LineItem_.product).get(Product_.id));
            sq.distinct(true);
            boolean b = sq.isDistinct();
            if (b) {
                logger.log(System.Logger.Level.TRACE, "Received expected isDistinct result:" + b);
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected isDistinct: true, actual:" + b);
            }
            cquery.where((Expression)cbuilder.equal((Expression)lineItem.get(LineItem_.product).get(Product_.id), (Expression)sq));
            Set s = sq.getRoots();
            if (s.size() == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected size:" + s.size());
                for (Root r : s) {
                    pass4 = true;
                    name = r.getJavaType().getName();
                    if (name.equals("ee.jakarta.tck.persistence.common.schema30.LineItem")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected root:" + name);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected Root: ee.jakarta.tck.persistence.common.schema30.LineItem, actual:" + name);
                    pass5 = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected size: 1, actual:" + s.size());
            }
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"33", "44"};
            if (TestUtil.traceflag) {
                for (LineItem l : result) {
                    logger.log(System.Logger.Level.TRACE, " lineitem id:" + l.getId() + ", prod id:" + l.getProduct().getId() + ", prod price:" + l.getProduct().getPrice());
                }
            }
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass6 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass4 && pass5 && pass6)) {
            throw new Exception("subQueryDistinctTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_exists_02() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            CollectionJoin sqo = sqc.join(Customer_.orders);
            sq.where((Expression)cbuilder.gt((Expression)sqo.get(Order_.totalPrice), (Number)1500.0));
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_exists_02:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_exists_02 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_like() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = cquery.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            cquery.select((Selection)order);
            Subquery sq = cquery.subquery(Customer.class);
            Root sqo = sq.correlate(order);
            Join sqc = sqo.join(Order_.customer);
            sq.where((Expression)cbuilder.like((Expression)sqc.get(Customer_.name), "%Caruso")).select((Expression)sqc);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.orderRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "8"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_like:  Did not get expected  results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_like failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_between() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute query for test_subquery_between");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root sqc = sq.correlate(customer);
            CollectionJoin sqo = sqc.join(Customer_.orders);
            sq.where((Expression)cbuilder.between((Expression)sqo.get(Order_.totalPrice), (Comparable)Double.valueOf(1000.0), (Comparable)Double.valueOf(1200.0)));
            cquery.where((Expression)cbuilder.exists(sq));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "3", "7", "8", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_between:  Did not get expected  results.  Expected 5 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_between failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_join() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sqo = sq.correlate((Join)o);
            From f = sqo.getCorrelationParent();
            String name = f.getModel().getBindableJavaType().getSimpleName();
            if (name.equals("Order")) {
                logger.log(System.Logger.Level.TRACE, "Received expected CorrelationParent:" + name);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected CorrelationParent: Order, actual:" + name);
            }
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception(" test_subquery_join failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void getCorrelationParentIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Root order = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = order.join(Order_.lineItemsCollection);
            boolean b = sql.isCorrelated();
            if (!b) {
                logger.log(System.Logger.Level.TRACE, "Received expected result from isCorrelated(): false");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected false from isCorrelated(), actual:" + b);
            }
            try {
                From f = sql.getCorrelationParent();
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
                logger.log(System.Logger.Level.ERROR, "getCorrelationParent() returned:" + f);
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getCorrelationParentIllegalStateExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subquerySetJoinTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin o = customer.join(Customer_.orders2);
            SetAttribute pa = o.getModel();
            String paName = pa.getCollectionType().name();
            if (paName.equals("SET")) {
                logger.log(System.Logger.Level.TRACE, "Received expected PluralAttribute:" + paName);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected PluralAttribute: SET, actual: " + paName);
            }
            SetAttribute sa = o.getModel();
            String saName = sa.getName();
            if (saName.equals("orders2")) {
                logger.log(System.Logger.Level.TRACE, "Received expected SetAttribute:" + saName);
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected SetAttribute: orders2, actual: " + saName);
            }
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            SetJoin sqo = sq.correlate(o);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("subquerySetJoinTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subqueryListJoinTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin o = customer.join(Customer_.orders3);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            ListJoin sqo = sq.correlate(o);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subqueryListJoinTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void subqueryCollectionJoinTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(ee.jakarta.tck.persistence.common.schema30.Order.class);
            Join sqo = sq.correlate((Join)o);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3)).select((Expression)sqo);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.exists(sq));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "9", "11", "13", "16"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_join:  Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("subqueryCollectionJoinTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_GT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin l = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)l.get(LineItem_.quantity), (Number)3));
            sq.select((Expression)sqo.get(Order_.totalPrice));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.gt((Expression)o.get(Order_.totalPrice), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"5", "10", "14", "15"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_GT:  Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_ALL_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_LT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3));
            sq.select((Expression)sqo.get(Order_.totalPrice));
            cquery.where((Expression)cbuilder.lt((Expression)o.get(Order_.totalPrice), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_LT:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_EQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get(Order_.totalPrice)));
            cquery.where((Expression)cbuilder.equal((Expression)o.get("totalPrice"), cbuilder.all(sq)));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_EQ:  Did not get expected results.  Expected 1 reference, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_LTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.gt((Expression)sql.get(LineItem_.quantity), (Number)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get(Order_.totalPrice), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"9", "12"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_LTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_GTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.ge((Expression)sql.get(LineItem_.quantity), (Number)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get(Order_.totalPrice), cbuilder.all(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_GTEQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_GTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ALL_NOTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.min((Expression)sqo.get(Order_.totalPrice)));
            cquery.where((Expression)cbuilder.notEqual((Expression)o.get(Order_.totalPrice), cbuilder.all(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ALL_NOTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ALL_NOTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ANY_GT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.equal((Expression)sql.get(LineItem_.quantity), (Object)3));
            cquery.where((Expression)cbuilder.gt((Expression)o.get(Order_.totalPrice), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ANY_GT:  Did not get expected results.   Expected 16 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_GT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ANY_LT() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.equal((Expression)sql.get(LineItem_.quantity), (Object)3));
            cquery.where((Expression)cbuilder.lt((Expression)o.get(Order_.totalPrice), cbuilder.any(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ANY_LT:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_LT failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_ANY_EQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            sq.select(cbuilder.max((Expression)sqo.get(Order_.totalPrice)));
            cquery.where((Expression)cbuilder.equal((Expression)o.get(Order_.totalPrice), cbuilder.any(sq))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"10", "14"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_ANY_EQ:  Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_ANY_EQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_SOME_LTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.equal((Expression)sql.get(LineItem_.quantity), (Object)3));
            cquery.where((Expression)cbuilder.le((Expression)o.get(Order_.totalPrice), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_SOME_LTEQ:  Did not get expected results.  Expected 18 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception(" test_subquery_SOME_LTEQ failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void test_subquery_SOME_GTEQ() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin o = customer.join(Customer_.orders);
            Subquery sq = cquery.subquery(Double.class);
            Root sqo = sq.from(ee.jakarta.tck.persistence.common.schema30.Order.class);
            CollectionJoin sql = sqo.join(Order_.lineItemsCollection);
            sq.select((Expression)sqo.get(Order_.totalPrice));
            sq.where((Expression)cbuilder.equal((Expression)sql.get(LineItem_.quantity), (Object)3));
            cquery.where((Expression)cbuilder.ge((Expression)o.get(Order_.totalPrice), cbuilder.some(sq))).select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setMaxResults(this.customerRef.length);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_SOME_GTEQ:  Did not get expected results.  Expected 17 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_subquery_SOME_GTEQ failed");
        }
    }
}

