/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.misc;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.UtilSetup;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilSetup {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_misc1.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void predicateIsNegatedTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        logger.log(System.Logger.Level.INFO, "Testing default");
        Predicate pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1");
        Boolean result = pred.isNegated();
        if (!result.booleanValue()) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + result);
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected:false , actual:" + result);
        }
        pred = null;
        logger.log(System.Logger.Level.INFO, "Testing when Predicate.not is present");
        pred = cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1").not();
        result = pred.isNegated();
        if (result.booleanValue()) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + result);
            pass2 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected:true, actual:" + result);
        }
        pred = null;
        logger.log(System.Logger.Level.INFO, "Testing when CriteriaBuilder.not is present");
        pred = cbuilder.not((Expression)cbuilder.equal(cbuilder.literal((Object)"1"), (Object)"1"));
        result = pred.isNegated();
        if (result.booleanValue()) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + result);
            pass3 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected:true, actual:" + result);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateIsNegatedTest failed");
        }
    }

    @Test
    public void predicateBooleanOperatorTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.INFO, "Testing values()");
            Predicate.BooleanOperator[] results = Predicate.BooleanOperator.values();
            if (results.length == 2) {
                if (results[0].equals((Object)Predicate.BooleanOperator.AND) && results[1].equals((Object)Predicate.BooleanOperator.OR) || results[0].equals((Object)Predicate.BooleanOperator.OR) && results[1].equals((Object)Predicate.BooleanOperator.AND)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected values from values()");
                    pass1 = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected number of values: 2, actual:" + results.length);
            }
            logger.log(System.Logger.Level.INFO, "Testing valueOf(...)");
            for (Predicate.BooleanOperator pb : Predicate.BooleanOperator.values()) {
                logger.log(System.Logger.Level.TRACE, "Testing:" + pb.name());
                try {
                    Predicate.BooleanOperator.valueOf((String)pb.name());
                    pass2 = true;
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received unexpected IllegalArgumentException exception");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            }
            logger.log(System.Logger.Level.INFO, "Testing valueOf(Invalid_value)");
            try {
                Predicate.BooleanOperator.valueOf((String)"Invalid_value");
                logger.log(System.Logger.Level.ERROR, "Did not received IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected exception");
                pass3 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateBooleanOperatorTest failed");
        }
    }

    @Test
    public void predicateGetOperatorTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            logger.log(System.Logger.Level.INFO, "Testing default");
            Predicate predicate = cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1");
            Predicate.BooleanOperator result = predicate.getOperator();
            if (!result.equals((Object)Predicate.BooleanOperator.AND)) {
                logger.log(System.Logger.Level.ERROR, "Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name());
            } else {
                pass1 = true;
            }
            logger.log(System.Logger.Level.INFO, "Testing AND");
            predicate = cbuilder.and((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.AND)) {
                logger.log(System.Logger.Level.ERROR, "Expected:" + Predicate.BooleanOperator.AND.name() + ", actual:" + result.name());
            } else {
                pass2 = true;
            }
            logger.log(System.Logger.Level.INFO, "Testing OR");
            predicate = cbuilder.or((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"), (Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"));
            if (!predicate.getOperator().equals((Object)Predicate.BooleanOperator.OR)) {
                logger.log(System.Logger.Level.ERROR, "Expected:" + Predicate.BooleanOperator.OR.name() + ", actual:" + result.name());
            } else {
                pass3 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("predicateGetOperatorTest failed");
        }
    }

    @Test
    public void selectionGetCompoundSelectionItemsIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        Root customer = cquery.from(Customer.class);
        Expression sel = cbuilder.length((Expression)customer.get(Customer_.id));
        try {
            sel.getCompoundSelectionItems();
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.TRACE, "Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("selectionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void expressionIsCompoundSelectionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        boolean actual = exp.isCompoundSelection();
        if (!actual) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected isCompoundSelection() to return: false, actual:" + actual);
        }
        if (!pass) {
            throw new Exception("expressionGetCompoundSelectionItemsTest failed");
        }
    }

    @Test
    public void expressionGetCompoundSelectionItemsIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Expression exp = cbuilder.literal((Object)"1");
        try {
            exp.getCompoundSelectionItems();
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            logger.log(System.Logger.Level.TRACE, "Received IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("expressionGetCompoundSelectionItemsIllegalStateExceptionTest failed");
        }
    }

    @Test
    public void getRoots() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createTupleQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.from(Order.class);
                Set rootSet = cquery.getRoots();
                if (rootSet != null) {
                    if (rootSet.size() == 2) {
                        int count = 0;
                        boolean foundCustomer = false;
                        boolean foundOrder = false;
                        for (Root newRoot : rootSet) {
                            EntityType eType1 = newRoot.getModel();
                            String name = eType1.getName();
                            logger.log(System.Logger.Level.TRACE, "entityType Name = " + name);
                            if (name.equals("Customer")) {
                                logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                                foundCustomer = true;
                                ++count;
                            }
                            if (!name.equals("Order")) continue;
                            logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                            foundOrder = true;
                            ++count;
                        }
                        if (count == 2 && foundCustomer && foundOrder) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get Customer and Order roots back from getRoot");
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getRoots did not return 2 entries in the set");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getRoots returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getRoots test failed");
        }
    }

    @Test
    public void getSelection() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            logger.log(System.Logger.Level.INFO, "Testing non-compound selection");
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                cquery.select((Selection)customer);
                Selection _select = cquery.getSelection();
                if (_select != null) {
                    if (!_select.isCompoundSelection()) {
                        logger.log(System.Logger.Level.TRACE, "isCompoundSelection returned expected false");
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "isCompoundSelection returned true instead of false");
                    }
                    String javaName = _select.getJavaType().getName();
                    if (javaName.equals("ee.jakarta.tck.persistence.common.schema30.Customer")) {
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.common.schema30.Customer, actual:" + javaName);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "get Selection returned null");
                }
                logger.log(System.Logger.Level.INFO, "Testing compound selection");
                CriteriaQuery cquery1 = qbuilder.createQuery();
                customer = cquery1.from(Customer.class);
                EntityType CUSTOMER_ = customer.getModel();
                cquery1.multiselect(new Selection[]{customer.get(CUSTOMER_.getSingularAttribute("id", String.class)), customer.get(CUSTOMER_.getSingularAttribute("name", String.class))});
                Selection _select1 = cquery1.getSelection();
                if (_select1 != null) {
                    if (_select1.isCompoundSelection()) {
                        logger.log(System.Logger.Level.TRACE, "isCompoundSelection returned expected true");
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "isCompoundSelection returned false");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "get Selection returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getSelection failed");
        }
    }

    @Test
    public void getGroupList() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                Root customer = cquery.from(Customer.class);
                logger.log(System.Logger.Level.INFO, "Testing with NO group expressions");
                List groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 0) {
                        logger.log(System.Logger.Level.TRACE, "Received empty list from getGroupList");
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected : 0 Received :" + groupList.size());
                        for (Expression strExpr : groupList) {
                            logger.log(System.Logger.Level.ERROR, "Expression:" + strExpr.toString());
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getGroupList returned null instead of empty list when no groupby expressions have been specified");
                }
                logger.log(System.Logger.Level.INFO, "Testing with group expressions");
                Path e = customer.get("name");
                cquery.groupBy(new Expression[]{e});
                groupList = cquery.getGroupList();
                if (groupList != null) {
                    if (groupList.size() == 1) {
                        for (Expression strExpr : groupList) {
                            String sType = strExpr.getJavaType().getName();
                            if (sType.equals("java.lang.String")) {
                                logger.log(System.Logger.Level.TRACE, "Received expected type:" + sType);
                                pass2 = true;
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Expected type: java.lang.String, actual:" + sType);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected : 1 Received :" + groupList.size());
                        for (Expression strExpr : groupList) {
                            logger.log(System.Logger.Level.ERROR, "Actual expression:" + strExpr.toString());
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getGroupList returned null instead of a populated list when groupby expressions have been specified");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception groupBy: " + e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getGroupList failed");
        }
    }

    @Test
    public void isDistinct() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            if (cquery != null) {
                cquery.from(Customer.class);
                cquery.distinct(true);
                Boolean isDistinct = cquery.isDistinct();
                if (isDistinct.booleanValue()) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected excetion: " + e);
        }
        if (!pass) {
            throw new Exception("isDistinct test failed");
        }
    }

    @Test
    public void getResultType() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            Class resultType;
            CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            logger.log(System.Logger.Level.INFO, "Testing specific class return type");
            String expected = "ee.jakarta.tck.persistence.common.schema30.Customer";
            CriteriaQuery cquery = qbuilder.createQuery(Customer.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Got Expected Result Type");
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getResultType returned null instead of:" + expected);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query for:" + expected);
            }
            logger.log(System.Logger.Level.INFO, "Testing Tuple return type");
            expected = "jakarta.persistence.Tuple";
            cquery = qbuilder.createQuery(Tuple.class);
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Got Expected Result Type");
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getResultType returned null instead of:" + expected);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultType returned null instead of:" + expected);
            }
            logger.log(System.Logger.Level.INFO, "Testing Object return type");
            expected = "java.lang.Object";
            cquery = qbuilder.createQuery();
            if (cquery != null) {
                resultType = cquery.getResultType();
                if (resultType != null) {
                    if (resultType.getName().equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Got Expected Result Type");
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Received  UnExpected Result Type :" + resultType.getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getResultType returned null instead of:" + expected);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultType returned null instead of:" + expected);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception getGroupRestriction: " + e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("getResultType test failed");
        }
    }
}

