/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex2a;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex2a.DID2Dependent;
import ee.jakarta.tck.persistence.core.derivedid.ex2a.DID2DependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex2a.DID2Employee;
import ee.jakarta.tck.persistence.core.derivedid.ex2a.DID2EmployeeId;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID2Dependent", pkgName + "DID2DependentId", pkgName + "DID2Employee", pkgName + "DID2EmployeeId"};
        return this.createDeploymentJar("jpa_core_derivedid_ex2a.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID2EmployeeId eId1 = new DID2EmployeeId("Java", "Duke");
            DID2EmployeeId eId2 = new DID2EmployeeId("C", "foo");
            DID2Employee employee1 = new DID2Employee(eId1);
            DID2Employee employee2 = new DID2Employee(eId2);
            DID2DependentId dId1 = new DID2DependentId("Obama", eId1);
            DID2DependentId dId2 = new DID2DependentId("Michelle", eId1);
            DID2DependentId dId3 = new DID2DependentId("John", eId2);
            DID2Dependent dep1 = new DID2Dependent(dId1, employee1);
            DID2Dependent dep2 = new DID2Dependent(dId2, employee1);
            DID2Dependent dep3 = new DID2Dependent(dId3, employee2);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            DID2Dependent newDependent = (DID2Dependent)this.getEntityManager().find(DID2Dependent.class, (Object)new DID2DependentId("Obama", new DID2EmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2Dependent d where d.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

