/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex2b;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bDependent;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bDependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bEmployee;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bEmployeeId;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID2bDependent", pkgName + "DID2bDependentId", pkgName + "DID2bEmployee", pkgName + "DID2bEmployeeId"};
        return this.createDeploymentJar("jpa_core_derivedid_ex2b.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            DID2bEmployeeId eId1 = new DID2bEmployeeId("Java", "Duke");
            DID2bEmployeeId eId2 = new DID2bEmployeeId("C", "foo");
            DID2bEmployee employee1 = new DID2bEmployee(eId1);
            DID2bEmployee employee2 = new DID2bEmployee(eId2);
            DID2bDependent dep1 = new DID2bDependent(new DID2bDependentId("Obama", eId1), employee1);
            DID2bDependent dep2 = new DID2bDependent(new DID2bDependentId("Michelle", eId1), employee1);
            DID2bDependent dep3 = new DID2bDependent(new DID2bDependentId("John", eId2), employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            DID2bDependent newDependent = (DID2bDependent)this.getEntityManager().find(DID2bDependent.class, (Object)new DID2bDependentId("Obama", new DID2bEmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            List depList2 = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.id.empPK.firstName='Java'").getResultList();
            DID2bDependent newDependent2 = null;
            if (depList2.size() > 0) {
                newDependent2 = (DID2bDependent)depList2.get(0);
                if (newDependent2 == dep1) {
                    pass2 = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass1 || !pass2) {
            throw new Exception("DTDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

