/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex3a;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3Dependent;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3DependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3Employee;
import ee.jakarta.tck.persistence.core.derivedid.ex3a.DID3EmployeeId;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID3Dependent", pkgName + "DID3DependentId", pkgName + "DID3Employee", pkgName + "DID3EmployeeId"};
        return this.createDeploymentJar("jpa_core_derivedid_ex3a.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            DID3EmployeeId eId1 = new DID3EmployeeId("Java", "Duke");
            DID3EmployeeId eId2 = new DID3EmployeeId("C", "foo");
            DID3Employee employee1 = new DID3Employee(eId1);
            DID3Employee employee2 = new DID3Employee(eId2);
            DID3DependentId depId1 = new DID3DependentId("Obama", eId1);
            DID3DependentId depId2 = new DID3DependentId("Michelle", eId1);
            DID3DependentId depId3 = new DID3DependentId("John", eId2);
            DID3Dependent dep1 = new DID3Dependent(depId1, employee1);
            DID3Dependent dep2 = new DID3Dependent(depId2, employee1);
            DID3Dependent dep3 = new DID3Dependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            DID3Dependent newDependent = (DID3Dependent)this.getEntityManager().find(DID3Dependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID3Dependent d where d.name2='Obama' and d.emp.empId.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID3Dependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DTDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3DEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

