/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager.Client1;
import ee.jakarta.tck.persistence.core.entityManager.Employee;
import ee.jakarta.tck.persistence.core.entityManager.Order;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.StoredProcedureQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManager2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupOrderData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        logger.log(System.Logger.Level.TRACE, "in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                logger.log(System.Logger.Level.TRACE, "Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    logger.log(System.Logger.Level.TRACE, "Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            logger.log(System.Logger.Level.TRACE, "Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Employee, instead got:" + o.getClass().getName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    logger.log(System.Logger.Level.TRACE, "rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            logger.log(System.Logger.Level.TRACE, "Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:");
                    for (Integer n : actual) {
                        logger.log(System.Logger.Level.TRACE, "id:" + n);
                    }
                    ++count;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
                for (Integer n : expected) {
                    logger.log(System.Logger.Level.ERROR, " Expected id:" + n);
                }
                for (Integer n : actual) {
                    logger.log(System.Logger.Level.ERROR, "Actual id:" + n);
                }
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + e);
            }
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
            for (Employee e : expected) {
                logger.log(System.Logger.Level.ERROR, "expected employee:" + e);
            }
            for (Employee e : actual) {
                logger.log(System.Logger.Level.ERROR, "actual employee :" + e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    @Test
    public void persistExceptionsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Testing persisting an entity twice ");
        try {
            this.getEntityManager().detach((Object)this.orders[0]);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Try to persist an existing Order");
            this.getEntityManager().persist((Object)this.orders[0]);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "A PersistenceException was not thrown");
        }
        catch (EntityExistsException eee) {
            logger.log(System.Logger.Level.TRACE, "EntityExistsException Caught as Expected:", (Throwable)eee);
            pass1 = true;
        }
        catch (PersistenceException pe) {
            logger.log(System.Logger.Level.TRACE, "A PersistentException was caught:", (Throwable)pe);
            pass1 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing non-entity ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)this);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException caught as expected");
            pass2 = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("persistExceptionsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    @Test
    public void refreshRemovedObjectEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Finding Order");
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            logger.log(System.Logger.Level.TRACE, "Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            logger.log(System.Logger.Level.TRACE, "Refreshing previous order");
            this.getEntityManager().refresh((Object)o);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    @Test
    public void refreshRemovedObjectMapEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)2);
            logger.log(System.Logger.Level.TRACE, "Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            logger.log(System.Logger.Level.TRACE, "Refreshing previous order");
            this.getEntityManager().refresh((Object)o, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectMapEntityNotFoundExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    @Test
    public void refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)3);
            logger.log(System.Logger.Level.TRACE, "Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.TRACE, "Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    @Test
    public void refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            logger.log(System.Logger.Level.TRACE, "Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            logger.log(System.Logger.Level.TRACE, "Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                logger.log(System.Logger.Level.TRACE, "Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted employee:" + e);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

