/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager2;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManager2.DoesNotExist;
import ee.jakarta.tck.persistence.core.entityManager2.Employee;
import ee.jakarta.tck.persistence.core.entityManager2.Order;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    Employee[] empRef = new Employee[5];
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
    String dataBaseName = null;
    static final String ORACLE = "oracle";

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DoesNotExist", pkgName + "Employee", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManager1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findExceptionsTest() throws Exception {
        int pass = 0;
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectIllegalArgumentException");
        logger.log(System.Logger.Level.INFO, "Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK");
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectMapIllegalArgumentException");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        logger.log(System.Logger.Level.TRACE, "Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectLockModeTypeIllegalArgumentException");
        logger.log(System.Logger.Level.INFO, "Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, LockModeType.NONE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectLockModeTypeTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                logger.log(System.Logger.Level.TRACE, "A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            } else {
                logger.log(System.Logger.Level.TRACE, "No transaction is active");
            }
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectLockModeTypeMapIllegalArgumentException");
        logger.log(System.Logger.Level.INFO, "Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client1.class, (Object)1, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        logger.log(System.Logger.Level.INFO, "Testing findClassObjectLockModeTypeMapTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                logger.log(System.Logger.Level.TRACE, "A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)0, LockModeType.PESSIMISTIC_READ, myMap);
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (pass != 14) {
            throw new Exception("findExceptionsTest failed");
        }
    }

    @Test
    public void flushExceptionsTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.ERROR, "TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException e) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("flushExceptionsTest failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback1Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback1Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback2Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist");
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback2Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback3Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist", PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback3Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback4Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedStoredProcedureQuery("doesnotexist");
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback5Test() throws Exception {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaDelete cd = cbuilder.createCriteriaDelete(DoesNotExist.class);
                cd.from(DoesNotExist.class);
                try {
                    Query q = this.getEntityManager().createQuery(cd);
                    logger.log(System.Logger.Level.INFO, "RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.", (Throwable)e);
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
                        break block17;
                    }
                    logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred while creating CriteriaDelete", (Throwable)e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
                }
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback6Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(PMClientBase.class);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            logger.log(System.Logger.Level.INFO, "RuntimeException wasn't thrown, try executing it");
            q.executeUpdate();
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback7Test() throws Exception {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaUpdate cu = cbuilder.createCriteriaUpdate(DoesNotExist.class);
                Root root = cu.from(DoesNotExist.class);
                cu.where((Expression)cbuilder.equal((Expression)root.get("id"), (Object)1));
                cu.set(root.get("firstName"), (Object)"foobar");
                try {
                    Query q = this.getEntityManager().createQuery(cu);
                    logger.log(System.Logger.Level.INFO, "RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
                        break block17;
                    }
                    logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred while creating CriteriaUpdate", (Throwable)e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
                }
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback7Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback8Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid");
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback8Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback9Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid", PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback9Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback10Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist");
            logger.log(System.Logger.Level.INFO, "RuntimeException not thrown, try executing it");
            spq.execute();
            logger.log(System.Logger.Level.ERROR, "RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback10Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback11Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new Class[]{PMClientBase.class});
            logger.log(System.Logger.Level.INFO, "RuntimeException not thrown, try executing it");
            spq.execute();
            logger.log(System.Logger.Level.ERROR, "RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback11Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback12Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new String[]{"doesnotexist"});
            logger.log(System.Logger.Level.INFO, "RuntimeException not thrown, try executing it");
            spq.execute();
            logger.log(System.Logger.Level.ERROR, "RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback12Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback13Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback13Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback14Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist");
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback14Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback15Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback15Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback16Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback16Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback17Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", this.map);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback17Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback21Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getLockMode(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback21Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback23Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getReference(PMClientBase.class, (Object)"doesnotexist");
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback23Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback24Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback24Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback25Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback25Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback26Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback26Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback27Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback27Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback28Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback28Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback29Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback29Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback30Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE, this.map);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback30Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback31Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, this.map);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback31Test failed");
        }
    }

    @Test
    public void entityManagerMethodsRuntimeExceptionsCauseRollback32Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove(PMClientBase.class);
            logger.log(System.Logger.Level.ERROR, "RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            logger.log(System.Logger.Level.TRACE, "RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            } else {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("entityManagerMethodsRuntimeExceptionsCauseRollback32Test failed");
        }
    }
}

