/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.persist.basic;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.persist.basic.A;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        return this.createDeploymentJar("jpa_core_entitytest_persist_basic.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest1");
        boolean pass = false;
        try {
            A aRef = new A("1", "A1", 1);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest2");
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "new A");
            A aRef = new A("2", "a2", 2);
            this.createA(aRef);
            A newA = this.findA("2");
            if (newA != null) {
                logger.log(System.Logger.Level.TRACE, "A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA("2"));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("3", "a3", 3);
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "find By Name");
            A result = (A)this.findByName("a3");
            logger.log(System.Logger.Level.TRACE, "Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest4");
        A aRef = new A("4", "a4", 4);
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(this.findA("4"))) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, try to persist again ");
                    A newA = this.findA("4");
                    this.getEntityManager().persist((Object)newA);
                    logger.log(System.Logger.Level.TRACE, "Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist an already persisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest5");
        A aRef = new A("5", "a5", 5);
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(this.findA("5"))) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, try to change name and flush ");
                    A a2 = this.findA("5");
                    a2.setAName("a2");
                    this.getEntityManager().flush();
                    if (a2.getAName().equals("a2")) {
                        logger.log(System.Logger.Level.TRACE, "sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to flush apersisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        logger.log(System.Logger.Level.TRACE, "Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

