/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.entitytype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.entitytype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.entitytype.DID2Employee;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "B", pkgName + "DID2Employee", pkgName + "DID2EmployeeId", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_entitytype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getName() throws Exception {
        boolean pass = false;
        String expected = "A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String name = eType.getName();
                if (name.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName failed");
        }
    }

    @Test
    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                logger.log(System.Logger.Level.TRACE, "entityType Name = A");
                SingularAttribute idAttrib = eType.getDeclaredId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    @Test
    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A IdentifiableType");
                try {
                    eType.getDeclaredId(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                SingularAttribute idAttrib = eType.getDeclaredVersion(Integer.class);
                String name = idAttrib.getName();
                if (name.equals("value")) {
                    logger.log(System.Logger.Level.TRACE, "Received:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: value, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    @Test
    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getDeclaredVersion(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getId(String.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.String")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected: " + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.String, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    @Test
    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
                try {
                    eType.getId(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    @Test
    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        HashSet<String> expected = new HashSet<String>();
        expected.add("firstName");
        expected.add("lastName");
        HashSet<String> actual = new HashSet<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(DID2Employee.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                Set idClassAttribSet = eType.getIdClassAttributes();
                if (idClassAttribSet != null) {
                    if (idClassAttribSet.size() > 0) {
                        for (SingularAttribute attrib : idClassAttribSet) {
                            actual.add(attrib.getName());
                        }
                        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected attributes");
                            for (String id : expected) {
                                logger.log(System.Logger.Level.TRACE, "id:" + id);
                            }
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Received Unexpected ids");
                            logger.log(System.Logger.Level.ERROR, "Expected:");
                            for (String id : expected) {
                                logger.log(System.Logger.Level.ERROR, "id:" + id);
                            }
                            logger.log(System.Logger.Level.ERROR, "Actual:");
                            for (String attribName : actual) {
                                logger.log(System.Logger.Level.ERROR, "attrib:" + attribName);
                            }
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getIdClassAttributes() returned 0 items");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getIdClassAttributes() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    @Test
    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                try {
                    eType.getIdClassAttributes();
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    @Test
    public void getIdType() throws Exception {
        boolean pass = false;
        String expected = "java.lang.String";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                Type type = eType.getIdType();
                String sType = type.getJavaType().getName();
                if (sType.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received:" + sType);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + sType);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdType failed");
        }
    }

    @Test
    public void getSupertype() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.entitytype.B";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                IdentifiableType idType = eType.getSupertype();
                String name = idType.getJavaType().getName();
                if (name.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "getSuperType() returned:" + name);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: " + expected + ", actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSupertype failed");
        }
    }

    @Test
    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null EntityType");
                SingularAttribute idAttrib = eType.getVersion(Integer.class);
                String name = idAttrib.getType().getJavaType().getName();
                if (name.equals("java.lang.Integer")) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected java.lang.Integer, actual:" + name);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    @Test
    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained A Entity");
                try {
                    eType.getVersion(Date.class);
                    logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    pass = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    @Test
    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + eType.getName());
                boolean hasSingleIdAttribute = eType.hasSingleIdAttribute();
                if (hasSingleIdAttribute) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasSingleIdAttribute);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    @Test
    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                logger.log(System.Logger.Level.TRACE, "entityType Name = " + eType.getName());
                boolean hasVersionAttribute = eType.hasVersionAttribute();
                if (hasVersionAttribute) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "hasSingleIdAttribute() returned" + hasVersionAttribute);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: false, actual:" + hasVersionAttribute);
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    @Test
    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.entitytype.A";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableJavaType = eType.getBindableJavaType().getName();
                if (bindableJavaType != null) {
                    if (bindableJavaType.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result: " + bindableJavaType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected:" + expected + ", actual:" + bindableJavaType);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getName() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType failed");
        }
    }

    @Test
    public void getBindableType() throws Exception {
        boolean pass = false;
        String expected = Bindable.BindableType.ENTITY_TYPE.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(A.class);
            if (eType != null) {
                String bindableType = eType.getBindableType().name();
                if (bindableType != null) {
                    if (bindableType.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected result: " + bindableType);
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected:" + expected + ", actual:" + bindableType);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getBindableType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "entity(...) returned null");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

